/*
 * Decompiled with CFR 0.152.
 */
package com.eyezah.cosmetics;

import com.eyezah.cosmetics.Cosmetica;
import com.eyezah.cosmetics.utils.Base64Texture;
import com.eyezah.cosmetics.utils.Debug;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class CosmeticaSkinManager {
    private static Map<class_2960, Base64Texture> capeTextures = new HashMap<class_2960, Base64Texture>();
    private static Set<class_2960> uploaded = new HashSet<class_2960>();

    public static void clearCaches() {
        Debug.info("Clearing cosmetica skin caches", new Object[0]);
        capeTextures = new HashMap<class_2960, Base64Texture>();
        uploaded = new HashSet<class_2960>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUploaded(class_2960 id) {
        Set<class_2960> set = uploaded;
        synchronized (set) {
            return uploaded.contains(id);
        }
    }

    private static String pathify(String id) {
        StringBuilder result = new StringBuilder();
        for (char c : id.toCharArray()) {
            if (c == '+') {
                result.append(".");
                continue;
            }
            if (Character.isUpperCase(c)) {
                result.append("_").append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static class_2960 processCape(JsonObject object) {
        class_2960 id = new class_2960("cosmetica", CosmeticaSkinManager.pathify(object.get("id").getAsString()));
        if (!capeTextures.containsKey(id)) {
            try {
                Base64Texture cloakTex = new Base64Texture(id, object.get("image").getAsString().substring(22), true);
                RenderSystem.recordRenderCall(() -> {
                    class_310.method_1551().method_1531().method_4616(id, (class_1044)cloakTex);
                    Set<class_2960> set = uploaded;
                    synchronized (set) {
                        uploaded.add(id);
                    }
                });
                Debug.info("Registering cape texture for {}", id);
                capeTextures.put(id, cloakTex);
            }
            catch (IOException e) {
                Cosmetica.LOGGER.error("Error loading cape texture", (Throwable)e);
                return null;
            }
        }
        return id;
    }
}

