/*
 * Decompiled with CFR 0.152.
 */
package com.eyezah.cosmetics;

import com.eyezah.cosmetics.utils.CapeServerOption;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DefaultSettingsConfig {
    private final Path propertiesPath;
    private String capeId = "";
    private Map<String, CapeServerOption> capeServerSettings = new HashMap<String, CapeServerOption>();

    public DefaultSettingsConfig(Path propertiesPath) {
        this.propertiesPath = propertiesPath;
    }

    public String getCapeId() {
        return this.capeId;
    }

    public void initialize() throws IOException {
        this.load();
        if (!Files.exists(this.propertiesPath, new LinkOption[0])) {
            this.save();
        }
    }

    public void load() throws IOException {
        if (!Files.exists(this.propertiesPath, new LinkOption[0])) {
            return;
        }
        Properties properties = new Properties();
        properties.load(Files.newInputStream(this.propertiesPath, new OpenOption[0]));
        this.capeId = properties.getProperty("starter-cape-id");
        this.capeServerSettings.clear();
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyName.startsWith("cape-setting-")) continue;
            String service = propertyName.substring(13);
            CapeServerOption value = CapeServerOption.getEnumCaseInsensitive(properties.getProperty(propertyName));
            if (value == null) continue;
            this.capeServerSettings.put(service, value);
        }
    }

    public String getCapeSettingsString() {
        return this.getCapeSettingsString(false);
    }

    public String getCapeSettingsString(boolean useAmpersand) {
        StringBuilder out = new StringBuilder();
        for (String service : this.capeServerSettings.keySet()) {
            out.append(useAmpersand ? "&" : "?");
            out.append(service).append("=").append(this.capeServerSettings.get(service).getValue());
            if (useAmpersand) continue;
            useAmpersand = true;
        }
        return out.toString();
    }

    public void save() throws IOException {
        File parentDir = this.propertiesPath.getParent().toFile();
        if (!parentDir.exists()) {
            parentDir.mkdir();
        }
        Properties properties = new Properties();
        properties.setProperty("starter-cape-id", this.capeId);
        properties.store(Files.newOutputStream(this.propertiesPath, new OpenOption[0]), "Cosmetica Default Settings Config");
    }
}

