/*
 * Decompiled with CFR 0.152.
 */
package com.eyezah.cosmetics.cosmetics.model;

import com.eyezah.cosmetics.Cosmetica;
import com.eyezah.cosmetics.cosmetics.model.BakableModel;
import com.eyezah.cosmetics.cosmetics.model.RuntimeTextureManager;
import com.eyezah.cosmetics.utils.Debug;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_793;
import net.minecraft.class_809;

public class Models {
    private static Map<String, class_1087> BAKED_MODELS = new HashMap<String, class_1087>();
    private static Map<String, BakableModel> LOADED_MODELS = new HashMap<String, BakableModel>();
    private static final float RANDOM_NEXT_FLOAT = 0.211f;
    public static class_1088 thePieShopDownTheRoad;
    public static final RuntimeTextureManager TEXTURE_MANAGER;

    public static void resetCaches() {
        LOADED_MODELS = new HashMap<String, BakableModel>();
        Models.resetTextureBasedCaches();
    }

    public static void resetTextureBasedCaches() {
        BAKED_MODELS = new HashMap<String, class_1087>();
        TEXTURE_MANAGER.clear();
    }

    public static Collection<String> getCachedModels() {
        return LOADED_MODELS.keySet();
    }

    @Nullable
    public static class_1087 getBakedModel(BakableModel unbaked) {
        boolean compute;
        if (unbaked.id().charAt(0) == '-') {
            return null;
        }
        boolean bl = compute = !BAKED_MODELS.containsKey(unbaked.id());
        if (compute) {
            Debug.info("Computing Baked Model: " + unbaked.id(), new Object[0]);
            BAKED_MODELS.put(unbaked.id(), null);
            TEXTURE_MANAGER.retrieveAllocatedSprite(unbaked, class_310.method_1551().field_1687.method_8510(), sprite -> {
                class_1087 model = unbaked.model().method_4753(thePieShopDownTheRoad, l -> Models.getAppropriateTexture(l, sprite, unbaked.id()), (class_3665)class_1086.field_5350, new class_2960(unbaked.id().toLowerCase(Locale.ROOT)));
                BAKED_MODELS.put(unbaked.id(), model);
            });
        }
        return BAKED_MODELS.get(unbaked.id());
    }

    private static class_1058 getAppropriateTexture(class_4730 material, class_1058 allocated, String id) {
        class_1058 vanillaSprite;
        if (material.method_24147().method_12836().equals("minecraft") && (vanillaSprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(material.method_24147())) == null) {
            Cosmetica.LOGGER.warn("Model " + id + " requested a 'minecraft' texture but the associated sprite is NULL! Requested texture: " + material.method_24147() + ", Fallback Sprite: " + allocated);
        }
        return allocated;
    }

    public static void removeBakedModel(String id) {
        BAKED_MODELS.remove(id);
    }

    @Nullable
    public static BakableModel createBakableModel(@Nullable JsonObject json) {
        if (json == null) {
            return null;
        }
        String location = json.get("id").getAsString();
        if (location.isEmpty()) {
            return null;
        }
        JsonArray bounds = json.getAsJsonArray("bounds");
        if (location.charAt(0) == '-') {
            return LOADED_MODELS.computeIfAbsent(location, l -> new BakableModel(location, null, null, 0, bounds));
        }
        return LOADED_MODELS.computeIfAbsent(location, l -> {
            BakableModel bakableModel;
            ByteArrayInputStream is = new ByteArrayInputStream(json.get("model").getAsString().getBytes(StandardCharsets.UTF_8));
            try {
                class_793 model = class_793.method_3437((Reader)new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
                model.field_4252 = l;
                class_1011 image = class_1011.method_15990((String)json.get("texture").getAsString().substring(22));
                bakableModel = new BakableModel(location, model, image, json.get("extra info").getAsInt(), bounds);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            ((InputStream)is).close();
            return bakableModel;
        });
    }

    public static void renderModel(class_1087 model, class_4587 stack, class_4597 multiBufferSource, int packedLight) {
        stack.method_22903();
        boolean isGUI3D = model.method_4712();
        float transformStrength = 0.25f;
        float rotation = 0.0f;
        float transform = model.method_4709().method_3503((class_809.class_811)class_809.class_811.field_4318).field_4285.method_4945();
        stack.method_22904(0.0, (double)(rotation + transformStrength * transform), 0.0);
        float xScale = model.method_4709().field_4303.field_4285.method_4943();
        float yScale = model.method_4709().field_4303.field_4285.method_4945();
        float zScale = model.method_4709().field_4303.field_4285.method_4947();
        stack.method_22903();
        class_809.class_811 transformType = class_809.class_811.field_4319;
        int overlayTyp = class_4608.field_21444;
        stack.method_22903();
        model.method_4709().method_3503(transformType).method_23075(false, stack);
        stack.method_22904(-0.5, -0.5, -0.5);
        class_1921 renderType = class_1921.method_23579();
        class_4588 vertexConsumer4 = multiBufferSource.getBuffer(renderType);
        Models.renderModelLists(model, packedLight, overlayTyp, stack, vertexConsumer4);
        stack.method_22909();
        stack.method_22909();
        if (!isGUI3D) {
            stack.method_22904((double)(0.0f * xScale), (double)(0.0f * yScale), (double)(0.09375f * zScale));
        }
        stack.method_22909();
    }

    private static void renderModelLists(class_1087 bakedModel, int packedLight, int overlayType, class_4587 poseStack, class_4588 vertexConsumer) {
        Random random = new Random();
        long seed = 42L;
        for (class_2350 direction : class_2350.values()) {
            random.setSeed(42L);
            Models.renderQuadList(poseStack, vertexConsumer, bakedModel.method_4707(null, direction, random), packedLight, overlayType);
        }
        random.setSeed(42L);
        Models.renderQuadList(poseStack, vertexConsumer, bakedModel.method_4707(null, null, random), packedLight, overlayType);
    }

    private static void renderQuadList(class_4587 poseStack, class_4588 vertexConsumer, List<class_777> list, int i, int j) {
        class_4587.class_4665 pose = poseStack.method_23760();
        for (class_777 bakedQuad : list) {
            int k = -1;
            float f = (float)(k >> 16 & 0xFF) / 255.0f;
            float g = (float)(k >> 8 & 0xFF) / 255.0f;
            float h = (float)(k & 0xFF) / 255.0f;
            vertexConsumer.method_22919(pose, bakedQuad, f, g, h, i, j);
        }
    }

    static {
        TEXTURE_MANAGER = new RuntimeTextureManager(128);
    }
}

