/*
 * Decompiled with CFR 0.152.
 */
package com.eyezah.cosmetics.cosmetics.model;

import com.eyezah.cosmetics.cosmetics.model.BakableModel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class OverriddenModel {
    @Nullable
    private BakableModel debugModel;
    @Nullable
    private BakableModel testModel;
    private static List<OverriddenModel> instances = new ArrayList<OverriddenModel>(2);
    @Nullable
    private static OverriddenModel currentOverride;

    public OverriddenModel() {
        instances.add(this);
    }

    public void setDebugModel(BakableModel model) {
        if (currentOverride != null) {
            OverriddenModel.currentOverride.debugModel = null;
        }
        currentOverride = this;
        this.debugModel = model;
    }

    public void setTestModel(BakableModel model) {
        this.testModel = model;
    }

    @Nullable
    public BakableModel get(Supplier<BakableModel> orElse) {
        if (this.debugModel != null) {
            return this.debugModel;
        }
        if (currentOverride != null) {
            return null;
        }
        return this.testModel == null ? orElse.get() : this.testModel;
    }

    public void removeTestModel() {
        this.testModel = null;
    }

    public static void disableDebugModels() {
        currentOverride = null;
        for (OverriddenModel instance : instances) {
            instance.debugModel = null;
        }
    }
}

