/*
 * Decompiled with CFR 0.152.
 */
package com.eyezah.cosmetics.cosmetics.model;

import com.eyezah.cosmetics.Cosmetica;
import com.eyezah.cosmetics.cosmetics.model.BakableModel;
import com.eyezah.cosmetics.cosmetics.model.Models;
import com.eyezah.cosmetics.mixin.textures.MixinTextureAtlasSpriteInvoker;
import com.eyezah.cosmetics.utils.Debug;
import com.eyezah.cosmetics.utils.Scheduler;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_4725;

public class RuntimeTextureManager {
    private final int size;
    private final String[] ids;
    private final class_1058[] sprites;
    private int emptySpriteIndex = 0;
    long lastTickTime;
    final int[] used;
    int search = 0;

    public RuntimeTextureManager(int size) {
        this.size = size;
        this.ids = new String[size];
        this.sprites = new class_1058[size];
        this.used = new int[size];
    }

    public void addAtlasSprite(class_1058 result) {
        this.sprites[this.emptySpriteIndex] = result;
        this.emptySpriteIndex = this.emptySpriteIndex + 1 & this.size - 1;
    }

    void clear() {
        this.search = 0;
        for (int i = 0; i < this.size; ++i) {
            this.used[i] = 0;
            this.ids[i] = null;
        }
    }

    public void retrieveAllocatedSprite(BakableModel model, long tickTime, Consumer<class_1058> callback) {
        class_1058 sprite;
        int index;
        if (tickTime != this.lastTickTime) {
            this.lastTickTime = tickTime;
            this.search = 0;
            for (int i = 0; i < this.size; ++i) {
                if (this.used[i] <= 0) continue;
                int n = i;
                this.used[n] = this.used[n] - 1;
            }
        }
        if ((index = this.getIndex(model.id())) == -1) {
            if (this.search == this.size) {
                return;
            }
            index = this.search;
            while (this.used[index] > 0) {
                if (++index != this.size) continue;
                this.search = this.size;
                return;
            }
            Debug.info("Using New Index: " + index, new Object[0]);
            this.search = index + 1;
            if (this.ids[index] != null) {
                Models.removeBakedModel(this.ids[index]);
            }
            this.ids[index] = model.id();
            this.used[index] = Integer.MAX_VALUE;
            sprite = this.sprites[index];
            if (sprite == null) {
                Cosmetica.LOGGER.error("The sprite assigned to model {} is null! Will try again in 20 ticks.", (Object)model.id());
                this.used[index] = 20;
                return;
            }
            int index_ = index;
            Scheduler.scheduleTask(Scheduler.Location.TEXTURE_TICK, () -> {
                class_1011[] mipmap = class_4725.method_24102((class_1011)model.image(), (int)(((MixinTextureAtlasSpriteInvoker)sprite).getMainImage().length - 1));
                Debug.info("Allocating Sprite: " + sprite.method_4598(), new Object[0]);
                Debug.dumpImages(sprite.method_4598().method_36181() + "_old", false, ((MixinTextureAtlasSpriteInvoker)sprite).getMainImage());
                Debug.dumpImages(sprite.method_4598().method_36181(), false, mipmap);
                GlStateManager._bindTexture((int)((MixinTextureAtlasSpriteInvoker)sprite).getAtlas().method_4624());
                ((MixinTextureAtlasSpriteInvoker)sprite).callUpload(0, 0, mipmap);
                this.used[index_] = 2;
                callback.accept(sprite);
            });
        }
        if ((sprite = this.sprites[index]) != null) {
            this.used[index] = 2;
            callback.accept(sprite);
        } else if (this.used[0] == 0) {
            Cosmetica.LOGGER.info("Preparing to try assign a sprite for {} again...", (Object)model.id());
        }
    }

    private int getIndex(String id) {
        for (int i = 0; i < this.size; ++i) {
            if (!id.equals(this.ids[i])) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RuntimeTextureManager");
        for (int i = 0; i < this.size; ++i) {
            if (this.used[i] <= 0) continue;
            sb.append("[u:").append(this.used[i]).append(",k:").append(this.ids[i]).append("]");
        }
        return sb.toString();
    }
}

