/*
 * Decompiled with CFR 0.152.
 */
package com.eyezah.cosmetics.utils;

import com.eyezah.cosmetics.Cosmetica;
import com.eyezah.cosmetics.mixin.textures.MixinNativeImageAccessor;
import com.eyezah.cosmetics.utils.Debug;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.lwjgl.system.MemoryUtil;

public class Base64Texture
extends class_1044 {
    private final class_2960 path;
    private final boolean cape;
    private final String base64;
    private class_1011 image;

    public Base64Texture(class_2960 path, String base64, boolean cape) throws IOException {
        this.base64 = base64;
        this.cape = cape;
        this.path = path;
        this.loadBase64();
    }

    public void method_4625(class_3300 resourceManager) {
        if (((MixinNativeImageAccessor)this.image).getPixels() == 0L) {
            if (RenderSystem.isOnRenderThreadOrInit()) {
                this.reload();
            } else {
                RenderSystem.recordRenderCall(this::reload);
            }
            return;
        }
        this.upload();
    }

    private void reload() {
        Debug.info("Re-uploading texture {}", this.path);
        try {
            this.loadBase64();
            this.upload();
        }
        catch (IOException e) {
            Cosmetica.LOGGER.error("Error re-uploading Base64 Texture", (Throwable)e);
        }
    }

    private void loadBase64() throws IOException {
        class_1011 image = Base64Texture.loadBase64(this.base64);
        this.image = this.cape ? Base64Texture.processBadCapes(image) : image;
    }

    private void upload() {
        TextureUtil.prepareImage((int)this.method_4624(), (int)0, (int)this.image.method_4307(), (int)this.image.method_4323());
        this.image.method_22619(0, 0, 0, 0, 0, this.image.method_4307(), this.image.method_4323(), this.field_5205, false, false, true);
    }

    private static class_1011 loadBase64(String base64) throws IOException {
        if (base64.length() < 1000) {
            return class_1011.method_15990((String)base64);
        }
        byte[] bs = Base64.getDecoder().decode(base64.replace("\n", "").getBytes(StandardCharsets.UTF_8));
        ByteBuffer buffer = MemoryUtil.memAlloc((int)bs.length);
        buffer.put(bs);
        buffer.rewind();
        class_1011 image = class_1011.method_4324((ByteBuffer)buffer);
        MemoryUtil.memFree((Buffer)buffer);
        return image;
    }

    private static class_1011 processBadCapes(class_1011 image) {
        int srcHeight;
        int srcWidth = image.method_4307();
        if (srcWidth != (srcHeight = image.method_4323()) * 2) {
            int height = 32;
            int scaleFactor = 1;
            while (height < srcHeight) {
                height *= 2;
                scaleFactor *= 2;
            }
            class_1011 result = new class_1011(height * 2, height, true);
            Base64Texture.copyImage(image, result);
            if (17 * srcWidth == 22 * srcHeight) {
                Base64Texture.copyRect(result, 1, 1, 35, 4, 11, 16, scaleFactor);
                Base64Texture.clearRect(result, 44, 4, 2, 3, scaleFactor);
                Base64Texture.clearRect(result, 45, 7, 1, 4, scaleFactor);
                Base64Texture.clearRect(result, 35, 16, 2, 4, scaleFactor);
                Base64Texture.clearRect(result, 35, 11, 1, 5, scaleFactor);
                Base64Texture.clearRect(result, 37, 19, 1, 1, scaleFactor);
                Base64Texture.copyRect(result, 38, 19, 38, 20, 8, 1, scaleFactor);
                Base64Texture.copyRect(result, 39, 19, 39, 21, 7, 1, scaleFactor);
                Base64Texture.copyRect(result, 35, 4, 35, 3, 8, 1, scaleFactor);
                Base64Texture.copyRect(result, 35, 4, 35, 2, 7, 1, scaleFactor);
                Base64Texture.copyRect(result, 12, 0, 31, 0, 9, 1, scaleFactor);
                Base64Texture.copyRect(result, 32, 0, 32, 1, 2, 1, scaleFactor);
                Base64Texture.copyRect(result, 35, 2, 34, 2, 2, 2, scaleFactor);
                Base64Texture.copyRect(result, 45, 11, 22, 11, 1, 11, scaleFactor);
            }
            String imgid = "cape_" + System.currentTimeMillis();
            Debug.dumpImages(imgid + "_src", true, image);
            Debug.dumpImages(imgid + "_formatted", true, result);
            image.close();
            return result;
        }
        return image;
    }

    private static void copyImage(class_1011 src, class_1011 dest) {
        int width = Math.min(dest.method_4307(), src.method_4307());
        int height = Math.min(dest.method_4323(), src.method_4323());
        int bytesPerPixel = src.method_4318().method_4335();
        for (int l = 0; l < height; ++l) {
            int m = l * src.method_4307() * bytesPerPixel;
            int n = l * dest.method_4307() * bytesPerPixel;
            MemoryUtil.memCopy((long)(((MixinNativeImageAccessor)src).getPixels() + (long)m), (long)(((MixinNativeImageAccessor)dest).getPixels() + (long)n), (long)(width * bytesPerPixel));
        }
    }

    private static void copyRect(class_1011 img, int srcX, int srcY, int destX, int destY, int width, int height, int scale) {
        srcX *= scale;
        srcY *= scale;
        destX *= scale;
        destY *= scale;
        width *= scale;
        height *= scale;
        for (int dx = 0; dx < width; ++dx) {
            for (int dy = 0; dy < height; ++dy) {
                int colour = img.method_4315(srcX + dx, srcY + dy);
                img.method_4305(destX + dx, destY + dy, colour);
            }
        }
    }

    private static void clearRect(class_1011 img, int x, int y, int width, int height, int scale) {
        x *= scale;
        y *= scale;
        width *= scale;
        height *= scale;
        for (int dx = 0; dx < width; ++dx) {
            for (int dy = 0; dy < height; ++dy) {
                img.method_4305(x + dx, y + dy, 0);
            }
        }
    }
}

