/*
 * Decompiled with CFR 0.152.
 */
package com.eyezah.cosmetics.utils;

import com.eyezah.cosmetics.Cosmetica;
import com.eyezah.cosmetics.cosmetics.Hat;
import com.eyezah.cosmetics.cosmetics.ShoulderBuddy;
import com.eyezah.cosmetics.cosmetics.model.BakableModel;
import com.eyezah.cosmetics.cosmetics.model.OverriddenModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_793;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Debug {
    public static final boolean DEBUG_MODE;
    public static final boolean TEST_MODE;
    private static final File CONFIG_DIR;
    private static final File TEST_PROPERTIES_FILE;
    private static final Properties TEST_PROPERTIES;
    private static final Logger DEBUG_LOGGER;
    public static final File DUMP_FOLDER;
    private static Settings debugSettings;
    private static Set<String> complainedAbout;

    public static void complainOnce(String key, String str, Object ... objects) {
        if (DEBUG_MODE && debugSettings.logging() && !complainedAbout.contains(key)) {
            complainedAbout.add(key);
            DEBUG_LOGGER.info("[COMPLAINT] " + str, objects);
        }
    }

    public static void info(String str, Object ... objects) {
        if (DEBUG_MODE && debugSettings.logging()) {
            DEBUG_LOGGER.info(str, objects);
        }
    }

    public static void checkedInfo(String str, String check) {
        if (DEBUG_MODE && Debug.debugSettings.other.test(check)) {
            DEBUG_LOGGER.info(str);
        }
    }

    public static void info(Supplier<String> str) {
        if (DEBUG_MODE && debugSettings.logging()) {
            DEBUG_LOGGER.info(str.get());
        }
    }

    public static boolean debugCommands() {
        return DEBUG_MODE && debugSettings.testUnverifiedCosmetics();
    }

    public static void dumpImages(String name, boolean capeModification, class_1011 ... images) {
        if (DEBUG_MODE && (capeModification ? debugSettings.imageDumping().capeModifications() : debugSettings.imageDumping().textureLoading())) {
            int i = 0;
            for (class_1011 image : images) {
                try {
                    File file = new File(DUMP_FOLDER, name + "_dump_" + i + ".png");
                    file.createNewFile();
                    image.method_4325(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    public static void clearImages() {
        if (DEBUG_MODE && debugSettings.imageDumping().either()) {
            for (File file : DUMP_FOLDER.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".png")) continue;
                file.delete();
            }
        }
    }

    private static boolean loadTestModel(OverriddenModel model, String modelLoc, int extraInfo) {
        File modelJsonF = new File(CONFIG_DIR, modelLoc + ".json");
        if (modelJsonF.isFile()) {
            File imageF = new File(CONFIG_DIR, modelLoc + ".png");
            if (imageF.isFile()) {
                class_1011 image;
                class_793 blockModel;
                try (FileReader reader = new FileReader(modelJsonF);){
                    blockModel = class_793.method_3437((Reader)reader);
                }
                catch (JsonParseException | IOException e) {
                    Cosmetica.LOGGER.error("Error reading test block model for " + modelLoc, e);
                    return false;
                }
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(imageF));){
                    image = class_1011.method_4309((InputStream)stream);
                }
                catch (JsonParseException | IOException e) {
                    Cosmetica.LOGGER.error("Error reading test block model for " + modelLoc, e);
                    return false;
                }
                model.setTestModel(new BakableModel("test-" + modelLoc, blockModel, image, extraInfo, JsonParser.parseString((String)"[[0, 0, 0], [0, 0, 0]]").getAsJsonArray()));
                return true;
            }
            Cosmetica.LOGGER.warn("Json for test model {} found but no associated 32x32 image. Skipping loading the model override!", (Object)modelLoc);
        }
        return false;
    }

    public static boolean loadTestModel(LocalModelType type) {
        String model = type.localIdProvider.get();
        if (model.isBlank()) {
            type.modelOverride.removeTestModel();
            return false;
        }
        return Debug.loadTestModel(type.modelOverride, model, type.extraInfoLoader.getAsInt());
    }

    public static void loadTestProperties() {
        try (FileReader reader = new FileReader(TEST_PROPERTIES_FILE);){
            TEST_PROPERTIES.load(reader);
        }
        catch (Exception e) {
            Cosmetica.LOGGER.error("Error loading cosmetica_testing.properties", (Throwable)e);
        }
    }

    public static void saveTestProperties() {
        try (FileWriter writer = new FileWriter(TEST_PROPERTIES_FILE);){
            TEST_PROPERTIES.store(writer, "Cosmetica Testing Properties");
        }
        catch (Exception e) {
            Cosmetica.LOGGER.error("Exception writing cosmetica_testing.properties", (Throwable)e);
        }
    }

    private static /* synthetic */ boolean lambda$static$1(Object2BooleanMap cache, Predicate predicate, String key) {
        return cache.computeBooleanIfAbsent((Object)key, predicate);
    }

    static {
        block21: {
            DEBUG_MODE = FabricLoader.getInstance().isDevelopmentEnvironment() || Boolean.getBoolean("cosmetica.debug");
            DEBUG_LOGGER = LogManager.getLogger((String)"Cosmetica Debug");
            debugSettings = new Settings();
            complainedAbout = new HashSet<String>();
            DUMP_FOLDER = new File(FabricLoader.getInstance().getGameDir().toFile(), "cosmetic_dumps");
            CONFIG_DIR = new File(FabricLoader.getInstance().getConfigDir().toFile(), "cosmetica");
            TEST_PROPERTIES_FILE = new File(CONFIG_DIR, "cosmetica_testing.properties");
            TEST_PROPERTIES = new Properties();
            TEST_PROPERTIES.setProperty("hat_location", "hat");
            TEST_PROPERTIES.setProperty("show_hat_under_helmet", "false");
            TEST_PROPERTIES.setProperty("shoulderbuddy_location", "shoulderbuddy");
            TEST_PROPERTIES.setProperty("lock_shoulderbuddy_orientation", "false");
            boolean foundPropertiesFile = TEST_PROPERTIES_FILE.isFile();
            if (foundPropertiesFile) {
                Debug.loadTestProperties();
            }
            boolean testModelExists = false;
            testModelExists |= Debug.loadTestModel(LocalModelType.HAT);
            if ((testModelExists |= Debug.loadTestModel(LocalModelType.SHOULDERBUDDY)) || foundPropertiesFile) {
                Cosmetica.LOGGER.info("Test mode enabled! Special test settings available in the cosmetica menu.");
                TEST_MODE = true;
            } else {
                TEST_MODE = false;
            }
            if (testModelExists && !TEST_PROPERTIES_FILE.isFile()) {
                Debug.saveTestProperties();
            }
            if (DEBUG_MODE) {
                CONFIG_DIR.mkdirs();
                File settings = new File(CONFIG_DIR, "debug_settings.json");
                try {
                    if (settings.createNewFile()) {
                        JsonObject imageDumping = new JsonObject();
                        imageDumping.add("texture_loading", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                        imageDumping.add("cape_modifications", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                        JsonObject data = new JsonObject();
                        data.add("logging", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                        data.add("image_dumping", (JsonElement)imageDumping);
                        data.add("always_print_urls", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                        data.add("debug_commands", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                        try (FileWriter writer = new FileWriter(settings);){
                            writer.write(data.toString());
                            break block21;
                        }
                    }
                    try (FileReader reader = new FileReader(settings);){
                        ImageDumpingSettings imageDumpingSettings;
                        JsonObject data = new JsonParser().parse((Reader)reader).getAsJsonObject();
                        Object2BooleanArrayMap cache = new Object2BooleanArrayMap();
                        Predicate<String> predicate = k_ -> data.has(k_) && Boolean.parseBoolean(data.get(k_).getAsString());
                        JsonElement imageDumping = data.get("image_dumping");
                        if (imageDumping.isJsonPrimitive()) {
                            imageDumpingSettings = new ImageDumpingSettings(imageDumping.getAsBoolean());
                        } else {
                            JsonObject jo = imageDumping.getAsJsonObject();
                            imageDumpingSettings = new ImageDumpingSettings(jo.get("texture_loading").getAsBoolean(), jo.get("cape_modifications").getAsBoolean());
                        }
                        boolean useDebugCommands = data.has("test_unverified_cosmetics") ? data.get("test_unverified_cosmetics").getAsBoolean() : false;
                        debugSettings = new Settings(data.get("logging").getAsBoolean(), imageDumpingSettings, useDebugCommands |= data.has("debug_commands") ? data.get("debug_commands").getAsBoolean() : false, arg_0 -> Debug.lambda$static$1((Object2BooleanMap)cache, predicate, arg_0));
                        if (debugSettings.imageDumping().either()) {
                            DUMP_FOLDER.mkdir();
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private record Settings(boolean logging, ImageDumpingSettings imageDumping, boolean testUnverifiedCosmetics, Predicate<String> other) {
        Settings() {
            this(false, new ImageDumpingSettings(false), false, i -> false);
        }
    }

    public record ImageDumpingSettings(boolean textureLoading, boolean capeModifications) {
        ImageDumpingSettings(boolean val) {
            this(val, val);
        }

        boolean either() {
            return this.textureLoading || this.capeModifications;
        }
    }

    public record LocalModelType(OverriddenModel modelOverride, Supplier<String> localIdProvider, IntSupplier extraInfoLoader) {
        public static final LocalModelType HAT = new LocalModelType(Hat.overridden, () -> TEST_PROPERTIES.getProperty("hat_location"), () -> Boolean.parseBoolean(TEST_PROPERTIES.getProperty("show_hat_under_helmet")) ? 1 : 0);
        public static final LocalModelType SHOULDERBUDDY = new LocalModelType(ShoulderBuddy.overridden, () -> TEST_PROPERTIES.getProperty("shoulderbuddy_location"), () -> Boolean.parseBoolean(TEST_PROPERTIES.getProperty("lock_shoulderbuddy_orientation")) ? 1 : 0);
    }
}

