/*
 * Decompiled with CFR 0.152.
 */
package com.eyezah.cosmetics.utils;

import java.util.function.IntFunction;

public class FastCache<T> {
    private final Operator<T> operator;
    private int mask;
    private Object[] keys;
    private T[] values;

    public FastCache(int size, IntFunction<T[]> generator, Operator<T> operator) {
        this.operator = operator;
        this.mask = size - 1;
        this.keys = new Object[size];
        this.values = generator.apply(size);
    }

    public T sample(Object key) {
        int loc = key.hashCode() & this.mask;
        if (this.keys[loc] != key) {
            this.keys[loc] = key;
            this.values[loc] = this.operator.sample(key);
            return this.values[loc];
        }
        return this.values[loc];
    }

    @FunctionalInterface
    public static interface Operator<T> {
        public T sample(Object var1);
    }
}

