/*
 * Decompiled with CFR 0.152.
 */
package com.eyezah.cosmetics.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_5250;

public class FormattedChatEncoder {
    public static class_2561 chatEncode(String remoteText) throws IllegalArgumentException, IndexOutOfBoundsException {
        StringBuilder literalTxt = new StringBuilder();
        ArrayList<Object> tokens = new ArrayList<Object>(4);
        for (int i = 0; i < remoteText.length(); ++i) {
            char c = remoteText.charAt(i);
            if (c == '\\') {
                literalTxt.append(remoteText.charAt(++i));
                continue;
            }
            if (c == '[') {
                if (!literalTxt.isEmpty()) {
                    tokens.add(literalTxt.toString());
                    literalTxt = new StringBuilder();
                }
                tokens.add((Object)Token.LINK_START);
                continue;
            }
            if (c == ']') {
                if (remoteText.charAt(++i) != '(') {
                    throw new IllegalArgumentException("Unexpected character " + remoteText.charAt(i) + " after list plaintext delimiter ']'!");
                }
                if (!literalTxt.isEmpty()) {
                    tokens.add(literalTxt.toString());
                    literalTxt = new StringBuilder();
                }
                tokens.add((Object)Token.LINK_MID);
                continue;
            }
            if (c == ')') {
                if (!literalTxt.isEmpty()) {
                    tokens.add(literalTxt.toString());
                    literalTxt = new StringBuilder();
                }
                tokens.add((Object)Token.LINK_END);
                continue;
            }
            literalTxt.append(c);
        }
        if (!literalTxt.isEmpty()) {
            tokens.add(literalTxt.toString());
        }
        class_2585 result = new class_2585("");
        for (int i = 0; i < tokens.size(); ++i) {
            Object currentToken = tokens.get(i);
            if (currentToken instanceof String) {
                String text = (String)currentToken;
                result.method_27693(text);
                continue;
            }
            if (currentToken == Token.LINK_START) {
                i = FormattedChatEncoder.parseURL((class_5250)result, tokens, i);
                continue;
            }
            throw new IllegalArgumentException("Unexpected token " + currentToken + " in string " + remoteText + "!");
        }
        return result;
    }

    private static int parseURL(class_5250 result, List<Object> tokens, int i) throws IllegalArgumentException {
        class_2585 link = new class_2585("");
        try {
            Object token;
            while ((token = tokens.get(++i)) != Token.LINK_MID) {
                if (token instanceof String) {
                    String text = (String)token;
                    link.method_27693(text);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected non-plaintext token " + token + " parsing link plaintext.");
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Could not find LINK_MID token after indicated link start.", e);
        }
        try {
            if (!(tokens.get(++i) instanceof String)) {
                throw new IllegalArgumentException("URL is not plaintext: " + tokens.get(i));
            }
            String url = (String)tokens.get(i);
            if (tokens.get(++i) != Token.LINK_END) {
                throw new IllegalArgumentException("No LINK_END token after indicated link mid.");
            }
            link.method_10862(link.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11749, url)));
            result.method_10852((class_2561)link);
            return i;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Unexpected End-Of-Text after indicated link mid.", e);
        }
    }

    private static enum Token {
        LINK_START,
        LINK_MID,
        LINK_END;

    }
}

