/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client;

import com.google.common.base.Suppliers;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.DisplayScreenType;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.api.common.util.FormattingUtils;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.screen.CompositeDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.screen.DefaultDisplayViewingScreen;
import me.shedaniel.rei.impl.client.view.ViewsImpl;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3528;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class ClientHelperImpl
implements ClientHelper {
    @ApiStatus.Internal
    public final class_3528<Boolean> isAprilFools = new class_3528(() -> {
        try {
            LocalDateTime now = LocalDateTime.now();
            return now.getMonthValue() == 4 && now.getDayOfMonth() == 1;
        }
        catch (Throwable throwable) {
            return false;
        }
    });
    private final Map<String, String> modNameCache = new HashMap<String, String>(){
        {
            this.put("minecraft", "Minecraft");
            this.put("c", "Global");
            this.put("global", "Global");
        }
    };

    @ApiStatus.Internal
    public static ClientHelperImpl getInstance() {
        return (ClientHelperImpl)ClientHelper.getInstance();
    }

    public boolean hasPermissionToUsePackets() {
        try {
            class_310.method_1551().method_1562().method_2875().method_9259(0);
            return this.hasOperatorPermission() && this.canUsePackets();
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public boolean hasOperatorPermission() {
        try {
            return class_310.method_1551().method_1562().method_2875().method_9259(1);
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public boolean canUsePackets() {
        return NetworkManager.canServerReceive((class_2960)RoughlyEnoughItemsNetwork.CREATE_ITEMS_PACKET) && NetworkManager.canServerReceive((class_2960)RoughlyEnoughItemsNetwork.CREATE_ITEMS_GRAB_PACKET) && NetworkManager.canServerReceive((class_2960)RoughlyEnoughItemsNetwork.DELETE_ITEMS_PACKET);
    }

    public boolean canDeleteItems() {
        return this.hasPermissionToUsePackets() || class_310.method_1551().field_1761.method_2914();
    }

    @Override
    public void appendModIdToTooltips(Tooltip components, String modId) {
        String modName = ClientHelper.getInstance().getModFromModId(modId);
        boolean alreadyHasMod = false;
        for (Tooltip.Entry s : components.entries()) {
            if (!s.isText() || !FormattingUtils.stripFormatting(s.getAsText().getString()).equalsIgnoreCase(modName)) continue;
            alreadyHasMod = true;
            break;
        }
        if (!alreadyHasMod) {
            components.add(ClientHelper.getInstance().getFormattedModFromModId(modId));
        }
    }

    @Override
    public String getModFromModId(String modId) {
        if (modId == null) {
            return "";
        }
        String any = this.modNameCache.getOrDefault(modId, null);
        if (any != null) {
            return any;
        }
        if (Platform.isModLoaded((String)modId)) {
            String modName = Platform.getMod((String)modId).getName();
            this.modNameCache.put(modId, modName);
            return modName;
        }
        return modId;
    }

    @Override
    public boolean isCheating() {
        return ConfigObject.getInstance().isCheating();
    }

    @Override
    public void setCheating(boolean cheating) {
        ConfigObject.getInstance().setCheating(cheating);
        ConfigManager.getInstance().saveConfig();
    }

    @Override
    public void sendDeletePacket() {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof class_481) {
            class_481 inventoryScreen = (class_481)class_4372;
            class_310.method_1551().field_1724.field_7512.method_34254(class_1799.field_8037);
            inventoryScreen.field_2794 = false;
            return;
        }
        NetworkManager.sendToServer((class_2960)RoughlyEnoughItemsNetwork.DELETE_ITEMS_PACKET, (class_2540)new class_2540(Unpooled.buffer()));
        class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof class_465) {
            class_465 containerScreen = (class_465)class_4372;
            containerScreen.field_2794 = false;
        }
    }

    @Override
    public boolean tryCheatingEntry(EntryStack<?> e) {
        if (e.getType() != VanillaEntryTypes.ITEM) {
            return false;
        }
        EntryStack<?> entry = e;
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        if (class_310.method_1551().field_1724.method_31548() == null) {
            return false;
        }
        class_1799 cheatedStack = ((class_1799)entry.getValue()).method_7972();
        if (ConfigObject.getInstance().isGrabbingItems() && class_310.method_1551().field_1755 instanceof class_481) {
            class_1703 menu = class_310.method_1551().field_1724.field_7512;
            EntryStack<?> stack = entry.copy();
            if (!menu.method_34255().method_7960() && EntryStacks.equalsExact(EntryStacks.of(menu.method_34255()), stack)) {
                ((class_1799)stack.getValue()).method_7939(class_3532.method_15340((int)(((class_1799)stack.getValue()).method_7947() + menu.method_34255().method_7947()), (int)1, (int)((class_1799)stack.getValue()).method_7914()));
            } else if (!menu.method_34255().method_7960()) {
                return false;
            }
            menu.method_34254(((class_1799)stack.getValue()).method_7972());
            return true;
        }
        if (ClientHelperImpl.getInstance().canUsePackets()) {
            class_1703 menu = class_310.method_1551().field_1724.field_7512;
            EntryStack<?> stack = entry.copy();
            if (!menu.method_34255().method_7960() && !EntryStacks.equalsExact(EntryStacks.of(menu.method_34255()), stack)) {
                return false;
            }
            try {
                NetworkManager.sendToServer((class_2960)(ConfigObject.getInstance().isGrabbingItems() ? RoughlyEnoughItemsNetwork.CREATE_ITEMS_GRAB_PACKET : RoughlyEnoughItemsNetwork.CREATE_ITEMS_PACKET), (class_2540)new class_2540(Unpooled.buffer()).method_10793(cheatedStack));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        class_2960 identifier = entry.getIdentifier();
        if (identifier == null) {
            return false;
        }
        String tagMessage = cheatedStack.method_7972().method_7969() != null && !cheatedStack.method_7972().method_7969().method_33133() ? cheatedStack.method_7972().method_7969().method_10714() : "";
        String og = cheatedStack.method_7947() == 1 ? ConfigObject.getInstance().getGiveCommand().replaceAll(" \\{count}", "") : ConfigObject.getInstance().getGiveCommand();
        String madeUpCommand = og.replaceAll("\\{player_name}", class_310.method_1551().field_1724.method_5820()).replaceAll("\\{item_name}", identifier.method_12832()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", tagMessage).replaceAll("\\{count}", String.valueOf(cheatedStack.method_7947()));
        if (madeUpCommand.length() > 256) {
            madeUpCommand = og.replaceAll("\\{player_name}", class_310.method_1551().field_1724.method_5820()).replaceAll("\\{item_name}", identifier.method_12832()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", "").replaceAll("\\{count}", String.valueOf(cheatedStack.method_7947()));
            class_310.method_1551().field_1724.method_7353((class_2561)new class_2588("text.rei.too_long_nbt"), false);
        }
        class_310.method_1551().field_1724.method_3142(madeUpCommand);
        return true;
    }

    @ApiStatus.Internal
    public Long2LongMap _getInventoryItemsTypes() {
        EntryDefinition<class_1799> definition;
        try {
            definition = VanillaEntryTypes.ITEM.getDefinition();
        }
        catch (NullPointerException e) {
            return Long2LongMaps.EMPTY_MAP;
        }
        Long2LongOpenHashMap map = new Long2LongOpenHashMap();
        for (class_2371 compartment : class_310.method_1551().field_1724.method_31548().field_7543) {
            for (class_1799 stack : compartment) {
                long hash = definition.hash(null, stack, ComparisonContext.FUZZY);
                long newCount = map.getOrDefault(hash, 0L) + (long)Math.max(0, stack.method_7947());
                map.put(hash, newCount);
            }
        }
        return map;
    }

    @ApiStatus.Internal
    public Long2LongMap _getContainerItemsTypes() {
        EntryDefinition<class_1799> definition;
        try {
            definition = VanillaEntryTypes.ITEM.getDefinition();
        }
        catch (NullPointerException e) {
            return Long2LongMaps.EMPTY_MAP;
        }
        Long2LongOpenHashMap map = new Long2LongOpenHashMap();
        class_1703 menu = class_310.method_1551().field_1724.field_7512;
        if (menu != null) {
            for (class_1735 slot : menu.field_7761) {
                class_1799 stack = slot.method_7677();
                if (stack.method_7960()) continue;
                long hash = definition.hash(null, stack, ComparisonContext.FUZZY);
                long newCount = map.getOrDefault(hash, 0L) + (long)Math.max(0, stack.method_7947());
                map.put(hash, newCount);
            }
        }
        return map;
    }

    @ApiStatus.Internal
    public void openDisplayViewingScreen(Map<DisplayCategory<?>, List<DisplaySpec>> map, @Nullable CategoryIdentifier<?> category, List<EntryStack<?>> ingredientNotice, List<EntryStack<?>> resultNotice) {
        LegacyWrapperViewSearchBuilder builder = new LegacyWrapperViewSearchBuilder(map);
        for (EntryStack<?> stack : ingredientNotice) {
            builder.addInputNotice(stack);
        }
        for (EntryStack<?> stack : resultNotice) {
            builder.addOutputNotice(stack);
        }
        this.openView(builder.setPreferredOpenedCategory(category));
    }

    @Override
    public boolean openView(ViewSearchBuilder builder) {
        Object object;
        DisplayScreen displayScreen;
        AbstractDisplayViewingScreen screen;
        Map<DisplayCategory<?>, List<DisplaySpec>> map = builder.buildMapInternal();
        if (map.isEmpty()) {
            return false;
        }
        if (ConfigObject.getInstance().getRecipeScreenType() == DisplayScreenType.COMPOSITE) {
            screen = new CompositeDisplayViewingScreen(map, builder.getPreferredOpenedCategory());
        } else {
            if (ConfigObject.getInstance().getRecipeScreenType() == DisplayScreenType.UNSET) {
                ConfigObject.getInstance().setRecipeScreenType(DisplayScreenType.ORIGINAL);
                ConfigManager.getInstance().saveConfig();
                return this.openView(builder);
            }
            screen = new DefaultDisplayViewingScreen(map, builder.getPreferredOpenedCategory());
        }
        if (screen instanceof DisplayScreen) {
            displayScreen = screen;
            for (EntryStack entryStack : builder.getUsagesFor()) {
                displayScreen.addIngredientToNotice(entryStack);
            }
            object = builder.getRecipesFor().iterator();
            while (object.hasNext()) {
                EntryStack entryStack = (EntryStack)object.next();
                displayScreen.addResultToNotice(entryStack);
            }
        }
        if ((object = class_310.method_1551().field_1755) instanceof DisplayScreen) {
            displayScreen = (DisplayScreen)object;
            REIRuntimeImpl.getInstance().storeDisplayScreen(displayScreen);
        }
        class_310.method_1551().method_1507((class_437)screen);
        return true;
    }

    @Override
    public boolean canUseMovePackets() {
        return NetworkManager.canServerReceive((class_2960)RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET);
    }

    public void onInitializeClient() {
        ClientInternals.attachInstance(this, ClientHelper.class);
        ClientInternals.attachInstance(ViewSearchBuilderImpl::new, "viewSearchBuilder");
    }

    public static final class LegacyWrapperViewSearchBuilder
    extends AbstractViewSearchBuilder {
        private final Map<DisplayCategory<?>, List<DisplaySpec>> map;
        @Nullable
        private EntryStack<?> inputNotice;
        @Nullable
        private EntryStack<?> outputNotice;
        @Nullable
        private CategoryIdentifier<?> preferredOpenedCategory = null;

        public LegacyWrapperViewSearchBuilder(Map<DisplayCategory<?>, List<DisplaySpec>> map) {
            this.map = map;
        }

        @Override
        public ViewSearchBuilder addCategory(CategoryIdentifier<?> category) {
            return this;
        }

        @Override
        public ViewSearchBuilder addCategories(Collection<CategoryIdentifier<?>> categories) {
            return this;
        }

        @Override
        public Set<CategoryIdentifier<?>> getCategories() {
            return Collections.emptySet();
        }

        @Override
        public ViewSearchBuilder filterCategory(CategoryIdentifier<?> category) {
            return this;
        }

        @Override
        public ViewSearchBuilder filterCategories(Collection<CategoryIdentifier<?>> categories) {
            return this;
        }

        @Override
        public Set<CategoryIdentifier<?>> getFilteringCategories() {
            return Collections.emptySet();
        }

        @Override
        public <T> ViewSearchBuilder addRecipesFor(EntryStack<T> stack) {
            return this;
        }

        @Override
        public List<EntryStack<?>> getRecipesFor() {
            return this.inputNotice == null ? Collections.emptyList() : Collections.singletonList(this.outputNotice);
        }

        @Override
        public <T> ViewSearchBuilder addUsagesFor(EntryStack<T> stack) {
            return this;
        }

        @Override
        public List<EntryStack<?>> getUsagesFor() {
            return this.inputNotice == null ? Collections.emptyList() : Collections.singletonList(this.inputNotice);
        }

        @Override
        public ViewSearchBuilder setPreferredOpenedCategory(@Nullable CategoryIdentifier<?> category) {
            this.preferredOpenedCategory = category;
            return this;
        }

        @Override
        @Nullable
        public CategoryIdentifier<?> getPreferredOpenedCategory() {
            return this.preferredOpenedCategory;
        }

        public <T> LegacyWrapperViewSearchBuilder addInputNotice(@Nullable EntryStack<T> stack) {
            this.inputNotice = stack;
            return this;
        }

        public <T> LegacyWrapperViewSearchBuilder addOutputNotice(@Nullable EntryStack<T> stack) {
            this.outputNotice = stack;
            return this;
        }

        @Override
        public Map<DisplayCategory<?>, List<DisplaySpec>> buildMapInternal() {
            this.fillPreferredOpenedCategory();
            return this.map;
        }

        @Override
        public boolean isMergingDisplays() {
            return true;
        }

        @Override
        public ViewSearchBuilder mergingDisplays(boolean mergingDisplays) {
            return this;
        }

        @Override
        public boolean isProcessingVisibilityHandlers() {
            return false;
        }

        @Override
        public ViewSearchBuilder processingVisibilityHandlers(boolean processingVisibilityHandlers) {
            return this;
        }
    }

    public static final class ViewSearchBuilderImpl
    extends AbstractViewSearchBuilder {
        private final Set<CategoryIdentifier<?>> filteringCategories = new HashSet();
        private final Set<CategoryIdentifier<?>> categories = new HashSet();
        private final List<EntryStack<?>> recipesFor = new ArrayList();
        private final List<EntryStack<?>> usagesFor = new ArrayList();
        @Nullable
        private CategoryIdentifier<?> preferredOpenedCategory = null;
        private boolean mergeDisplays = true;
        private boolean processVisibilityHandlers = true;
        private final Supplier<Map<DisplayCategory<?>, List<DisplaySpec>>> map = Suppliers.memoize(() -> ViewsImpl.buildMapFor(this));

        @Override
        public ViewSearchBuilder addCategory(CategoryIdentifier<?> category) {
            this.categories.add(category);
            return this;
        }

        @Override
        public ViewSearchBuilder addCategories(Collection<CategoryIdentifier<?>> categories) {
            this.categories.addAll(categories);
            return this;
        }

        @Override
        public Set<CategoryIdentifier<?>> getCategories() {
            return this.categories;
        }

        @Override
        public <T> ViewSearchBuilder addRecipesFor(EntryStack<T> stack) {
            this.recipesFor.add(stack);
            return this;
        }

        @Override
        public List<EntryStack<?>> getRecipesFor() {
            return this.recipesFor;
        }

        @Override
        public <T> ViewSearchBuilder addUsagesFor(EntryStack<T> stack) {
            this.usagesFor.add(stack);
            return this;
        }

        @Override
        public List<EntryStack<?>> getUsagesFor() {
            return this.usagesFor;
        }

        @Override
        public ViewSearchBuilder setPreferredOpenedCategory(@Nullable CategoryIdentifier<?> category) {
            this.preferredOpenedCategory = category;
            return this;
        }

        @Override
        @Nullable
        public CategoryIdentifier<?> getPreferredOpenedCategory() {
            return this.preferredOpenedCategory;
        }

        @Override
        public ViewSearchBuilder filterCategory(CategoryIdentifier<?> category) {
            this.filteringCategories.add(category);
            return this;
        }

        @Override
        public ViewSearchBuilder filterCategories(Collection<CategoryIdentifier<?>> categories) {
            this.filteringCategories.addAll(categories);
            return this;
        }

        @Override
        public Set<CategoryIdentifier<?>> getFilteringCategories() {
            return this.filteringCategories;
        }

        @Override
        public Map<DisplayCategory<?>, List<DisplaySpec>> buildMapInternal() {
            this.fillPreferredOpenedCategory();
            return this.map.get();
        }

        @Override
        public boolean isMergingDisplays() {
            return this.mergeDisplays;
        }

        @Override
        public ViewSearchBuilder mergingDisplays(boolean mergingDisplays) {
            this.mergeDisplays = mergingDisplays;
            return this;
        }

        @Override
        public boolean isProcessingVisibilityHandlers() {
            return this.processVisibilityHandlers;
        }

        @Override
        public ViewSearchBuilder processingVisibilityHandlers(boolean processingVisibilityHandlers) {
            this.processVisibilityHandlers = processingVisibilityHandlers;
            return this;
        }
    }

    private static abstract class AbstractViewSearchBuilder
    implements ViewSearchBuilder {
        private AbstractViewSearchBuilder() {
        }

        public ViewSearchBuilder fillPreferredOpenedCategory() {
            class_437 currentScreen;
            if (this.getPreferredOpenedCategory() == null && (currentScreen = class_310.method_1551().field_1755) instanceof DisplayScreen) {
                DisplayScreen displayScreen = (DisplayScreen)currentScreen;
                this.setPreferredOpenedCategory(displayScreen.getCurrentCategoryId());
            }
            return this;
        }

        @Override
        public Stream<DisplaySpec> streamDisplays() {
            return this.buildMapInternal().values().stream().flatMap(Collection::stream);
        }
    }
}

