/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.hooks.client.screen.ScreenHooks;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.gui.ConfigScreenProvider;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonElement;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonNull;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonObject;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonPrimitive;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.DeserializationException;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.GlobalizedClothConfigScreen;
import me.shedaniel.clothconfig2.gui.entries.KeyCodeEntry;
import me.shedaniel.clothconfig2.gui.entries.TextListEntry;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.config.CheatingMode;
import me.shedaniel.rei.api.client.gui.config.DisplayScreenType;
import me.shedaniel.rei.api.client.gui.config.SyntaxHighlightingMode;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.config.entries.FilteringEntry;
import me.shedaniel.rei.impl.client.config.entries.NoFilteringEntry;
import me.shedaniel.rei.impl.client.config.entries.RecipeScreenTypeEntry;
import me.shedaniel.rei.impl.client.config.entries.ReloadPluginsEntry;
import me.shedaniel.rei.impl.client.config.entries.SearchFilterSyntaxHighlightingEntry;
import me.shedaniel.rei.impl.client.config.entries.TitleTextEntry;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.impl.client.entry.filtering.rules.ManualFilteringRule;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.credits.CreditsScreen;
import me.shedaniel.rei.impl.client.gui.performance.entry.PerformanceEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5251;
import net.minecraft.class_6379;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class ConfigManagerImpl
implements ConfigManager {
    private boolean craftableOnly = false;
    private final Gson gson = new GsonBuilder().create();
    private ConfigObjectImpl object;

    public ConfigManagerImpl() {
        Jankson jankson = Jankson.builder().build();
        AutoConfig.register(ConfigObjectImpl.class, (definition, configClass) -> new JanksonConfigSerializer(definition, configClass, ConfigManagerImpl.buildJankson(Jankson.builder())));
        GuiRegistry guiRegistry = AutoConfig.getGuiRegistry(ConfigObjectImpl.class);
        guiRegistry.registerPredicateProvider((i13n, field, config, defaults, guiProvider) -> {
            if (field.isAnnotationPresent(ConfigEntry.Gui.Excluded.class)) {
                return Collections.emptyList();
            }
            KeyCodeEntry entry = ConfigEntryBuilder.create().startModifierKeyCodeField((class_2561)new class_2588(i13n), (ModifierKeyCode)Utils.getUnsafely((Field)field, (Object)config, (Object)ModifierKeyCode.unknown())).setModifierDefaultValue(() -> (ModifierKeyCode)Utils.getUnsafely((Field)field, (Object)defaults)).setModifierSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, (Object)newValue)).build();
            return Collections.singletonList(entry);
        }, field -> field.getType() == ModifierKeyCode.class);
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> {
            ConfigObjectImpl.UsePercentage bounds = field.getAnnotation(ConfigObjectImpl.UsePercentage.class);
            return Collections.singletonList(ConfigEntryBuilder.create().startIntSlider((class_2561)new class_2588(i13n), class_3532.method_15384((double)((Double)Utils.getUnsafely((Field)field, (Object)config, (Object)0.0) * 100.0)), class_3532.method_15384((double)(bounds.min() * 100.0)), class_3532.method_15384((double)(bounds.max() * 100.0))).setDefaultValue(() -> class_3532.method_15384((double)((Double)Utils.getUnsafely((Field)field, (Object)defaults) * 100.0))).setSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, (Object)((double)newValue.intValue() / 100.0))).setTextGetter(integer -> new class_2585(bounds.prefix() + String.format("%d%%", integer))).build());
        }, field -> field.getType() == Double.TYPE || field.getType() == Double.class, new Class[]{ConfigObjectImpl.UsePercentage.class});
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(new RecipeScreenTypeEntry(220, (class_2561)new class_2588(i13n), (DisplayScreenType)((Object)((Object)Utils.getUnsafely((Field)field, (Object)config, (Object)((Object)DisplayScreenType.UNSET)))), (DisplayScreenType)((Object)((Object)Utils.getUnsafely((Field)field, (Object)defaults))), type -> Utils.setUnsafely((Field)field, (Object)config, (Object)type))), field -> field.getType() == DisplayScreenType.class, new Class[]{ConfigObjectImpl.UseSpecialRecipeTypeScreen.class});
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(new SearchFilterSyntaxHighlightingEntry((class_2561)new class_2588(i13n), (SyntaxHighlightingMode)((Object)((Object)Utils.getUnsafely((Field)field, (Object)config, (Object)((Object)SyntaxHighlightingMode.COLORFUL)))), (SyntaxHighlightingMode)((Object)((Object)Utils.getUnsafely((Field)field, (Object)defaults))), type -> Utils.setUnsafely((Field)field, (Object)config, (Object)type))), field -> field.getType() == SyntaxHighlightingMode.class, new Class[]{ConfigObjectImpl.UseSpecialSearchFilterSyntaxHighlightingScreen.class});
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> {
            List<EntryStack<?>> value = CollectionUtils.map((Collection)Utils.getUnsafely((Field)field, (Object)config, new ArrayList()), EntryStackProvider::provide);
            List<EntryStack<?>> defaultValue = CollectionUtils.map((Collection)Utils.getUnsafely((Field)field, (Object)defaults), EntryStackProvider::provide);
            Consumer<List<EntryStack<?>>> saveConsumer = newValue -> Utils.setUnsafely((Field)field, (Object)config, CollectionUtils.map(newValue, EntryStackProvider::ofStack));
            return REIRuntime.getInstance().getPreviousContainerScreen() == null || class_310.method_1551().method_1562() == null || class_310.method_1551().method_1562().method_2877() == null ? Collections.singletonList(new NoFilteringEntry(220, value, defaultValue, saveConsumer)) : Collections.singletonList(new FilteringEntry(220, value, ((ConfigObjectImpl.Advanced.Filtering)config).filteringRules, defaultValue, saveConsumer, list -> {
                ((ConfigObjectImpl.Advanced.Filtering)config).filteringRules = Lists.newArrayList((Iterable)list);
            }));
        }, field -> field.getType() == List.class, new Class[]{ConfigObjectImpl.UseFilteringScreen.class});
        this.saveConfig();
        RoughlyEnoughItemsCore.LOGGER.info("Config loaded.");
    }

    private static Jankson buildJankson(Jankson.Builder builder) {
        builder.registerSerializer(CheatingMode.class, (value, marshaller) -> {
            if (value == CheatingMode.WHEN_CREATIVE) {
                return new JsonPrimitive((Object)"WHEN_CREATIVE");
            }
            return new JsonPrimitive((Object)(value == CheatingMode.ON ? 1 : 0));
        });
        builder.registerDeserializer(Boolean.class, CheatingMode.class, (value, unmarshaller) -> value != false ? CheatingMode.ON : CheatingMode.OFF);
        builder.registerDeserializer(String.class, CheatingMode.class, (value, unmarshaller) -> CheatingMode.valueOf(value.toUpperCase(Locale.ROOT)));
        builder.registerSerializer(class_3675.class_306.class, (value, marshaller) -> new JsonPrimitive((Object)value.method_1441()));
        builder.registerDeserializer(String.class, class_3675.class_306.class, (value, marshaller) -> class_3675.method_15981((String)value));
        builder.registerSerializer(ModifierKeyCode.class, (value, marshaller) -> {
            JsonObject object = new JsonObject();
            object.put("keyCode", (JsonElement)new JsonPrimitive((Object)value.getKeyCode().method_1441()));
            object.put("modifier", (JsonElement)new JsonPrimitive((Object)value.getModifier().getValue()));
            return object;
        });
        builder.registerDeserializer(JsonObject.class, ModifierKeyCode.class, (value, marshaller) -> {
            String code = (String)value.get(String.class, "keyCode");
            if (code.endsWith(".unknown")) {
                return ModifierKeyCode.unknown();
            }
            class_3675.class_306 keyCode = class_3675.method_15981((String)code);
            Modifier modifier = Modifier.of((short)value.getShort("modifier", (short)0));
            return ModifierKeyCode.of((class_3675.class_306)keyCode, (Modifier)modifier);
        });
        builder.registerSerializer(class_2520.class, (value, marshaller) -> marshaller.serialize((Object)value.toString()));
        builder.registerDeserializer(String.class, class_2520.class, (value, marshaller) -> {
            try {
                return class_2522.method_10718((String)value);
            }
            catch (CommandSyntaxException e) {
                throw new DeserializationException((Throwable)e);
            }
        });
        builder.registerSerializer(EntryStackProvider.class, (stack, marshaller) -> {
            try {
                return marshaller.serialize((Object)stack.save());
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(class_2520.class, EntryStackProvider.class, (value, marshaller) -> EntryStackProvider.defer((class_2487)value));
        builder.registerDeserializer(String.class, EntryStackProvider.class, (value, marshaller) -> {
            try {
                return EntryStackProvider.defer(class_2522.method_10718((String)value));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return EntryStackProvider.ofStack(EntryStack.empty());
            }
        });
        builder.registerSerializer(FilteringRule.class, (value, marshaller) -> {
            try {
                return marshaller.serialize((Object)FilteringRule.save(value, new class_2487()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(class_2520.class, FilteringRule.class, (value, marshaller) -> {
            try {
                return FilteringRule.read((class_2487)value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        builder.registerDeserializer(String.class, FilteringRule.class, (value, marshaller) -> {
            try {
                return FilteringRule.read(class_2522.method_10718((String)value));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        builder.registerSerializer(FavoriteEntry.class, (value, marshaller) -> {
            try {
                return marshaller.serialize((Object)value.save(new class_2487()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(class_2520.class, FavoriteEntry.class, (value, marshaller) -> FavoriteEntry.readDelegated((class_2487)value));
        builder.registerDeserializer(String.class, FavoriteEntry.class, (value, marshaller) -> {
            try {
                class_2487 tag = class_2522.method_10718((String)value);
                return FavoriteEntry.readDelegated(tag);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        return builder.build();
    }

    @Override
    public void startReload() {
    }

    public static ConfigManagerImpl getInstance() {
        return (ConfigManagerImpl)ConfigManager.getInstance();
    }

    @Override
    public void saveConfig() {
        if (this.getConfig().getFavoriteEntries() != null) {
            this.getConfig().getFavoriteEntries().removeIf(Objects::isNull);
        }
        if (this.getConfig().getFilteringRules().stream().noneMatch(filteringRule -> filteringRule instanceof ManualFilteringRule)) {
            this.getConfig().getFilteringRules().add(new ManualFilteringRule());
        }
        AutoConfig.getConfigHolder(ConfigObjectImpl.class).registerLoadListener((configHolder, configObject) -> {
            this.object = configObject;
            return class_1269.field_5811;
        });
        AutoConfig.getConfigHolder(ConfigObjectImpl.class).save();
    }

    @Override
    public ConfigObjectImpl getConfig() {
        if (this.object == null) {
            this.object = (ConfigObjectImpl)AutoConfig.getConfigHolder(ConfigObjectImpl.class).getConfig();
        }
        return this.object;
    }

    @Override
    public boolean isCraftableOnlyEnabled() {
        return this.craftableOnly && this.getConfig().isCraftableFilterEnabled();
    }

    @Override
    public void toggleCraftableOnly() {
        this.craftableOnly = !this.craftableOnly;
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        try {
            ConfigScreenProvider provider = (ConfigScreenProvider)AutoConfig.getConfigScreen(ConfigObjectImpl.class, (class_437)parent);
            provider.setI13nFunction(manager -> "config.roughlyenoughitems");
            provider.setOptionFunction((baseI13n, field) -> field.isAnnotationPresent(ConfigObjectImpl.DontApplyFieldName.class) ? baseI13n : String.format("%s.%s", baseI13n, field.getName()));
            provider.setCategoryFunction((baseI13n, categoryName) -> String.format("%s.%s", baseI13n, categoryName));
            provider.setBuildFunction(builder -> {
                builder.setGlobalized(true);
                builder.setGlobalizedExpanded(false);
                if (class_310.method_1551().method_1562() != null && class_310.method_1551().method_1562().method_2877() != null) {
                    TextListEntry feedbackEntry = ConfigEntryBuilder.create().startTextDescription((class_2561)new class_2588("text.rei.feedback", new Object[]{new class_2588("text.rei.feedback.link").method_27694(style -> style.method_27703(class_5251.method_27717((int)-14695425)).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://forms.gle/5tdnK5WN1wng78pV8")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new ImmutableTextComponent("https://forms.gle/5tdnK5WN1wng78pV8"))))}).method_27692(class_124.field_1080)).build();
                    builder.getOrCreateCategory((class_2561)new class_2588("config.roughlyenoughitems.advanced")).getEntries().add(0, feedbackEntry);
                    builder.getOrCreateCategory((class_2561)new class_2588("config.roughlyenoughitems.advanced")).getEntries().add(0, new ReloadPluginsEntry(220));
                    builder.getOrCreateCategory((class_2561)new class_2588("config.roughlyenoughitems.advanced")).getEntries().add(0, new PerformanceEntry(220));
                }
                return builder.setAfterInitConsumer(screen -> {
                    class EmptyEntry
                    extends AbstractConfigListEntry<Object> {
                        private final int height;

                        public EmptyEntry(int height) {
                            super((class_2561)new class_2585(UUID.randomUUID().toString()), false);
                            this.height = height;
                        }

                        public int getItemHeight() {
                            return this.height;
                        }

                        public Object getValue() {
                            return null;
                        }

                        public Optional<Object> getDefaultValue() {
                            return Optional.empty();
                        }

                        public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
                            return false;
                        }

                        public void save() {
                        }

                        public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
                        }

                        public List<? extends class_364> method_25396() {
                            return Collections.emptyList();
                        }

                        public List<? extends class_6379> narratables() {
                            return Collections.emptyList();
                        }
                    }
                    ((GlobalizedClothConfigScreen)screen).listWidget.method_25396().add(0, new EmptyEntry(4));
                    TextListEntry supportText = ConfigEntryBuilder.create().startTextDescription((class_2561)new class_2588("text.rei.support.me.desc", new Object[]{new class_2588("text.rei.support.me.patreon").method_27694(style -> style.method_27703(class_5251.method_27717((int)-14695425)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://patreon.com/shedaniel")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new ImmutableTextComponent("https://patreon.com/shedaniel")))), new class_2588("text.rei.support.me.bisect").method_27694(style -> style.method_27703(class_5251.method_27717((int)-14695425)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://www.bisecthosting.com/shedaniel")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new ImmutableTextComponent("https://www.bisecthosting.com/shedaniel"))))}).method_27692(class_124.field_1080)).build();
                    supportText.setScreen((AbstractConfigScreen)screen);
                    ((GlobalizedClothConfigScreen)screen).listWidget.method_25396().add(0, supportText);
                    ((GlobalizedClothConfigScreen)screen).listWidget.method_25396().add(0, new TitleTextEntry((class_2561)new class_2588("text.rei.support.me")));
                    ((GlobalizedClothConfigScreen)screen).listWidget.method_25396().add(0, new EmptyEntry(4));
                    ScreenHooks.addRenderableWidget((class_437)screen, (class_339)new class_4185(screen.field_22789 - 104, 4, 100, 20, (class_2561)new class_2588("text.rei.credits"), button -> {
                        CreditsScreen creditsScreen = new CreditsScreen((class_437)screen);
                        class_310.method_1551().method_1507((class_437)creditsScreen);
                    }));
                }).setSavingRunnable(() -> {
                    this.saveConfig();
                    EntryRegistry.getInstance().refilter();
                    REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                    if (REIRuntimeImpl.getSearchField() != null) {
                        ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
                    }
                }).build();
            });
            return provider.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

