/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.type.types;

import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.entry.type.BuiltinClientEntryTypes;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.impl.common.entry.type.types.BuiltinEntryDefinition;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class RenderingEntryDefinition {
    public static final EntryDefinition<Renderer> RENDERING = new BuiltinEntryDefinition<Renderer>(Renderer.class, BuiltinClientEntryTypes.RENDERING, false, RenderingEntryDefinition::throwRendering, () -> () -> DeferredRenderer.INSTANCE){

        @Override
        public class_2561 asFormattedText(EntryStack<Renderer> entry, Renderer value) {
            Tooltip tooltip = value.getTooltip(TooltipContext.ofMouse());
            if (tooltip != null) {
                for (Tooltip.Entry e : tooltip.entries()) {
                    if (!e.isText()) continue;
                    return e.getAsText();
                }
            }
            return super.asFormattedText(entry, value);
        }
    };

    private static <T> T throwRendering() {
        throw new IllegalStateException("Can not create rendering type from NBT tag!");
    }

    public static enum DeferredRenderer implements EntryRenderer<Renderer>
    {
        INSTANCE;


        @Override
        public void render(EntryStack<Renderer> entry, class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            entry.getValue().render(matrices, bounds, mouseX, mouseY, delta);
        }

        @Override
        @Nullable
        public Tooltip getTooltip(EntryStack<Renderer> entry, TooltipContext context) {
            return entry.getValue().getTooltip(context.getPoint());
        }
    }
}

