/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.ButtonArea;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.RecipeDisplayExporter;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.toast.ExportRecipeIdentifierToast;
import me.shedaniel.rei.impl.client.gui.widget.DefaultDisplayChoosePageWidget;
import me.shedaniel.rei.impl.client.gui.widget.DisplayCompositeWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.TabWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.PanelWidget;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DefaultDisplayViewingScreen
extends AbstractDisplayViewingScreen {
    public static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private final List<Widget> preWidgets = Lists.newArrayList();
    private final List<Widget> widgets = Lists.newArrayList();
    private final Map<Rectangle, Pair<DisplaySpec, List<Widget>>> recipeBounds = Maps.newHashMap();
    private final List<TabWidget> tabs = Lists.newArrayList();
    public int page;
    public int categoryPages = -1;
    @Nullable
    private Panel workingStationsBaseWidget;
    private Button recipeBack;
    private Button recipeNext;
    private Button categoryBack;
    private Button categoryNext;
    private final ValueAnimator<Color> darkStripesColor = ValueAnimator.ofColor().withConvention(() -> Color.ofTransparent((int)(REIRuntime.getInstance().isDarkThemeEnabled() ? -12566464 : -6381922)), ValueAnimator.typicalTransitionTime());

    public DefaultDisplayViewingScreen(Map<DisplayCategory<?>, List<DisplaySpec>> categoriesMap, @Nullable CategoryIdentifier<?> category) {
        super(categoriesMap, category, 5);
        this.bounds = new Rectangle(0, 0, 176, 150);
    }

    @Override
    public void recalculateCategoryPage() {
        this.categoryPages = -1;
    }

    @Nullable
    public Panel getWorkingStationsBaseWidget() {
        return this.workingStationsBaseWidget;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258 && !this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            boolean next;
            boolean bl = next = !DefaultDisplayViewingScreen.method_25442();
            if (!this.method_25407(next)) {
                this.method_25407(next);
            }
            return true;
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesKey(keyCode, scanCode)) {
            if (this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
            return this.recipeNext.isEnabled();
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesKey(keyCode, scanCode)) {
            if (this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            }
            return this.recipeBack.isEnabled();
        }
        for (class_364 element : this.method_25396()) {
            if (!element.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (keyCode == 256 || this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            class_310.method_1551().method_1507(REIRuntime.getInstance().getPreviousScreen());
            return true;
        }
        if (ConfigObject.getInstance().getPreviousScreenKeybind().matchesKey(keyCode, scanCode)) {
            if (REIRuntimeImpl.getInstance().hasLastDisplayScreen()) {
                this.field_22787.method_1507(REIRuntimeImpl.getInstance().getLastDisplayScreen());
            } else {
                this.field_22787.method_1507(REIRuntime.getInstance().getPreviousScreen());
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25426() {
        super.method_25426();
        this.method_25396().clear();
        this.recipeBounds.clear();
        this.tabs.clear();
        this.preWidgets.clear();
        this.widgets.clear();
        int largestHeight = Math.min(Math.max(this.field_22790 - 34 - 30, 100), ConfigObject.getInstance().getMaxRecipesPageHeight());
        int maxWidthDisplay = CollectionUtils.mapAndMax(this.getCurrentDisplayed(), display -> this.getCurrentCategory().getDisplayWidth(display.provideInternalDisplay()), Comparator.naturalOrder()).orElse(150);
        int maxHeight = Math.min(largestHeight, CollectionUtils.mapAndMax(this.categories, category -> (category.getDisplayHeight() + 4) * Math.max(1, Math.min(DefaultDisplayViewingScreen.getRecipesPerPage(largestHeight, category) + 1, Math.max(((List)this.categoryMap.get(category)).size(), ConfigObject.getInstance().getMaxRecipePerPage()))) + 36, Comparator.naturalOrder()).orElse(66));
        int totalDisplayHeight = (this.getCurrentCategory().getDisplayHeight() + 4) * Math.max(1, DefaultDisplayViewingScreen.getRecipesPerPage(maxHeight, this.getCurrentCategory()) + 1) + 36;
        int guiWidth = Math.max(maxWidthDisplay + 10 + 14 + 14, 190);
        this.bounds = new Rectangle(this.field_22789 / 2 - guiWidth / 2, this.field_22790 / 2 - maxHeight / 2, guiWidth, maxHeight);
        if (ConfigObject.getInstance().isSubsetsEnabled()) {
            this.bounds.setLocation(this.bounds.getX(), this.bounds.getY() + 15);
            this.bounds.setSize(this.bounds.getWidth(), this.bounds.getHeight() - 10);
        }
        boolean isCompactTabs = ConfigObject.getInstance().isUsingCompactTabs();
        boolean isCompactTabButtons = ConfigObject.getInstance().isUsingCompactTabButtons();
        int tabButtonsSize = isCompactTabButtons ? 10 : 16;
        int tabSize = isCompactTabs ? 24 : 28;
        this.tabsPerPage = Math.max(5, class_3532.method_15357((double)(((double)guiWidth - (double)tabButtonsSize * 2.0) / (double)tabSize)));
        if (this.categoryPages == -1) {
            this.categoryPages = Math.max(0, this.selectedCategoryIndex / this.tabsPerPage);
        }
        this.page = class_3532.method_15340((int)this.page, (int)0, (int)(this.getCurrentTotalPages() - 1));
        this.widgets.add(Widgets.createButton(new Rectangle(this.bounds.x, this.bounds.y - (isCompactTabButtons ? 16 : 20), tabButtonsSize, tabButtonsSize), (class_2561)new class_2588("text.rei.left_arrow")).onClick(button -> {
            --this.categoryPages;
            if (this.categoryPages < 0) {
                this.categoryPages = class_3532.method_15386((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1;
            }
            this.method_25426();
        }).tooltipLine((class_2561)new class_2588("text.rei.previous_page")).enabled(this.categories.size() > this.tabsPerPage));
        this.widgets.add(Widgets.createButton(new Rectangle(this.bounds.x + this.bounds.width - tabButtonsSize - (isCompactTabButtons ? 0 : 1), this.bounds.y - (isCompactTabButtons ? 16 : 20), tabButtonsSize, tabButtonsSize), (class_2561)new class_2588("text.rei.right_arrow")).onClick(button -> {
            ++this.categoryPages;
            if (this.categoryPages > class_3532.method_15386((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1) {
                this.categoryPages = 0;
            }
            this.method_25426();
        }).tooltipLine((class_2561)new class_2588("text.rei.next_page")).enabled(this.categories.size() > this.tabsPerPage));
        this.categoryBack = Widgets.createButton(new Rectangle(this.bounds.getX() + 5, this.bounds.getY() + 5, 12, 12), (class_2561)new class_2588("text.rei.left_arrow")).onClick(button -> this.previousCategory()).tooltipLine((class_2561)new class_2588("text.rei.previous_category"));
        this.widgets.add(this.categoryBack);
        this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.getCenterX(), this.bounds.getY() + 7), this.getCurrentCategory().getTitle(), clickableLabelWidget -> ViewSearchBuilder.builder().addAllCategories().open()).tooltip(new class_2561[]{new class_2588("text.rei.view_all_categories")}));
        this.categoryNext = Widgets.createButton(new Rectangle(this.bounds.getMaxX() - 17, this.bounds.getY() + 5, 12, 12), (class_2561)new class_2588("text.rei.right_arrow")).onClick(button -> this.nextCategory()).tooltipLine((class_2561)new class_2588("text.rei.next_category"));
        this.widgets.add(this.categoryNext);
        this.categoryBack.setEnabled(this.categories.size() > 1);
        this.categoryNext.setEnabled(this.categories.size() > 1);
        this.recipeBack = Widgets.createButton(new Rectangle(this.bounds.getX() + 5, this.bounds.getY() + 19, 12, 12), (class_2561)new class_2588("text.rei.left_arrow")).onClick(button -> {
            --this.page;
            if (this.page < 0) {
                this.page = this.getCurrentTotalPages() - 1;
            }
            this.method_25426();
        }).tooltipLine((class_2561)new class_2588("text.rei.previous_page"));
        this.widgets.add(this.recipeBack);
        this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.getCenterX(), this.bounds.getY() + 21), class_333.field_18967, label -> {
            if (!class_437.method_25442()) {
                this.page = 0;
                this.method_25426();
            } else {
                ScreenOverlayImpl.getInstance().choosePageWidget = new DefaultDisplayChoosePageWidget(page -> {
                    this.page = page;
                    this.method_25426();
                }, this.page, this.getCurrentTotalPages());
            }
        }).onRender((matrices, label) -> {
            label.setMessage((class_5348)new ImmutableTextComponent(String.format("%d/%d", this.page + 1, this.getCurrentTotalPages())));
            label.setClickable(this.getCurrentTotalPages() > 1);
        }).tooltipFunction(label -> {
            class_2561[] class_2561Array;
            if (label.isClickable()) {
                class_2561[] class_2561Array2 = new class_2561[3];
                class_2561Array2[0] = new class_2588("text.rei.go_back_first_page");
                class_2561Array2[1] = new class_2585(" ");
                class_2561Array = class_2561Array2;
                class_2561Array2[2] = new class_2588("text.rei.shift_click_to", new Object[]{new class_2588("text.rei.choose_page")}).method_27692(class_124.field_1080);
            } else {
                class_2561Array = null;
            }
            return class_2561Array;
        }));
        this.recipeNext = Widgets.createButton(new Rectangle(this.bounds.getMaxX() - 17, this.bounds.getY() + 19, 12, 12), (class_2561)new class_2588("text.rei.right_arrow")).onClick(button -> {
            ++this.page;
            if (this.page >= this.getCurrentTotalPages()) {
                this.page = 0;
            }
            this.method_25426();
        }).tooltipLine((class_2561)new class_2588("text.rei.next_page"));
        this.widgets.add(this.recipeNext);
        this.recipeBack.setEnabled(this.getCurrentTotalPages() > 1);
        this.recipeNext.setEnabled(this.getCurrentTotalPages() > 1);
        for (int id = 0; id < this.tabsPerPage; ++id) {
            int tabIndex = id + this.categoryPages * this.tabsPerPage;
            if (this.categories.size() <= tabIndex) continue;
            TabWidget tab = TabWidget.create(id, tabSize, this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.categoryPages * this.tabsPerPage, this.tabsPerPage) * tabSize / 2, this.bounds.y, 0, isCompactTabs ? 166 : 192, widget -> {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                if (widget.getId() + this.categoryPages * this.tabsPerPage == this.selectedCategoryIndex) {
                    return false;
                }
                ClientHelperImpl.getInstance().openDisplayViewingScreen(this.categoryMap, ((DisplayCategory)this.categories.get(widget.getId() + this.categoryPages * this.tabsPerPage)).getCategoryIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
                return true;
            });
            this.tabs.add(tab);
            tab.setRenderer((DisplayCategory)this.categories.get(tabIndex), ((DisplayCategory)this.categories.get(tabIndex)).getIcon(), ((DisplayCategory)this.categories.get(tabIndex)).getTitle(), tab.getId() + this.categoryPages * this.tabsPerPage == this.selectedCategoryIndex);
        }
        this.initDisplays();
        this.initWorkstations(this.preWidgets);
        this._children().addAll(this.tabs);
        this._children().addAll(this.widgets);
        this._children().addAll(this.preWidgets);
    }

    private void initDisplays() {
        Optional<ButtonArea> plusButtonArea = CategoryRegistry.getInstance().get(this.getCurrentCategoryId()).getPlusButtonArea();
        int displayHeight = this.getCurrentCategory().getDisplayHeight();
        List<DisplaySpec> currentDisplayed = this.getCurrentDisplayed();
        for (int i = 0; i < currentDisplayed.size(); ++i) {
            ArrayList<Widget> setupDisplay;
            DisplaySpec display = currentDisplayed.get(i);
            Supplier<Display> displaySupplier = display::provideInternalDisplay;
            int displayWidth = this.getCurrentCategory().getDisplayWidth(displaySupplier.get());
            Rectangle displayBounds = new Rectangle(this.getBounds().getCenterX() - displayWidth / 2, this.getBounds().getCenterY() + 16 - displayHeight * (this.getRecipesPerPage() + 1) / 2 - 2 * (this.getRecipesPerPage() + 1) + displayHeight * i + 4 * i, displayWidth, displayHeight);
            try {
                setupDisplay = this.getCurrentCategoryView(display.provideInternalDisplay()).setupDisplay(display.provideInternalDisplay(), displayBounds);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                setupDisplay = new ArrayList();
                setupDisplay.add(Widgets.createRecipeBase(displayBounds).color(-4521984));
                setupDisplay.add(Widgets.createLabel(new Point(displayBounds.getCenterX(), displayBounds.getCenterY() - 8), (class_2561)new class_2585("Failed to initiate setupDisplay")));
                setupDisplay.add(Widgets.createLabel(new Point(displayBounds.getCenterX(), displayBounds.getCenterY() + 1), (class_2561)new class_2585("Check console for error")));
            }
            this.setupTags(setupDisplay);
            this.transformFiltering(setupDisplay);
            this.transformIngredientNotice(setupDisplay, this.ingredientStackToNotice);
            this.transformResultNotice(setupDisplay, this.resultStackToNotice);
            for (EntryWidget widget : Widgets.walk(this.widgets, EntryWidget.class::isInstance)) {
                widget.removeTagMatch = true;
            }
            this.recipeBounds.put(displayBounds, (Pair<DisplaySpec, List<Widget>>)Pair.of((Object)display, setupDisplay));
            this.widgets.add(new DisplayCompositeWidget(display, setupDisplay, displayBounds));
            if (!plusButtonArea.isPresent()) continue;
            this.widgets.add(InternalWidgets.createAutoCraftingButtonWidget(displayBounds, plusButtonArea.get().get(displayBounds), (class_2561)new class_2585(plusButtonArea.get().getButtonText()), displaySupplier, display::provideInternalDisplayIds, setupDisplay, this.getCurrentCategory()));
        }
    }

    private void initWorkstations(List<Widget> preWidgets) {
        this.workingStationsBaseWidget = null;
        List<EntryIngredient> workstations = CategoryRegistry.getInstance().get(this.getCurrentCategoryId()).getWorkstations();
        if (!workstations.isEmpty()) {
            int hh = class_3532.method_15375((float)((float)(this.bounds.height - 16) / 18.0f));
            int actualHeight = Math.min(hh, workstations.size());
            int innerWidth = class_3532.method_15386((float)((float)workstations.size() / (float)hh));
            int xx = this.bounds.x - (8 + innerWidth * 16) + 6;
            int yy = this.bounds.y + 16;
            this.workingStationsBaseWidget = Widgets.createCategoryBase(new Rectangle(xx - 5, yy - 5, 15 + innerWidth * 16, 10 + actualHeight * 16));
            preWidgets.add(this.workingStationsBaseWidget);
            preWidgets.add(Widgets.createSlotBase(new Rectangle(xx - 1, yy - 1, innerWidth * 16 + 2, actualHeight * 16 + 2)));
            int index = 0;
            xx += (innerWidth - 1) * 16;
            for (EntryIngredient workingStation : workstations) {
                preWidgets.add(new WorkstationSlotWidget(xx, yy, workingStation));
                yy += 16;
                if (++index < hh) continue;
                index = 0;
                yy = this.bounds.y + 16;
                xx -= 16;
            }
        }
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public List<DisplaySpec> getCurrentDisplayed() {
        ArrayList list = Lists.newArrayList();
        int recipesPerPage = this.getRecipesPerPage();
        List displays = (List)this.categoryMap.get(this.getCurrentCategory());
        for (int i = 0; i <= recipesPerPage; ++i) {
            if (this.page * (recipesPerPage + 1) + i >= displays.size()) continue;
            list.add((DisplaySpec)displays.get(this.page * (recipesPerPage + 1) + i));
        }
        return list;
    }

    public int getPage() {
        return this.page;
    }

    public int getCategoryPage() {
        return this.categoryPages;
    }

    private int getRecipesPerPage() {
        return DefaultDisplayViewingScreen.getRecipesPerPage(this.bounds.height, this.getCurrentCategory());
    }

    private static int getRecipesPerPage(int totalHeight, DisplayCategory<?> category) {
        if (category.getFixedDisplaysPerPage() > 0) {
            return category.getFixedDisplaysPerPage() - 1;
        }
        int height = category.getDisplayHeight();
        return class_3532.method_15340((int)(class_3532.method_15357((double)(((double)totalHeight - 36.0) / ((double)height + 4.0))) - 1), (int)0, (int)Math.min(ConfigObject.getInstance().getMaxRecipePerPage() - 1, category.getMaximumDisplaysPerPage() - 1));
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.darkStripesColor.update((double)delta);
        this.method_25420(matrices);
        for (Widget widget : this.preWidgets) {
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
        PanelWidget.render(matrices, this.bounds, -1, delta);
        DefaultDisplayViewingScreen.method_25294((class_4587)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)((Color)this.darkStripesColor.value()).getColor());
        DefaultDisplayViewingScreen.method_25294((class_4587)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 19), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 31), (int)((Color)this.darkStripesColor.value()).getColor());
        for (TabWidget tab : this.tabs) {
            if (tab.isSelected()) continue;
            tab.method_25394(matrices, mouseX, mouseY, delta);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        for (Widget widget : this.widgets) {
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (TabWidget tab : this.tabs) {
            if (!tab.isSelected()) continue;
            tab.method_25394(matrices, mouseX, mouseY, delta);
        }
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesCurrentKey() || export.matchesCurrentMouse()) {
            for (Rectangle bounds : Iterables.concat(this.recipeBounds.keySet(), (Iterable)Iterables.transform(this.tabs, TabWidget::getBounds))) {
                this.method_25304(470);
                if (bounds.contains(mouseX, mouseY)) {
                    this.method_25296(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 1744822402, 1744822402);
                    class_2588 text = new class_2588("text.rei.release_export", new Object[]{export.getLocalizedName().method_27662().getString()});
                    class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
                    matrices.method_22903();
                    matrices.method_22904(0.0, 0.0, 480.0);
                    class_1159 matrix4f = matrices.method_23760().method_23761();
                    this.field_22793.method_22942(text.method_30937(), (float)bounds.getCenterX() - (float)this.field_22793.method_27525((class_5348)text) / 2.0f, (float)bounds.getCenterY() - 4.5f, -16777216, false, matrix4f, (class_4597)immediate, false, 0, 0xF000F0);
                    immediate.method_22993();
                    matrices.method_22909();
                } else {
                    this.method_25296(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 0x67FFFFFF, 0x67FFFFFF);
                }
                this.method_25304(0);
            }
        }
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesKey(keyCode, scanCode) && this.checkExportDisplays()) {
            return true;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public int getCurrentTotalPages() {
        return this.getTotalPages(this.selectedCategoryIndex);
    }

    public int getTotalPages(int categoryIndex) {
        return class_3532.method_15384((double)((double)((List)this.categoryMap.get(this.categories.get(categoryIndex))).size() / (double)(this.getRecipesPerPage() + 1)));
    }

    public boolean method_25400(char char_1, int int_1) {
        for (class_364 listener : this.method_25396()) {
            if (!listener.method_25400(char_1, int_1)) continue;
            return true;
        }
        return super.method_25400(char_1, int_1);
    }

    public boolean method_25403(double double_1, double double_2, int int_1, double double_3, double double_4) {
        for (class_364 entry : this.method_25396()) {
            if (!entry.method_25403(double_1, double_2, int_1, double_3, double_4)) continue;
            return true;
        }
        return super.method_25403(double_1, double_2, int_1, double_3, double_4);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesMouse(button) && this.checkExportDisplays()) {
            return true;
        }
        for (class_364 entry : this.method_25396()) {
            if (!entry.method_25406(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private boolean checkExportDisplays() {
        Rectangle bounds;
        for (Map.Entry<Rectangle, Pair<DisplaySpec, List<Widget>>> entry : this.recipeBounds.entrySet()) {
            bounds = entry.getKey();
            if (!bounds.contains(PointHelper.ofMouse())) continue;
            RecipeDisplayExporter.exportRecipeDisplay(bounds, (DisplaySpec)entry.getValue().left(), (List)entry.getValue().right(), true);
            return true;
        }
        for (TabWidget tab : this.tabs) {
            bounds = tab.getBounds();
            if (!bounds.contains(PointHelper.ofMouse())) continue;
            this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                if (confirmed) {
                    for (DisplaySpec spec : this.categoryMap.getOrDefault(tab.category, Collections.emptyList())) {
                        List<Widget> setupDisplay;
                        Display display = spec.provideInternalDisplay();
                        int displayWidth = this.getCurrentCategory().getDisplayWidth(display);
                        int displayHeight = this.getCurrentCategory().getDisplayHeight();
                        Rectangle displayBounds = new Rectangle(0, 0, displayWidth, displayHeight);
                        try {
                            setupDisplay = this.getCurrentCategoryView(display).setupDisplay(display, displayBounds);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            setupDisplay = new ArrayList<Widget>();
                            setupDisplay.add(Widgets.createRecipeBase(displayBounds).color(-4521984));
                            setupDisplay.add(Widgets.createLabel(new Point(displayBounds.getCenterX(), displayBounds.getCenterY() - 8), (class_2561)new class_2585("Failed to initiate setupDisplay")));
                            setupDisplay.add(Widgets.createLabel(new Point(displayBounds.getCenterX(), displayBounds.getCenterY() + 1), (class_2561)new class_2585("Check console for error")));
                        }
                        this.setupTags(setupDisplay);
                        this.transformFiltering(setupDisplay);
                        this.transformIngredientNotice(setupDisplay, this.ingredientStackToNotice);
                        this.transformResultNotice(setupDisplay, this.resultStackToNotice);
                        for (EntryWidget widget : Widgets.walk(this.widgets, EntryWidget.class::isInstance)) {
                            widget.removeTagMatch = true;
                        }
                        RecipeDisplayExporter.exportRecipeDisplay(displayBounds, spec, setupDisplay, false);
                    }
                    ExportRecipeIdentifierToast.addToast(class_1074.method_4662((String)"msg.rei.exported_recipe", (Object[])new Object[0]), class_1074.method_4662((String)"msg.rei.exported_recipe.desc", (Object[])new Object[0]));
                }
                this.field_22787.method_1507((class_437)this);
            }, (class_2561)new class_2588("text.rei.ask_to_export", new Object[]{tab.categoryName}), (class_2561)new class_2588("text.rei.ask_to_export.subtitle", new Object[]{this.categoryMap.getOrDefault(tab.category, Collections.emptyList()).size()})));
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        REIRuntimeImpl.isWithinRecipeViewingScreen = true;
        for (class_364 listener : this.method_25396()) {
            if (!listener.method_25401(mouseX, mouseY, amount)) continue;
            REIRuntimeImpl.isWithinRecipeViewingScreen = false;
            return true;
        }
        REIRuntimeImpl.isWithinRecipeViewingScreen = false;
        if (this.getBounds().contains(PointHelper.ofMouse())) {
            if (amount > 0.0 && this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            } else if (amount < 0.0 && this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
        }
        if (new Rectangle(this.bounds.x, this.bounds.y - 28, this.bounds.width, 28).contains(PointHelper.ofMouse())) {
            if (amount > 0.0 && this.categoryBack.isEnabled()) {
                this.categoryBack.onClick();
            } else if (amount < 0.0 && this.categoryNext.isEnabled()) {
                this.categoryNext.onClick();
            }
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (ConfigObject.getInstance().getNextPageKeybind().matchesMouse(button)) {
            if (this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
            return this.recipeNext.isEnabled();
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesMouse(button)) {
            if (this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            }
            return this.recipeBack.isEnabled();
        }
        if (ConfigObject.getInstance().getPreviousScreenKeybind().matchesMouse(button)) {
            if (REIRuntimeImpl.getInstance().hasLastDisplayScreen()) {
                this.field_22787.method_1507(REIRuntimeImpl.getInstance().getLastDisplayScreen());
            } else {
                this.field_22787.method_1507(REIRuntime.getInstance().getPreviousScreen());
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public static class WorkstationSlotWidget
    extends EntryWidget {
        public WorkstationSlotWidget(int x, int y, EntryIngredient widgets) {
            super(new Point(x, y));
            this.entries((Collection)widgets);
            this.noBackground();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return this.getInnerBounds().contains(mouseX, mouseY);
        }
    }
}

