/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.CachedEntryListRender;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListSearchManager;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListStackEntry;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionRenderingDebugger;
import net.minecraft.class_1159;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EntryListWidget
extends WidgetWithBounds
implements OverlayListWidget,
DraggableStackVisitorWidget {
    private static final int SIZE = 18;
    private int page;
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return EntryListWidget.this.getBounds();
        }

        public int getMaxScrollHeight() {
            return class_3532.method_15386((float)((float)(EntryListWidget.this.allStacks.size() + EntryListWidget.this.blockedCount) / ((float)EntryListWidget.this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
        }
    };
    protected int blockedCount;
    private final RegionRenderingDebugger debugger = new RegionRenderingDebugger();
    private Rectangle bounds;
    private Rectangle innerBounds;
    private List<EntryStack<?>> allStacks = null;
    private List<EntryListStackEntry> entries = Collections.emptyList();
    private List<Widget> renders = Collections.emptyList();
    private List<Widget> children = Collections.emptyList();
    public final NumberAnimator<Double> scaleIndicator = ValueAnimator.ofDouble((double)0.0).withConvention(() -> 0.0, 8000L);

    public static int entrySize() {
        return class_3532.method_15384((double)(18.0 * ConfigObject.getInstance().getEntrySize()));
    }

    public static boolean notSteppingOnExclusionZones(int left, int top, int width, int height) {
        class_310 instance = class_310.method_1551();
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(instance.field_1755)) {
            class_1269 fit = EntryListWidget.canItemSlotWidgetFit(left, top, width, height, decider);
            if (fit == class_1269.field_5811) continue;
            return fit == class_1269.field_5812;
        }
        return true;
    }

    private static class_1269 canItemSlotWidgetFit(int left, int top, int width, int height, OverlayDecider decider) {
        class_1269 fit = decider.isInZone(left, top);
        if (fit != class_1269.field_5811) {
            return fit;
        }
        fit = decider.isInZone(left + width, top);
        if (fit != class_1269.field_5811) {
            return fit;
        }
        fit = decider.isInZone(left, top + height);
        if (fit != class_1269.field_5811) {
            return fit;
        }
        fit = decider.isInZone(left + width, top + height);
        return fit;
    }

    private boolean containsChecked(Point point, boolean inner) {
        return this.containsChecked(point.x, point.y, inner);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return this.hasSpace() && super.containsMouse(mouseX, mouseY);
    }

    public boolean innerContainsMouse(double mouseX, double mouseY) {
        return this.hasSpace() && this.innerBounds.contains(mouseX, mouseY);
    }

    public boolean containsChecked(double x, double y, boolean inner) {
        if (inner ? !this.innerContainsMouse(x, y) : !this.containsMouse(x, y)) {
            return false;
        }
        class_310 instance = class_310.method_1551();
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(instance.field_1755)) {
            class_1269 result = decider.isInZone(x, y);
            if (result == class_1269.field_5811) continue;
            return result == class_1269.field_5812;
        }
        return true;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        bounds = bounds.clone();
        int heightReduction = (int)Math.round((double)bounds.height * (1.0 - ConfigObject.getInstance().getVerticalEntriesBoundariesPercentage()));
        bounds.y += heightReduction / 2;
        bounds.height -= heightReduction;
        int maxHeight = (int)Math.ceil((double)EntryListWidget.entrySize() * ConfigObject.getInstance().getVerticalEntriesBoundariesRows());
        if (bounds.height > maxHeight) {
            bounds.y += (bounds.height - maxHeight) / 2;
            bounds.height = maxHeight;
        }
        int entrySize = EntryListWidget.entrySize();
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / (float)entrySize)), 1);
            if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) + 3.0f), bounds.y, width * entrySize, bounds.height);
            }
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) - 3.0f), bounds.y, width * entrySize, bounds.height);
        }
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2) / (float)entrySize)), 1);
        int height = Math.max(class_3532.method_15375((float)((float)(bounds.height - 2) / (float)entrySize)), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f)), (int)((float)bounds.getCenterY() - (float)height * ((float)entrySize / 2.0f)), width * entrySize, height * entrySize);
    }

    @Override
    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<class_437> context, DraggableStack stack) {
        if (this.innerBounds.contains(context.getCurrentPosition())) {
            context.renderToVoid(stack);
            return DraggedAcceptorResult.CONSUMED;
        }
        return DraggedAcceptorResult.PASS;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.containsChecked(mouseX, mouseY, false)) {
            if (class_437.method_25441()) {
                ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
                this.scaleIndicator.setAs(10.0);
                if (config.setEntrySize(config.getEntrySize() + amount * 0.075)) {
                    ConfigManager.getInstance().saveConfig();
                    REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                    return true;
                }
            } else if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
                this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void previousPage() {
        --this.page;
    }

    public void nextPage() {
        ++this.page;
    }

    public int getTotalPages() {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            return 1;
        }
        return class_3532.method_15386((float)((float)this.allStacks.size() / (float)this.entries.size()));
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (!this.hasSpace()) {
            return;
        }
        boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            ScissorsHandler.INSTANCE.scissor(this.bounds);
            int skip = Math.max(0, class_3532.method_15357((double)(this.scrolling.scrollAmount() / (double)EntryListWidget.entrySize())));
            int nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize();
            this.blockedCount = 0;
            BatchedEntryRendererManager batchedEntryRendererManager = new BatchedEntryRendererManager();
            int i = nextIndex;
            for (int cont = nextIndex; cont < this.entries.size(); ++cont) {
                EntryListStackEntry entry = this.entries.get(cont);
                Rectangle entryBounds = entry.getBounds();
                entryBounds.y = entry.backupY - this.scrolling.scrollAmountInt();
                if (entryBounds.y > this.bounds.getMaxY() || this.allStacks.size() <= i) break;
                if (EntryListWidget.notSteppingOnExclusionZones(entryBounds.x, entryBounds.y, entryBounds.width, entryBounds.height)) {
                    EntryStack<?> stack2 = this.allStacks.get(i++);
                    entry.clearStacks();
                    if (stack2.isEmpty()) continue;
                    entry.entry((EntryStack)stack2);
                    batchedEntryRendererManager.add(entry);
                    continue;
                }
                ++this.blockedCount;
            }
            batchedEntryRendererManager.render(this.debugger.debugTime, this.debugger.size, this.debugger.time, matrices, mouseX, mouseY, delta);
            this.scrolling.updatePosition(delta);
            ScissorsHandler.INSTANCE.removeLastScissor();
            if (this.scrolling.getMaxScroll() > 0) {
                this.scrolling.renderScrollBar(0, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
            }
        } else {
            for (Widget widget : this.renders) {
                widget.method_25394(matrices, mouseX, mouseY, delta);
            }
            if (ConfigObject.getInstance().doesCacheEntryRendering()) {
                for (EntryListStackEntry entry : this.entries) {
                    CachedEntryListRender.Sprite sprite;
                    if (entry.our != null || (sprite = CachedEntryListRender.get(entry.getCurrentEntry())) == null) continue;
                    entry.our = ClientEntryStacks.setRenderer(entry.getCurrentEntry().copy().cast(), stack -> new EntryRenderer<Object>(){

                        @Override
                        public void render(EntryStack<Object> entry, class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                            RenderSystem.setShaderTexture((int)0, (class_2960)CachedEntryListRender.cachedTextureLocation);
                            class_332.method_25295((class_1159)matrices.method_23760().method_23761(), (int)bounds.x, (int)bounds.getMaxX(), (int)bounds.y, (int)bounds.getMaxY(), (int)EntryListWidget.this.method_25305(), (float)sprite.u0, (float)sprite.u1, (float)sprite.v0, (float)sprite.v1);
                        }

                        @Override
                        @Nullable
                        public Tooltip getTooltip(EntryStack<Object> entry, TooltipContext context) {
                            return stack.getDefinition().getRenderer().getTooltip(entry.cast(), context);
                        }
                    });
                }
                BatchedEntryRendererManager.renderSlow(this.debugger.debugTime, this.debugger.size, this.debugger.time, matrices, mouseX, mouseY, delta, this.entries);
            } else {
                new BatchedEntryRendererManager(this.entries).render(this.debugger.debugTime, this.debugger.size, this.debugger.time, matrices, mouseX, mouseY, delta);
            }
        }
        this.debugger.render(matrices, this.bounds.x, this.bounds.y, delta);
        if (this.containsChecked(mouseX, mouseY, false) && ClientHelper.getInstance().isCheating() && !(class_310.method_1551().field_1755 instanceof DisplayScreen) && !this.minecraft.field_1724.field_7512.method_34255().method_7960() && ClientHelperImpl.getInstance().canDeleteItems()) {
            EntryStack<class_1799> stack3 = EntryStacks.of(this.minecraft.field_1724.field_7512.method_34255().method_7972());
            if (stack3.getType() != VanillaEntryTypes.ITEM) {
                EntryStack<class_1799> cheatsAs = stack3.cheatsAs();
                stack3 = cheatsAs.isEmpty() ? stack3 : cheatsAs;
            }
            for (Widget widget : this.method_25396()) {
                EntryWidget widget2;
                if (!widget.containsMouse(mouseX, mouseY) || !(widget instanceof EntryWidget) || !(widget2 = (EntryWidget)widget).cancelDeleteItems(stack3)) continue;
                return;
            }
            Tooltip.create(new class_2561[]{new class_2588("text.rei.delete_items")}).queue();
        }
        this.scaleIndicator.update((double)delta);
        if ((Double)this.scaleIndicator.value() > 0.04) {
            class_2585 component = new class_2585(Math.round(ConfigObject.getInstance().getEntrySize() * 100.0) + "%");
            int width = this.font.method_27525((class_5348)component);
            int n = (int)Math.round(160.0 * class_3532.method_15350((double)((Double)this.scaleIndicator.value()), (double)0.0, (double)1.0)) << 24;
            int textColor = (int)Math.round(221.0 * class_3532.method_15350((double)((Double)this.scaleIndicator.value()), (double)0.0, (double)1.0)) << 24;
            this.method_25296(matrices, this.bounds.getCenterX() - width / 2 - 2, this.bounds.getCenterY() - 6, this.bounds.getCenterX() + width / 2 + 2, this.bounds.getCenterY() + 6, n, n);
            this.font.method_30883(matrices, (class_2561)component, (float)(this.bounds.getCenterX() - width / 2), (float)(this.bounds.getCenterY() - 4), 0xFFFFFF | textColor);
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.hasSpace() && this.scrolling.mouseDragged(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.containsChecked(EntryListWidget.mouse(), false)) {
            for (Widget widget : this.children) {
                if (!widget.method_25404(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateArea(Rectangle bounds, String searchTerm) {
        this.bounds = REIRuntime.getInstance().calculateEntryListArea(bounds);
        FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateFavoritesBounds(searchTerm);
        }
        if (this.allStacks == null || ConfigObject.getInstance().isFavoritesEnabled() && favoritesListWidget == null) {
            this.updateSearch(searchTerm, true);
        } else {
            this.updateEntriesPosition();
        }
    }

    public boolean hasSpace() {
        int height;
        int entrySize = EntryListWidget.entrySize();
        int width = this.innerBounds.width / entrySize;
        return width * (height = this.innerBounds.height / entrySize) > 0;
    }

    public void updateEntriesPosition() {
        int entrySize = EntryListWidget.entrySize();
        boolean zoomed = ConfigObject.getInstance().isFocusModeZoomed();
        this.innerBounds = EntryListWidget.updateInnerBounds(this.bounds);
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.updateScrolledEntries(entrySize, zoomed);
        } else {
            this.updatePaginatedEntries(entrySize, zoomed);
        }
        FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.getSystemRegion().updateEntriesPosition(entry -> true);
            favoritesListWidget.getRegion().updateEntriesPosition(entry -> true);
        }
    }

    private void updateScrolledEntries(int entrySize, boolean zoomed) {
        this.page = 0;
        int width = this.innerBounds.width / entrySize;
        int pageHeight = this.innerBounds.height / entrySize;
        int slotsToPrepare = Math.max(this.allStacks.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * entrySize + this.innerBounds.x;
            int yPos = currentY * entrySize + this.innerBounds.y;
            entries.add((EntryListStackEntry)new EntryListStackEntry(this, xPos, yPos, entrySize, zoomed).noBackground());
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
        this.children = Lists.newArrayList(this.renders);
        this.children.addAll(entries);
    }

    private void updatePaginatedEntries(int entrySize, boolean zoomed) {
        this.renders = Lists.newArrayList();
        this.page = Math.max(this.page, 0);
        ArrayList entries = Lists.newArrayList();
        int width = this.innerBounds.width / entrySize;
        int height = this.innerBounds.height / entrySize;
        for (int currentY = 0; currentY < height; ++currentY) {
            for (int currentX = 0; currentX < width; ++currentX) {
                int slotX = currentX * entrySize + this.innerBounds.x;
                int slotY = currentY * entrySize + this.innerBounds.y;
                if (!EntryListWidget.notSteppingOnExclusionZones(slotX - 1, slotY - 1, entrySize, entrySize)) continue;
                entries.add((EntryListStackEntry)new EntryListStackEntry(this, slotX, slotY, entrySize, zoomed).noBackground());
            }
        }
        this.page = Math.max(Math.min(this.page, this.getTotalPages() - 1), 0);
        List subList = this.allStacks.stream().skip(Math.max(0, this.page * entries.size())).limit(Math.max(0, entries.size() - Math.max(0, -this.page * entries.size()))).collect(Collectors.toList());
        for (int i = 0; i < subList.size(); ++i) {
            EntryStack stack = (EntryStack)subList.get(i);
            ((EntryListStackEntry)entries.get(i + Math.max(0, -this.page * entries.size()))).clearStacks().entry(stack);
        }
        this.entries = entries;
        this.children = Lists.newArrayList(this.renders);
        this.children.addAll(entries);
    }

    @ApiStatus.Internal
    public List<EntryStack<?>> getAllStacks() {
        return this.allStacks;
    }

    public void updateSearch(String searchTerm, boolean ignoreLastSearch) {
        EntryListSearchManager.INSTANCE.update(searchTerm, ignoreLastSearch, stacks -> {
            this.allStacks = stacks;
            this.updateEntriesPosition();
        });
        this.debugger.debugTime = ConfigObject.getInstance().doDebugRenderTimeRequired();
        FavoritesListWidget favorites = ScreenOverlayImpl.getFavoritesListWidget();
        if (favorites != null) {
            favorites.updateSearch();
        }
    }

    public List<? extends Widget> method_25396() {
        return this.children;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.hasSpace()) {
            return false;
        }
        if (ConfigObject.getInstance().isEntryListWidgetScrolled() && this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        for (Widget widget : this.method_25396()) {
            if (!widget.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.containsChecked(mouseX, mouseY, false)) {
            class_746 player = this.minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && !(class_310.method_1551().field_1755 instanceof DisplayScreen) && player != null && player.field_7512 != null && !player.field_7512.method_34255().method_7960() && ClientHelperImpl.getInstance().canDeleteItems()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            for (Widget widget : this.method_25396()) {
                if (!widget.method_25406(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public EntryStack<?> getFocusedStack() {
        Point mouse = EntryListWidget.mouse();
        if (this.containsChecked(mouse, false)) {
            for (EntryListStackEntry entry : this.entries) {
                EntryStack<?> currentEntry = entry.getCurrentEntry();
                if (currentEntry.isEmpty() || !entry.containsMouse(mouse)) continue;
                return currentEntry.copy();
            }
        }
        return EntryStack.empty();
    }

    @Override
    public Stream<EntryStack<?>> getEntries() {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int skip = Math.max(0, class_3532.method_15357((double)(this.scrolling.scrollAmount() / (double)EntryListWidget.entrySize())));
            int nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize();
            return this.entries.stream().skip(nextIndex).filter(entry -> entry.getBounds().y <= this.bounds.getMaxY()).map(EntryWidget::getCurrentEntry).filter((Predicate<EntryStack>)Predicates.not(EntryStack::isEmpty));
        }
        return this.entries.stream().map(EntryWidget::getCurrentEntry);
    }
}

