/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.screen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import dev.architectury.event.CompoundEventResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProvider;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitor;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitorWidget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.DisplayBoundsProvider;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.FocusedStackProvider;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.screen.SimpleClickArea;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.registry.screen.ExclusionZonesImpl;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1269;
import net.minecraft.class_1703;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class ScreenRegistryImpl
implements ScreenRegistry {
    private Multimap<Class<? extends class_437>, ClickArea<?>> clickAreas = HashMultimap.create();
    private List<DraggableComponentProvider<class_437, Object>> draggableProviders = new ArrayList<DraggableComponentProvider<class_437, Object>>();
    private List<DraggableComponentVisitor<class_437>> draggableVisitors = new ArrayList<DraggableComponentVisitor<class_437>>();
    private List<FocusedStackProvider> focusedStackProviders = new ArrayList<FocusedStackProvider>();
    private List<OverlayDecider> deciders = new CopyOnWriteArrayList<OverlayDecider>();
    private Map<Class<?>, List<OverlayDecider>> cache = new HashMap();
    private ExclusionZones exclusionZones = new ExclusionZonesImpl();
    private Class<? extends class_437> tmpScreen;

    @Override
    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerScreens(this);
        plugin.registerExclusionZones(this.exclusionZones());
    }

    @Override
    public <R extends class_437> List<OverlayDecider> getDeciders(R screen) {
        if (screen == null) {
            return Collections.emptyList();
        }
        Class<?> screenClass = screen.getClass();
        List<OverlayDecider> possibleCached = this.cache.get(screenClass);
        if (possibleCached != null) {
            return possibleCached;
        }
        this.tmpScreen = screenClass;
        List<OverlayDecider> deciders = CollectionUtils.filterToList(this.deciders, this::filterResponsible);
        this.cache.put(screenClass, deciders);
        this.tmpScreen = null;
        return deciders;
    }

    private boolean filterResponsible(OverlayDecider handler) {
        return handler.isHandingScreen(this.tmpScreen);
    }

    @Override
    public List<OverlayDecider> getDeciders() {
        return Collections.unmodifiableList(this.deciders);
    }

    @Override
    public <T extends class_437> Rectangle getScreenBounds(T screen) {
        for (OverlayDecider decider : this.getDeciders(screen)) {
            Rectangle bounds;
            if (!(decider instanceof DisplayBoundsProvider) || (bounds = ((DisplayBoundsProvider)decider).getScreenBounds(screen)) == null) continue;
            return bounds;
        }
        return new Rectangle();
    }

    @Override
    public <T extends class_437> Rectangle getOverlayBounds(DisplayPanelLocation location, T screen) {
        class_1041 window = class_310.method_1551().method_22683();
        int scaledWidth = window.method_4486();
        int scaledHeight = window.method_4502();
        Rectangle screenBounds = this.getScreenBounds(screen);
        if (screenBounds.isEmpty()) {
            return new Rectangle();
        }
        if (location == DisplayPanelLocation.LEFT) {
            if (screenBounds.x < 10) {
                return new Rectangle();
            }
            return new Rectangle(2, 0, screenBounds.x - 2, scaledHeight);
        }
        if (scaledWidth - screenBounds.getMaxX() < 10) {
            return new Rectangle();
        }
        return new Rectangle(screenBounds.getMaxX() + 2, 0, scaledWidth - screenBounds.getMaxX() - 4, scaledHeight);
    }

    @Override
    @Nullable
    public <T extends class_437> EntryStack<?> getFocusedStack(T screen, Point mouse) {
        for (FocusedStackProvider provider : this.focusedStackProviders) {
            CompoundEventResult<EntryStack<?>> result = Objects.requireNonNull(provider.provide(screen, mouse));
            if (result.isTrue()) {
                if (result != null && !((EntryStack)result.object()).isEmpty()) {
                    return (EntryStack)result.object();
                }
                return null;
            }
            if (!result.isFalse()) continue;
            return null;
        }
        return null;
    }

    @Override
    public void registerDecider(OverlayDecider decider) {
        this.deciders.add(decider);
        this.deciders.sort(Comparator.reverseOrder());
        this.cache.clear();
        this.tmpScreen = null;
        this.registerDraggableComponentProvider(DraggableComponentProviderWidget.from(context -> Widgets.walk(context.getScreen().method_25396(), DraggableComponentProviderWidget.class::isInstance)));
        this.registerDraggableComponentVisitor(DraggableComponentVisitorWidget.from(context -> Widgets.walk(context.getScreen().method_25396(), DraggableComponentVisitorWidget.class::isInstance)));
    }

    @Override
    public void registerFocusedStack(FocusedStackProvider provider) {
        this.focusedStackProviders.add(provider);
        this.focusedStackProviders.sort(Comparator.reverseOrder());
    }

    @Override
    public <T extends class_437> void registerDraggableStackProvider(DraggableStackProvider<T> provider) {
        this.registerDraggableComponentProvider(provider);
    }

    @Override
    public <T extends class_437> void registerDraggableStackVisitor(DraggableStackVisitor<T> visitor) {
        this.registerDraggableComponentVisitor(visitor);
    }

    @Override
    public <T extends class_437, A> void registerDraggableComponentProvider(DraggableComponentProvider<T, A> provider) {
        this.draggableProviders.add(provider);
        this.draggableProviders.sort(Comparator.reverseOrder());
    }

    @Override
    public <T extends class_437> void registerDraggableComponentVisitor(DraggableComponentVisitor<T> visitor) {
        this.draggableVisitors.add(visitor);
        this.draggableVisitors.sort(Comparator.reverseOrder());
    }

    @Override
    public Iterable<DraggableStackProvider<class_437>> getDraggableProviders() {
        return Iterables.filter(Collections.unmodifiableList(this.draggableProviders), DraggableStackVisitor.class);
    }

    @Override
    public Iterable<DraggableStackVisitor<class_437>> getDraggableVisitors() {
        return Iterables.filter(Collections.unmodifiableList(this.draggableVisitors), DraggableStackVisitor.class);
    }

    @Override
    public Iterable<DraggableComponentProvider<class_437, Object>> getDraggableComponentProviders() {
        return Collections.unmodifiableList(this.draggableProviders);
    }

    @Override
    public Iterable<DraggableComponentVisitor<class_437>> getDraggableComponentVisitors() {
        return Collections.unmodifiableList(this.draggableVisitors);
    }

    @Override
    public ExclusionZones exclusionZones() {
        return this.exclusionZones;
    }

    @Override
    public <C extends class_1703, T extends class_465<C>> void registerContainerClickArea(SimpleClickArea<T> area, Class<? extends T> screenClass, CategoryIdentifier<?> ... categories) {
        this.registerClickArea(screen -> {
            Rectangle rectangle = area.provide(screen).clone();
            rectangle.translate(screen.field_2776, screen.field_2800);
            return rectangle;
        }, screenClass, categories);
    }

    @Override
    public <T extends class_437> void registerClickArea(Class<? extends T> screenClass, ClickArea<T> area) {
        this.clickAreas.put(screenClass, area);
    }

    @Override
    public <T extends class_437> List<ClickArea.Result> evaluateClickArea(Class<T> screenClass, ClickArea.ClickAreaContext<T> context) {
        ArrayList<ClickArea.Result> results = new ArrayList<ClickArea.Result>();
        for (ClickArea area : this.clickAreas.get(screenClass)) {
            ClickArea.Result result = area.handle(context);
            if (!result.isSuccessful()) continue;
            results.add(result);
        }
        return results;
    }

    @Override
    public void startReload() {
        this.clickAreas.clear();
        this.deciders.clear();
        this.cache.clear();
        this.focusedStackProviders.clear();
        this.draggableProviders.clear();
        this.draggableVisitors.clear();
        this.tmpScreen = null;
        this.registerDefault();
    }

    private void registerDefault() {
        this.exclusionZones = new ExclusionZonesImpl();
        this.registerDecider(this.exclusionZones);
        this.registerDecider(new DisplayBoundsProvider<class_465<?>>(){

            @Override
            public Rectangle getScreenBounds(class_465<?> screen) {
                return new Rectangle(screen.field_2776, screen.field_2800, screen.field_2792, screen.field_2779);
            }

            @Override
            public <R extends class_437> boolean isHandingScreen(Class<R> screen) {
                return class_465.class.isAssignableFrom(screen);
            }

            @Override
            public <R extends class_437> class_1269 shouldScreenBeOverlaid(R screen) {
                return screen instanceof class_465 ? class_1269.field_5812 : class_1269.field_5811;
            }

            @Override
            public double getPriority() {
                return -10.0;
            }
        });
        this.registerDecider(new DisplayBoundsProvider<AbstractDisplayViewingScreen>(){

            @Override
            public Rectangle getScreenBounds(AbstractDisplayViewingScreen screen) {
                return screen.getBounds();
            }

            @Override
            public <R extends class_437> boolean isHandingScreen(Class<R> screen) {
                return AbstractDisplayViewingScreen.class.isAssignableFrom(screen);
            }

            @Override
            public <R extends class_437> class_1269 shouldScreenBeOverlaid(R screen) {
                return class_1269.field_5812;
            }

            @Override
            public double getPriority() {
                return -10.0;
            }
        });
        this.registerFocusedStack(new FocusedStackProvider(){

            @Override
            public CompoundEventResult<EntryStack<?>> provide(class_437 screen, Point mouse) {
                if (screen instanceof class_465) {
                    class_465 containerScreen = (class_465)screen;
                    if (containerScreen.field_2787 != null && !containerScreen.field_2787.method_7677().method_7960()) {
                        return CompoundEventResult.interruptTrue(EntryStacks.of(containerScreen.field_2787.method_7677()));
                    }
                }
                return CompoundEventResult.pass();
            }

            @Override
            public double getPriority() {
                return -10.0;
            }
        });
    }
}

