/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.def.corehook;

import dev.quantumfusion.dashloader.core.DashLoaderCore;
import dev.quantumfusion.dashloader.core.progress.ProgressHandler;
import dev.quantumfusion.dashloader.core.progress.task.CountTask;
import dev.quantumfusion.dashloader.core.progress.task.Task;
import dev.quantumfusion.dashloader.core.registry.RegistryReader;
import dev.quantumfusion.dashloader.core.registry.RegistryWriter;
import dev.quantumfusion.dashloader.core.util.DashUtil;
import dev.quantumfusion.dashloader.def.DashAtlasManager;
import dev.quantumfusion.dashloader.def.DashDataManager;
import dev.quantumfusion.dashloader.def.DashLoader;
import dev.quantumfusion.dashloader.def.api.option.ConfigHandler;
import dev.quantumfusion.dashloader.def.api.option.Option;
import dev.quantumfusion.dashloader.def.corehook.holder.DashBlockStateData;
import dev.quantumfusion.dashloader.def.corehook.holder.DashFontManagerData;
import dev.quantumfusion.dashloader.def.corehook.holder.DashModelData;
import dev.quantumfusion.dashloader.def.corehook.holder.DashParticleData;
import dev.quantumfusion.dashloader.def.corehook.holder.DashShaderData;
import dev.quantumfusion.dashloader.def.corehook.holder.DashSplashTextData;
import dev.quantumfusion.dashloader.def.corehook.holder.DashSpriteAtlasData;
import dev.quantumfusion.hyphen.scan.annotations.Data;
import dev.quantumfusion.hyphen.scan.annotations.DataNullable;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1059;
import net.minecraft.class_4724;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

@Data
@DataNullable
public class MappingData {
    @Nullable
    public DashBlockStateData blockStateData;
    @Nullable
    public DashFontManagerData fontManagerData;
    @Nullable
    public DashModelData modelData;
    @Nullable
    public DashParticleData particleData;
    @Nullable
    public DashSplashTextData splashTextData;
    @Nullable
    public DashSpriteAtlasData spriteAtlasData;
    @Nullable
    public DashShaderData shaderData;

    public MappingData() {
    }

    public MappingData(DashBlockStateData blockStateData, DashFontManagerData fontManagerData, DashModelData modelData, DashParticleData particleData, DashSplashTextData splashTextData, DashSpriteAtlasData spriteAtlasData, DashShaderData shaderData) {
        this.blockStateData = blockStateData;
        this.fontManagerData = fontManagerData;
        this.modelData = modelData;
        this.particleData = particleData;
        this.splashTextData = splashTextData;
        this.spriteAtlasData = spriteAtlasData;
        this.shaderData = shaderData;
    }

    public void map(RegistryWriter registry, Task task) {
        if (DashLoader.isRead()) {
            throw new RuntimeException("Tried to map data when DashDataManager is in Read mode");
        }
        ProgressHandler progress = DashLoaderCore.PROGRESS;
        progress.setCurrentTask("convert");
        CountTask mapping = new CountTask(7);
        task.setSubtask((Task)mapping);
        DashDataManager dataManager = DashLoader.getData();
        if (ConfigHandler.optionActive(Option.CACHE_MODEL_LOADER)) {
            progress.setCurrentTask("convert.blockstate");
            mapping.completedTask();
            progress.setCurrentTask("convert.model");
            this.modelData = new DashModelData(dataManager, registry);
            mapping.completedTask();
            progress.setCurrentTask("convert.image");
            this.spriteAtlasData = new DashSpriteAtlasData(dataManager, registry);
            mapping.completedTask();
        }
        if (ConfigHandler.optionActive(Option.CACHE_PARTICLE)) {
            progress.setCurrentTask("convert.particle");
            this.particleData = new DashParticleData(dataManager, registry);
            mapping.completedTask();
        }
        if (ConfigHandler.optionActive(Option.CACHE_FONT)) {
            progress.setCurrentTask("convert.font");
            this.fontManagerData = new DashFontManagerData(dataManager, registry);
            mapping.completedTask();
        }
        if (ConfigHandler.optionActive(Option.CACHE_SPLASH_TEXT)) {
            progress.setCurrentTask("convert.splashtext");
            this.splashTextData = new DashSplashTextData(dataManager);
            mapping.completedTask();
        }
        if (ConfigHandler.optionActive(Option.CACHE_SHADER)) {
            progress.setCurrentTask("convert.shader");
            this.shaderData = new DashShaderData(dataManager);
            mapping.completedTask();
        }
    }

    public void export(RegistryReader registry, DashDataManager data) {
        Pair spriteData = (Pair)DashUtil.nullable((Object)this.spriteAtlasData, (Object)registry, DashSpriteAtlasData::export);
        Pair particleData = (Pair)DashUtil.nullable((Object)this.particleData, (Object)registry, DashParticleData::export);
        DashAtlasManager atlasManager = data.getReadContextData().dashAtlasManager;
        data.bakedModels.setCacheResultData((Map)DashUtil.nullable((Object)this.modelData, (Object)registry, DashModelData::export));
        data.fonts.setCacheResultData((Map)DashUtil.nullable((Object)this.fontManagerData, (Object)registry, DashFontManagerData::export));
        data.spriteAtlasManager.setCacheResultData((class_4724)DashUtil.nullable((Object)spriteData, Pair::getLeft));
        data.particleAtlas.setCacheResultData((class_1059)DashUtil.nullable((Object)particleData, Pair::getRight));
        data.particleSprites.setCacheResultData((Map)DashUtil.nullable((Object)particleData, Pair::getLeft));
        if (this.shaderData != null) {
            data.shaders.setCacheResultData((Map)DashUtil.nullable((Object)this.shaderData, DashShaderData::export));
            data.getReadContextData().shaderData.putAll(this.shaderData.shaders);
        }
        data.splashText.setCacheResultData((List)DashUtil.nullable((Object)this.splashTextData, DashSplashTextData::export));
        if (spriteData != null) {
            for (class_1059 atlas : (List)spriteData.getValue()) {
                atlasManager.addAtlas(Option.CACHE_MODEL_LOADER, atlas);
            }
        }
        if (particleData != null) {
            atlasManager.addAtlas(Option.CACHE_PARTICLE, (class_1059)particleData.getRight());
        }
        this.modelData = null;
        this.spriteAtlasData = null;
        this.blockStateData = null;
        this.fontManagerData = null;
        this.splashTextData = null;
    }
}

