/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.def.corehook.holder;

import dev.quantumfusion.dashloader.core.DashLoaderCore;
import dev.quantumfusion.dashloader.core.Dashable;
import dev.quantumfusion.dashloader.core.common.IntIntList;
import dev.quantumfusion.dashloader.core.progress.task.CountTask;
import dev.quantumfusion.dashloader.core.progress.task.Task;
import dev.quantumfusion.dashloader.core.registry.RegistryReader;
import dev.quantumfusion.dashloader.core.registry.RegistryWriter;
import dev.quantumfusion.dashloader.core.registry.chunk.write.AbstractWriteChunk;
import dev.quantumfusion.dashloader.def.DashDataManager;
import dev.quantumfusion.dashloader.def.DashLoader;
import dev.quantumfusion.dashloader.def.data.DashIdentifierInterface;
import dev.quantumfusion.dashloader.def.data.model.DashModel;
import dev.quantumfusion.dashloader.def.fallback.model.DashMissingDashModel;
import dev.quantumfusion.hyphen.scan.annotations.Data;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_773;

@Data
public class DashModelData
implements Dashable<Map<class_2960, class_1087>> {
    public final IntIntList models;

    public DashModelData(IntIntList models) {
        this.models = models;
    }

    public DashModelData(DashDataManager data, RegistryWriter writer) {
        DashDataManager.DashWriteContextData writeContextData = data.getWriteContextData();
        Object2ObjectMap<class_1087, DashMissingDashModel> missingModelsWrite = writeContextData.missingModelsWrite;
        Map<class_2960, class_1087> models = data.bakedModels.getMinecraftData();
        this.models = new IntIntList(new ArrayList(models.size()));
        CountTask task = new CountTask(models.size());
        DashLoaderCore.PROGRESS.getCurrentContext().setSubtask((Task)task);
        AbstractWriteChunk modelChunk = writer.getChunk(DashModel.class);
        AbstractWriteChunk identifierChunk = writer.getChunk(DashIdentifierInterface.class);
        models.forEach((identifier, bakedModel) -> {
            if (bakedModel != null) {
                int add = writer.addDirect(modelChunk, bakedModel);
                if (!missingModelsWrite.containsKey(bakedModel)) {
                    this.models.put(writer.addDirect(identifierChunk, identifier), add);
                }
            }
            task.completedTask();
        });
    }

    public Map<class_2960, class_1087> export(RegistryReader reader) {
        HashMap<class_2960, class_1087> out = new HashMap<class_2960, class_1087>();
        this.models.forEach((key, value) -> out.put((class_2960)reader.get(key), (class_1087)reader.get(value)));
        Object2ObjectMap<class_2680, class_2960> missingModelsRead = DashLoader.getData().getReadContextData().missingModelsRead;
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        DashLoader.LOGGER.info("Scanning Blocks");
        for (class_2248 block : class_2378.field_11146) {
            tasks.add(() -> block.method_9595().method_11662().forEach(blockState -> {
                class_1091 modelId = class_773.method_3340((class_2680)blockState);
                if (!out.containsKey(modelId)) {
                    missingModelsRead.put(blockState, (Object)modelId);
                }
            }));
        }
        DashLoader.LOGGER.info("Verifying {} BlockStates", (Object)tasks.size());
        DashLoaderCore.THREAD.parallelRunnable(tasks);
        DashLoader.LOGGER.info("Found {} Missing BlockState Models", (Object)missingModelsRead.size());
        return out;
    }
}

