/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.def.data.model;

import dev.quantumfusion.dashloader.core.api.DashDependencies;
import dev.quantumfusion.dashloader.core.api.DashObject;
import dev.quantumfusion.dashloader.core.common.ObjectObjectList;
import dev.quantumfusion.dashloader.core.registry.RegistryReader;
import dev.quantumfusion.dashloader.core.registry.RegistryWriter;
import dev.quantumfusion.dashloader.def.data.image.DashSprite;
import dev.quantumfusion.dashloader.def.data.model.DashModel;
import dev.quantumfusion.dashloader.def.data.model.components.DashBakedQuad;
import dev.quantumfusion.dashloader.def.data.model.components.DashModelOverrideList;
import dev.quantumfusion.dashloader.def.data.model.components.DashModelTransformation;
import dev.quantumfusion.dashloader.def.mixin.accessor.BasicBakedModelAccessor;
import dev.quantumfusion.hyphen.scan.annotations.Data;
import dev.quantumfusion.hyphen.scan.annotations.DataNullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1093;
import net.minecraft.class_2350;
import net.minecraft.class_777;

@Data
@DashObject(value=class_1093.class)
@DashDependencies(value={DashSprite.class, DashBakedQuad.class})
public final class DashBasicBakedModel
implements DashModel {
    public final List<Integer> quads;
    public final ObjectObjectList<class_2350, List<Integer>> faceQuads;
    public final boolean usesAo;
    public final boolean hasDepth;
    public final boolean isSideLit;
    @DataNullable
    public final DashModelTransformation transformation;
    public final DashModelOverrideList itemPropertyOverrides;
    public final int spritePointer;

    public DashBasicBakedModel(List<Integer> quads, ObjectObjectList<class_2350, List<Integer>> faceQuads, boolean usesAo, boolean hasDepth, boolean isSideLit, DashModelTransformation transformation, DashModelOverrideList itemPropertyOverrides, int spritePointer) {
        this.quads = quads;
        this.faceQuads = faceQuads;
        this.usesAo = usesAo;
        this.hasDepth = hasDepth;
        this.isSideLit = isSideLit;
        this.transformation = transformation;
        this.itemPropertyOverrides = itemPropertyOverrides;
        this.spritePointer = spritePointer;
    }

    public DashBasicBakedModel(class_1093 basicBakedModel, RegistryWriter writer) {
        BasicBakedModelAccessor access = (BasicBakedModelAccessor)basicBakedModel;
        this.quads = new ArrayList<Integer>();
        for (class_777 quad : access.getQuads()) {
            this.quads.add(writer.add((Object)quad));
        }
        this.faceQuads = new ObjectObjectList();
        access.getFaceQuads().forEach((direction, bakedQuads) -> {
            ArrayList<Integer> bakedQuadsOut = new ArrayList<Integer>();
            for (class_777 bakedQuad : bakedQuads) {
                bakedQuadsOut.add(writer.add((Object)bakedQuad));
            }
            this.faceQuads.put(direction, bakedQuadsOut);
        });
        this.itemPropertyOverrides = new DashModelOverrideList(access.getItemPropertyOverrides(), writer);
        this.usesAo = access.getUsesAo();
        this.hasDepth = access.getHasDepth();
        this.isSideLit = access.getIsSideLit();
        this.transformation = DashModelTransformation.createDashOrReturnNullIfDefault(access.getTransformation());
        this.spritePointer = writer.add((Object)access.getSprite());
    }

    public class_1093 export(RegistryReader reader) {
        class_1058 sprite = (class_1058)reader.get(this.spritePointer);
        ArrayList<class_777> quadsOut = new ArrayList<class_777>();
        for (Integer quad : this.quads) {
            quadsOut.add((class_777)reader.get(quad.intValue()));
        }
        HashMap faceQuadsOut = new HashMap();
        for (ObjectObjectList.ObjectObjectEntry entry : this.faceQuads.list()) {
            ArrayList<class_777> out = new ArrayList<class_777>();
            for (Integer integer : (List)entry.value()) {
                out.add((class_777)reader.get(integer.intValue()));
            }
            faceQuadsOut.put((class_2350)entry.key(), out);
        }
        return new class_1093(quadsOut, faceQuadsOut, this.usesAo, this.isSideLit, this.hasDepth, sprite, DashModelTransformation.exportOrDefault(this.transformation), this.itemPropertyOverrides.export(reader));
    }

    public void postExport(RegistryReader reader) {
        this.itemPropertyOverrides.applyOverrides(reader);
    }
}

