/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.def.mixin.option.cache.font;

import com.google.common.collect.Lists;
import dev.quantumfusion.dashloader.def.DashDataManager;
import dev.quantumfusion.dashloader.def.DashLoader;
import dev.quantumfusion.dashloader.def.mixin.accessor.FontManagerAccessor;
import dev.quantumfusion.dashloader.def.mixin.accessor.FontStorageAccessor;
import dev.quantumfusion.dashloader.def.mixin.accessor.UnicodeTextureFontAccessor;
import dev.quantumfusion.dashloader.def.util.mixins.MixinThings;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_377;
import net.minecraft.class_378;
import net.minecraft.class_379;
import net.minecraft.class_383;
import net.minecraft.class_385;
import net.minecraft.class_390;
import net.minecraft.class_391;
import net.minecraft.class_4591;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net/minecraft/client/font/FontManager$1"})
public class FontManagerOverride {
    @Inject(method={"method_18638", "prepare*"}, at={@At(value="HEAD")}, cancellable=true)
    private void overridePrepare(class_3300 resourceManager, class_3695 profiler, CallbackInfoReturnable<Map<class_2960, List<class_390>>> cir) {
        DashDataManager.DashDataHandler<Map<class_2960, List<class_390>>> fonts = DashLoader.getData().fonts;
        if (fonts.dataAvailable() && DashLoader.isRead()) {
            Map<class_2960, List<class_390>> cacheResultData = fonts.getCacheResultData();
            cacheResultData.forEach((identifier, list) -> list.forEach(font -> {
                if (font instanceof class_391) {
                    ((UnicodeTextureFontAccessor)font).setResourceManager(resourceManager);
                }
            }));
            cir.setReturnValue(cacheResultData);
        }
    }

    @Inject(method={"method_18635", "apply*"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideApply(Map<class_2960, List<class_390>> map, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        DashDataManager.DashDataHandler<Map<class_2960, List<class_390>>> fonts = DashLoader.getData().fonts;
        if (fonts.dataAvailable() && DashLoader.isRead()) {
            profiler.method_16065();
            profiler.method_15396("closing");
            FontManagerAccessor fontManagerAccessor = (FontManagerAccessor)MixinThings.FONTMANAGER;
            fontManagerAccessor.getFontStorages().values().forEach(class_377::close);
            fontManagerAccessor.getFontStorages().clear();
            profiler.method_15405("reloading");
            LinkedHashMap fontMap = new LinkedHashMap();
            map.forEach((identifier, fontList) -> {
                class_377 fontStorage = new class_377(fontManagerAccessor.getTextureManager(), identifier);
                this.prepareFontStorage((FontStorageAccessor)fontStorage);
                fontManagerAccessor.getFontStorages().put((class_2960)identifier, fontStorage);
                fontMap.put(fontStorage, fontList);
            });
            fontMap.entrySet().parallelStream().forEach(entry -> this.computeFontStorages((FontStorageAccessor)entry.getKey(), Lists.reverse((List)((List)entry.getValue()))));
            profiler.method_15407();
            profiler.method_16066();
            ci.cancel();
        }
    }

    @Inject(method={"method_18635", "apply*"}, at={@At(value="TAIL")})
    private void applyInject(Map<class_2960, List<class_390>> map, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        if (DashLoader.isWrite()) {
            DashLoader.getData().fonts.setMinecraftData(map);
        }
    }

    private void prepareFontStorage(FontStorageAccessor access) {
        access.callCloseFonts();
        access.callCloseGlyphAtlases();
        access.getGlyphRendererCache().clear();
        access.getGlyphCache().clear();
        access.getCharactersByWidth().clear();
        access.setBlankGlyphRenderer(access.callGetGlyphRenderer((class_383)class_385.field_2283));
        access.setWhiteRectangleGlyphRenderer(access.callGetGlyphRenderer((class_383)class_4591.field_20912));
    }

    private void computeFontStorages(FontStorageAccessor access, List<class_390> fonts) {
        class_379 space = FontStorageAccessor.getSPACE();
        IntOpenHashSet intSet = new IntOpenHashSet();
        IntFunction<IntList> creatIntArrayListFunc = i -> new IntArrayList();
        fonts.forEach(arg_0 -> FontManagerOverride.lambda$computeFontStorages$5((IntSet)intSet, arg_0));
        HashSet set = new HashSet();
        intSet.forEach(codePoint -> {
            for (class_390 font : fonts) {
                Object glyph = codePoint == 32 ? space : font.method_2040(codePoint);
                if (glyph == null) continue;
                set.add(font);
                if (glyph == class_385.field_2283) break;
                ((IntList)access.getCharactersByWidth().computeIfAbsent(class_3532.method_15386((float)glyph.method_16798(false)), creatIntArrayListFunc)).add(codePoint);
                break;
            }
        });
        fonts.stream().filter(set::contains).forEach(access.getFonts()::add);
    }

    private static /* synthetic */ void lambda$computeFontStorages$5(IntSet intSet, class_390 font) {
        intSet.addAll((IntCollection)font.method_27442());
    }

    @Mixin(value={class_378.class})
    private static class LeoFontSolution {
        private LeoFontSolution() {
        }

        @Inject(method={"<init>"}, at={@At(value="TAIL")})
        private void initInject(class_1060 manager, CallbackInfo ci) {
            MixinThings.FONTMANAGER = (class_378)this;
        }
    }
}

