/*
 * Decompiled with CFR 0.152.
 */
package xyz.deathsgun.modmanager.api.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0004\u0018\u00010\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0013"}, d2={"Lxyz/deathsgun/modmanager/api/http/HttpClient;", "", "()V", "download", "", "url", "", "path", "Ljava/nio/file/Path;", "listener", "Lkotlin/Function1;", "", "get", "", "uri", "Ljava/net/URI;", "getInputStream", "Ljava/io/InputStream;", "InvalidStatusCodeException", "modmanager"})
public final class HttpClient {
    @NotNull
    public static final HttpClient INSTANCE = new HttpClient();

    private HttpClient() {
    }

    @NotNull
    public final byte[] get(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URI uRI = URI.create(url);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(url)");
        return this.get(uRI);
    }

    @NotNull
    public final byte[] get(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        URLConnection uRLConnection = uri.toURL().openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setReadTimeout(10000);
        connection.setRequestMethod("GET");
        connection.connect();
        if (connection.getResponseCode() != 200) {
            connection.disconnect();
            throw new InvalidStatusCodeException(connection.getResponseCode());
        }
        InputStream inputStream = connection.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.inputStream");
        byte[] content = ByteStreamsKt.readBytes((InputStream)inputStream);
        connection.disconnect();
        return content;
    }

    @NotNull
    public final InputStream getInputStream(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URI uRI = URI.create(url);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(url)");
        return this.getInputStream(uRI);
    }

    private final InputStream getInputStream(URI uri) {
        return new ByteArrayInputStream(this.get(uri));
    }

    public final void download(@NotNull String url, @NotNull Path path, @Nullable Function1<? super Double, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        OutputStream output = Files.newOutputStream(path, new OpenOption[0]);
        URLConnection uRLConnection = new URL(url).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setReadTimeout(10000);
        connection.setRequestMethod("GET");
        connection.connect();
        if (connection.getResponseCode() != 200) {
            connection.disconnect();
            throw new InvalidStatusCodeException(connection.getResponseCode());
        }
        int size = connection.getContentLength();
        int downloaded = 0;
        while (true) {
            int n = 1024;
            int n2 = size - downloaded;
            boolean bl = false;
            byte[] buffer = new byte[Math.min(n, n2)];
            int read = connection.getInputStream().read(buffer);
            if (read == -1) break;
            output.write(buffer, 0, read);
            downloaded += read;
            Function1<? super Double, Unit> function1 = listener;
            if (function1 == null) continue;
            function1.invoke((Object)(downloaded / size));
        }
        connection.disconnect();
        output.flush();
        output.close();
    }

    public static /* synthetic */ void download$default(HttpClient httpClient, String string, Path path, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        httpClient.download(string, path, (Function1<? super Double, Unit>)function1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lxyz/deathsgun/modmanager/api/http/HttpClient$InvalidStatusCodeException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "statusCode", "", "(I)V", "getStatusCode", "()I", "modmanager"})
    public static final class InvalidStatusCodeException
    extends Exception {
        private final int statusCode;

        public InvalidStatusCodeException(int statusCode) {
            super("Received invalid status code: " + statusCode);
            this.statusCode = statusCode;
        }

        public final int getStatusCode() {
            return this.statusCode;
        }
    }
}

