/*
 * Decompiled with CFR 0.152.
 */
package xyz.deathsgun.modmanager.providers.modrinth;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import net.minecraft.class_2588;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import xyz.deathsgun.modmanager.ModManager;
import xyz.deathsgun.modmanager.api.http.CategoriesResult;
import xyz.deathsgun.modmanager.api.http.ModResult;
import xyz.deathsgun.modmanager.api.http.ModsResult;
import xyz.deathsgun.modmanager.api.http.VersionResult;
import xyz.deathsgun.modmanager.api.mod.Asset;
import xyz.deathsgun.modmanager.api.mod.Category;
import xyz.deathsgun.modmanager.api.mod.Mod;
import xyz.deathsgun.modmanager.api.mod.Version;
import xyz.deathsgun.modmanager.api.mod.VersionType;
import xyz.deathsgun.modmanager.api.provider.IModProvider;
import xyz.deathsgun.modmanager.api.provider.IModUpdateProvider;
import xyz.deathsgun.modmanager.api.provider.Sorting;
import xyz.deathsgun.modmanager.providers.modrinth.Modrinth;
import xyz.deathsgun.modmanager.providers.modrinth.models.DetailedMod;
import xyz.deathsgun.modmanager.providers.modrinth.models.ModrinthVersion;
import xyz.deathsgun.modmanager.providers.modrinth.models.SearchResult;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0011\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J.\u0010\u0018\u001a\u00020\u00192\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\u0005H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J6\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lxyz/deathsgun/modmanager/providers/modrinth/Modrinth;", "Lxyz/deathsgun/modmanager/api/provider/IModProvider;", "Lxyz/deathsgun/modmanager/api/provider/IModUpdateProvider;", "()V", "baseUri", "", "categories", "Ljava/util/ArrayList;", "Lxyz/deathsgun/modmanager/api/mod/Category;", "Lkotlin/collections/ArrayList;", "http", "Ljava/net/http/HttpClient;", "kotlin.jvm.PlatformType", "json", "Lkotlinx/serialization/json/Json;", "logger", "Lorg/apache/logging/log4j/Logger;", "filterFromCategories", "", "getCategories", "Lxyz/deathsgun/modmanager/api/http/CategoriesResult;", "getMod", "Lxyz/deathsgun/modmanager/api/http/ModResult;", "id", "getMods", "Lxyz/deathsgun/modmanager/api/http/ModsResult;", "sorting", "Lxyz/deathsgun/modmanager/api/provider/Sorting;", "page", "", "limit", "builder", "Lorg/apache/http/client/utils/URIBuilder;", "getName", "getVersionType", "Lxyz/deathsgun/modmanager/api/mod/VersionType;", "getVersionsForMod", "Lxyz/deathsgun/modmanager/api/http/VersionResult;", "search", "query", "modmanager"})
public final class Modrinth
implements IModProvider,
IModUpdateProvider {
    private final Logger logger = LogManager.getLogger((String)"Modrinth");
    @NotNull
    private final ArrayList<Category> categories = new ArrayList();
    @NotNull
    private final String baseUri;
    private final HttpClient http = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
    @NotNull
    private final Json json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);

    public Modrinth() {
        this.baseUri = "https://api.modrinth.com";
    }

    @Override
    @NotNull
    public String getName() {
        return "Modrinth";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CategoriesResult getCategories() {
        CategoriesResult categoriesResult;
        Collection collection = this.categories;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return new CategoriesResult.Success((List<Category>)this.categories);
        }
        HttpRequest request = HttpRequest.newBuilder().GET().setHeader("User-Agent", "ModManager " + ModManager.Companion.getVersion()).uri(URI.create(this.baseUri + "/api/v1/tag/category")).build();
        try {
            void $this$decodeFromString$iv;
            HttpResponse<String> response = this.http.send(request, HttpResponse.BodyHandlers.ofString());
            StringFormat stringFormat = (StringFormat)this.json;
            String string = response.body();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.body()");
            String string$iv = string;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class))));
            boolean $i$f$cast = false;
            List categories = (List)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv);
            for (String category : categories) {
                if (Intrinsics.areEqual((Object)category, (Object)"fabric")) continue;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "modmanager.category.%s";
                Object[] objectArray = new Object[]{category};
                boolean bl2 = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                this.categories.add(new Category(category, new class_2588(string3)));
            }
            categoriesResult = new CategoriesResult.Success((List<Category>)this.categories);
        }
        catch (Exception e) {
            this.logger.error("Error while getting categories: {}", (Object)e.getMessage());
            Object[] objectArray = new Object[]{e.getMessage()};
            categoriesResult = new CategoriesResult.Error(new class_2588("modmanager.error.failedToParse", objectArray), e);
        }
        return categoriesResult;
    }

    @Override
    @NotNull
    public ModsResult getMods(@NotNull Sorting sorting, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)((Object)sorting), (String)"sorting");
        URIBuilder builder = new URIBuilder(this.baseUri + "/api/v1/mod");
        builder.addParameter("filters", "categories=\"fabric\" AND NOT client_side=\"unsupported\"");
        return this.getMods(builder, sorting, page, limit);
    }

    @Override
    @NotNull
    public ModsResult getMods(@NotNull List<Category> categories, @NotNull Sorting sorting, int page, int limit) {
        ModsResult modsResult;
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Intrinsics.checkNotNullParameter((Object)((Object)sorting), (String)"sorting");
        URIBuilder builder = new URIBuilder(this.baseUri + "/api/v1/mod");
        builder.addParameter("filters", "categories=\"fabric\" AND NOT client_side=\"unsupported\"" + this.filterFromCategories(categories));
        try {
            modsResult = this.getMods(builder, sorting, page, limit);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            modsResult = new ModsResult.Error(new class_2588("modmanager.error.unknown", objectArray), e);
        }
        return modsResult;
    }

    @Override
    @NotNull
    public ModsResult search(@NotNull String query, @NotNull List<Category> categories, @NotNull Sorting sorting, int page, int limit) {
        ModsResult modsResult;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Intrinsics.checkNotNullParameter((Object)((Object)sorting), (String)"sorting");
        URIBuilder builder = new URIBuilder(this.baseUri + "/api/v1/mod");
        builder.addParameter("query", query);
        builder.addParameter("filters", "categories=\"fabric\" AND NOT client_side=\"unsupported\"" + this.filterFromCategories(categories));
        try {
            modsResult = this.getMods(builder, sorting, page, limit);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            modsResult = new ModsResult.Error(new class_2588("modmanager.error.unknown", objectArray), e);
        }
        return modsResult;
    }

    private final String filterFromCategories(List<Category> categories) {
        Object categoriesFilter = "";
        for (Category category : categories) {
            categoriesFilter = (String)categoriesFilter + "AND categories=\"" + category.getId() + "\"";
        }
        categoriesFilter = StringsKt.replaceFirst$default((String)categoriesFilter, (String)"AND ", (String)" AND (", (boolean)false, (int)4, null);
        Collection collection = categories;
        boolean bl = false;
        if (!collection.isEmpty()) {
            categoriesFilter = (String)categoriesFilter + ")";
        }
        return categoriesFilter;
    }

    /*
     * WARNING - void declaration
     */
    private final ModsResult getMods(URIBuilder builder, Sorting sorting, int page, int limit) {
        Object object = StringCompanionObject.INSTANCE;
        String string = "versions=\"%s\" OR versions=\"%s\"";
        Object object2 = new Object[]{ModManager.Companion.getMinecraftReleaseTarget(), ModManager.Companion.getMinecraftVersionId()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        builder.addParameter("version", string2);
        object = sorting.name();
        boolean bl2 = false;
        Object object3 = object;
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)object3).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        builder.addParameter("index", string3);
        builder.addParameter("offset", String.valueOf(page * limit));
        builder.addParameter("limit", String.valueOf(limit));
        HttpRequest request = HttpRequest.newBuilder().GET().setHeader("User-Agent", "ModManager " + ModManager.Companion.getVersion()).uri(builder.build()).build();
        HttpResponse<String> response = this.http.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            object2 = new Object[]{response.statusCode()};
            return new ModsResult.Error(new class_2588("modmanager.error.invalidStatus", object2), null, 2, null);
        }
        try {
            void $this$decodeFromString$iv;
            StringFormat stringFormat = (StringFormat)this.json;
            String string4 = response.body();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"response.body()");
            String string$iv = string4;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(SearchResult.class));
            boolean $i$f$cast = false;
            SearchResult result = (SearchResult)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv);
            object2 = new ModsResult.Success(result.toList());
        }
        catch (Exception e) {
            this.logger.error("Error while requesting mods {}", (Object)e.getMessage());
            Object[] objectArray = new Object[]{e.getMessage()};
            object2 = new ModsResult.Error(new class_2588("modmanager.error.failedToParse", objectArray), null, 2, null);
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ModResult getMod(@NotNull String id) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        StringsKt.replaceFirst$default((String)id, (String)"local-", (String)"", (boolean)false, (int)4, null);
        HttpRequest request = HttpRequest.newBuilder().GET().setHeader("User-Agent", "ModManager " + ModManager.Companion.getVersion()).uri(URI.create(this.baseUri + "/api/v1/mod/" + id)).build();
        try {
            object = this.http.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            this.logger.error("Error while getting mod {}", (Object)e.getMessage());
            Object[] objectArray = new Object[]{e.getMessage()};
            return new ModResult.Error(new class_2588("modmanager.error.network", objectArray), e);
        }
        Object[] response = object;
        if (response.statusCode() != 200) {
            object = new Object[]{response.statusCode()};
            return new ModResult.Error(new class_2588("modmanager.error.invalidStatus", object), null, 2, null);
        }
        try {
            void $this$decodeFromString$iv;
            StringFormat e = (StringFormat)this.json;
            Object t = response.body();
            Intrinsics.checkNotNullExpressionValue(t, (String)"response.body()");
            String string$iv = (String)t;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(DetailedMod.class));
            boolean $i$f$cast = false;
            DetailedMod result = (DetailedMod)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv);
            ArrayList<Category> categoriesList = new ArrayList<Category>();
            Iterable $this$forEach$iv = result.getCategories();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String categoryId = (String)element$iv;
                boolean bl = false;
                categoriesList.add(new Category(categoryId, new class_2588("modmanager.category." + categoryId)));
            }
            object = new ModResult.Success(new Mod(StringsKt.replaceFirst$default((String)result.getId(), (String)"local-", (String)"", (boolean)false, (int)4, null), result.getSlug(), null, result.getTitle(), result.getDescription(), result.getIconUrl(), result.getBody(), result.getLicense().getName(), (List<Category>)categoriesList));
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            object = new ModResult.Error(new class_2588("modmanager.error.failedToParse", objectArray), e);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public VersionResult getVersionsForMod(@NotNull String id) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        HttpRequest request = HttpRequest.newBuilder().GET().setHeader("User-Agent", "ModManager " + ModManager.Companion.getVersion()).uri(URI.create(this.baseUri + "/api/v1/mod/" + id + "/version")).build();
        try {
            object = this.http.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            this.logger.error("Error while getting mod {}", (Object)e.getMessage());
            Object[] objectArray = new Object[]{e.getMessage()};
            return new VersionResult.Error(new class_2588("modmanager.error.network", objectArray), e);
        }
        Object[] response = object;
        if (response.statusCode() != 200) {
            object = new Object[]{response.statusCode()};
            return new VersionResult.Error(new class_2588("modmanager.error.invalidStatus", object), null, 2, null);
        }
        try {
            void $this$decodeFromString$iv;
            StringFormat e = (StringFormat)this.json;
            Object t = response.body();
            Intrinsics.checkNotNullExpressionValue(t, (String)"response.body()");
            String string$iv = (String)t;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(ModrinthVersion.class))));
            boolean $i$f$cast = false;
            List modrinthVersions = (List)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv);
            ArrayList<Version> versions = new ArrayList<Version>();
            for (ModrinthVersion modVersion : modrinthVersions) {
                if (!modVersion.getLoaders().contains("fabric")) continue;
                ArrayList<Asset> assets = new ArrayList<Asset>();
                for (ModrinthVersion.File file : modVersion.getFiles()) {
                    assets.add(new Asset(file.getUrl(), file.getFilename(), file.getHashes(), file.getPrimary()));
                }
                String string = modVersion.getVersion();
                String string2 = modVersion.getChangelog();
                LocalDate localDate = Instant.parse(modVersion.getReleaseDate()).atOffset(ZoneOffset.UTC).toLocalDate();
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(modVersion.release\u2026          ).toLocalDate()");
                versions.add(new Version(string, string2, localDate, this.getVersionType(modVersion.getType()), modVersion.getGameVersions(), (List<Asset>)assets));
            }
            object = new VersionResult.Success((List<Version>)versions);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            object = new VersionResult.Error(new class_2588("modmanager.error.failedToParse", objectArray), e);
        }
        return object;
    }

    private final VersionType getVersionType(String id) {
        return switch (id) {
            case "release" -> VersionType.RELEASE;
            case "alpha" -> VersionType.ALPHA;
            case "beta" -> VersionType.BETA;
            default -> VersionType.UNKNOWN;
        };
    }
}

