/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.movement;

import com.google.common.collect.AbstractIterator;
import me.jellysquid.mods.lithium.common.block.BlockCountingSection;
import me.jellysquid.mods.lithium.common.block.BlockStateFlags;
import me.jellysquid.mods.lithium.common.shapes.VoxelShapeCaster;
import me.jellysquid.mods.lithium.common.util.Pos;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_5539;

public class ChunkAwareBlockCollisionSweeper
extends AbstractIterator<class_265> {
    private final class_2338.class_2339 pos = new class_2338.class_2339();
    private final class_238 box;
    private final class_265 shape;
    private final class_1941 view;
    private final class_3726 context;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private int chunkX;
    private int chunkYIndex;
    private int chunkZ;
    private int cStartX;
    private int cStartZ;
    private int cEndX;
    private int cEndZ;
    private int cX;
    private int cY;
    private int cZ;
    private int cTotalSize;
    private int cIterated;
    private boolean sectionOversizedBlocks;
    private class_2791 cachedChunk;
    private class_2826 cachedChunkSection;

    public ChunkAwareBlockCollisionSweeper(class_1941 view, class_1297 entity, class_238 box) {
        this.box = box;
        this.shape = class_259.method_1078((class_238)box);
        this.context = entity == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)entity);
        this.view = view;
        this.minX = class_3532.method_15357((double)(box.field_1323 - 1.0E-7));
        this.maxX = class_3532.method_15357((double)(box.field_1320 + 1.0E-7));
        this.minY = class_3532.method_15340((int)class_3532.method_15357((double)(box.field_1322 - 1.0E-7)), (int)Pos.BlockCoord.getMinY((class_5539)this.view), (int)Pos.BlockCoord.getMaxYInclusive((class_5539)this.view));
        this.maxY = class_3532.method_15340((int)class_3532.method_15357((double)(box.field_1325 + 1.0E-7)), (int)Pos.BlockCoord.getMinY((class_5539)this.view), (int)Pos.BlockCoord.getMaxYInclusive((class_5539)this.view));
        this.minZ = class_3532.method_15357((double)(box.field_1321 - 1.0E-7));
        this.maxZ = class_3532.method_15357((double)(box.field_1324 + 1.0E-7));
        this.chunkX = Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMin(this.minX));
        this.chunkZ = Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMin(this.minZ));
        this.cIterated = 0;
        this.cTotalSize = 0;
        --this.chunkX;
    }

    private boolean nextSection() {
        while (true) {
            if (this.cachedChunk != null && this.chunkYIndex < Pos.SectionYIndex.getMaxYSectionIndexInclusive((class_5539)this.view) && this.chunkYIndex < Pos.SectionYIndex.fromBlockCoord((class_5539)this.view, ChunkAwareBlockCollisionSweeper.expandMax(this.maxY))) {
                ++this.chunkYIndex;
                this.cachedChunkSection = this.cachedChunk.method_12006()[this.chunkYIndex];
            } else {
                this.chunkYIndex = class_3532.method_15340((int)Pos.SectionYIndex.fromBlockCoord((class_5539)this.view, ChunkAwareBlockCollisionSweeper.expandMin(this.minY)), (int)Pos.SectionYIndex.getMinYSectionIndex((class_5539)this.view), (int)Pos.SectionYIndex.getMaxYSectionIndexInclusive((class_5539)this.view));
                if (this.chunkX < Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMax(this.maxX))) {
                    ++this.chunkX;
                } else {
                    this.chunkX = Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMin(this.minX));
                    if (this.chunkZ < Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMax(this.maxZ))) {
                        ++this.chunkZ;
                    } else {
                        return false;
                    }
                }
                this.cachedChunk = (class_2791)this.view.method_22338(this.chunkX, this.chunkZ);
                if (this.cachedChunk != null) {
                    this.cachedChunkSection = this.cachedChunk.method_12006()[this.chunkYIndex];
                }
            }
            if (this.cachedChunk == null || this.cachedChunkSection == null || this.cachedChunkSection.method_38292()) continue;
            this.sectionOversizedBlocks = ChunkAwareBlockCollisionSweeper.hasChunkSectionOversizedBlocks(this.cachedChunk, this.chunkYIndex);
            int sizeExtension = this.sectionOversizedBlocks ? 1 : 0;
            this.cEndX = Math.min(this.maxX + sizeExtension, Pos.BlockCoord.getMaxInSectionCoord(this.chunkX));
            int cEndY = Math.min(this.maxY + sizeExtension, Pos.BlockCoord.getMaxYInSectionIndex((class_5539)this.view, this.chunkYIndex));
            this.cEndZ = Math.min(this.maxZ + sizeExtension, Pos.BlockCoord.getMaxInSectionCoord(this.chunkZ));
            this.cStartX = Math.max(this.minX - sizeExtension, Pos.BlockCoord.getMinInSectionCoord(this.chunkX));
            int cStartY = Math.max(this.minY - sizeExtension, Pos.BlockCoord.getMinYInSectionIndex((class_5539)this.view, this.chunkYIndex));
            this.cStartZ = Math.max(this.minZ - sizeExtension, Pos.BlockCoord.getMinInSectionCoord(this.chunkZ));
            this.cX = this.cStartX;
            this.cY = cStartY;
            this.cZ = this.cStartZ;
            this.cTotalSize = (this.cEndX - this.cStartX + 1) * (cEndY - cStartY + 1) * (this.cEndZ - this.cStartZ + 1);
            if (this.cTotalSize != 0) break;
        }
        this.cIterated = 0;
        return true;
    }

    public class_265 computeNext() {
        while (this.cIterated < this.cTotalSize || this.nextSection()) {
            class_265 collidedShape;
            class_2680 state;
            int edgesHit;
            ++this.cIterated;
            int x = this.cX;
            int y = this.cY++;
            int z = this.cZ;
            if (this.cX < this.cEndX) {
                ++this.cX;
            } else if (this.cZ < this.cEndZ) {
                this.cX = this.cStartX;
                ++this.cZ;
            } else {
                this.cX = this.cStartX;
                this.cZ = this.cStartZ;
            }
            if ((edgesHit = this.sectionOversizedBlocks ? (x < this.minX || x > this.maxX ? 1 : 0) + (y < this.minY || y > this.maxY ? 1 : 0) + (z < this.minZ || z > this.maxZ ? 1 : 0) : 0) == 3 || !ChunkAwareBlockCollisionSweeper.canInteractWithBlock(state = this.cachedChunkSection.method_12254(x & 0xF, y & 0xF, z & 0xF), edgesHit)) continue;
            this.pos.method_10103(x, y, z);
            class_265 collisionShape = state.method_26194((class_1922)this.view, (class_2338)this.pos, this.context);
            if (collisionShape == class_259.method_1073() || (collidedShape = ChunkAwareBlockCollisionSweeper.getCollidedShape(this.box, this.shape, collisionShape, x, y, z)) == null) continue;
            return collidedShape;
        }
        return (class_265)this.endOfData();
    }

    private static boolean canInteractWithBlock(class_2680 state, int edgesHit) {
        return !(edgesHit == 1 && !state.method_26209() || edgesHit == 2 && state.method_26204() != class_2246.field_10008);
    }

    private static class_265 getCollidedShape(class_238 entityBox, class_265 entityShape, class_265 shape, int x, int y, int z) {
        if (shape == class_259.method_1077()) {
            return entityBox.method_1003((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0) ? shape.method_1096((double)x, (double)y, (double)z) : null;
        }
        if (shape instanceof VoxelShapeCaster) {
            if (((VoxelShapeCaster)shape).intersects(entityBox, x, y, z)) {
                return shape.method_1096((double)x, (double)y, (double)z);
            }
            return null;
        }
        if (class_259.method_1074((class_265)(shape = shape.method_1096((double)x, (double)y, (double)z)), (class_265)entityShape, (class_247)class_247.field_16896)) {
            return shape;
        }
        return null;
    }

    private static int expandMin(int coord) {
        return coord - 1;
    }

    private static int expandMax(int coord) {
        return coord + 1;
    }

    private static boolean hasChunkSectionOversizedBlocks(class_2791 chunk, int chunkY) {
        if (BlockStateFlags.ENABLED) {
            class_2826 section = chunk.method_12006()[chunkY];
            return section != null && ((BlockCountingSection)section).anyMatch(BlockStateFlags.OVERSIZED_SHAPE);
        }
        return true;
    }
}

