/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Function3;
import dev.emi.trinkets.TrinketsNetwork;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.data.EntitySlotLoader;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistryV3;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class TrinketsApi {
    public static final ComponentKey<TrinketComponent> TRINKET_COMPONENT = ComponentRegistryV3.INSTANCE.getOrCreate(new class_2960("trinkets", "trinkets"), TrinketComponent.class);
    private static final Map<class_2960, Function3<class_1799, SlotReference, class_1309, TriState>> PREDICATES = new HashMap<class_2960, Function3<class_1799, SlotReference, class_1309, TriState>>();
    private static final Map<class_1792, Trinket> TRINKETS = new HashMap<class_1792, Trinket>();
    private static final Trinket DEFAULT_TRINKET;

    public static void registerTrinket(class_1792 item, Trinket trinket) {
        TRINKETS.put(item, trinket);
    }

    public static Trinket getTrinket(class_1792 item) {
        return TRINKETS.getOrDefault(item, DEFAULT_TRINKET);
    }

    public static Trinket getDefaultTrinket() {
        return DEFAULT_TRINKET;
    }

    public static Optional<TrinketComponent> getTrinketComponent(class_1309 livingEntity) {
        return TRINKET_COMPONENT.maybeGet((Object)livingEntity);
    }

    public static void onTrinketBroken(class_1799 stack, SlotReference ref, class_1309 entity) {
        if (!entity.field_6002.field_9236) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeInt(entity.method_5628());
            buf.method_10814(ref.inventory().getSlotType().getGroup() + "/" + ref.inventory().getSlotType().getName());
            buf.writeInt(ref.index());
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                ServerPlayNetworking.send((class_3222)player, (class_2960)TrinketsNetwork.BREAK, (class_2540)buf);
            }
            PlayerLookup.tracking((class_1297)entity).forEach(watcher -> ServerPlayNetworking.send((class_3222)watcher, (class_2960)TrinketsNetwork.BREAK, (class_2540)buf));
        }
    }

    public static Map<String, SlotGroup> getPlayerSlots() {
        return TrinketsApi.getEntitySlots(class_1299.field_6097);
    }

    public static Map<String, SlotGroup> getEntitySlots(class_1299<?> type) {
        return EntitySlotLoader.INSTANCE.getEntitySlots(type);
    }

    public static void registerTrinketPredicate(class_2960 id, Function3<class_1799, SlotReference, class_1309, TriState> predicate) {
        PREDICATES.put(id, predicate);
    }

    public static Optional<Function3<class_1799, SlotReference, class_1309, TriState>> getTrinketPredicate(class_2960 id) {
        return Optional.ofNullable(PREDICATES.get(id));
    }

    public static boolean evaluatePredicateSet(Set<class_2960> set, class_1799 stack, SlotReference ref, class_1309 entity) {
        TriState state = TriState.DEFAULT;
        for (class_2960 id : set) {
            Optional<Function3<class_1799, SlotReference, class_1309, TriState>> function = TrinketsApi.getTrinketPredicate(id);
            if (function.isPresent()) {
                state = (TriState)function.get().apply((Object)stack, (Object)ref, (Object)entity);
            }
            if (state == TriState.DEFAULT) continue;
            break;
        }
        return state.get();
    }

    static {
        TrinketsApi.registerTrinketPredicate(new class_2960("trinkets", "all"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> TriState.TRUE));
        TrinketsApi.registerTrinketPredicate(new class_2960("trinkets", "none"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> TriState.FALSE));
        class_6862 trinketsAll = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960("trinkets", "all"));
        TrinketsApi.registerTrinketPredicate(new class_2960("trinkets", "tag"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> {
            SlotType slot = ref.inventory().getSlotType();
            class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960("trinkets", slot.getGroup() + "/" + slot.getName()));
            if (stack.method_31573(tag) || stack.method_31573(trinketsAll)) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        }));
        TrinketsApi.registerTrinketPredicate(new class_2960("trinkets", "relevant"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> {
            Multimap<class_1320, class_1322> map = TrinketsApi.getTrinket(stack.method_7909()).getModifiers((class_1799)stack, (SlotReference)ref, (class_1309)entity, SlotAttributes.getUuid(ref));
            if (!map.isEmpty()) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        }));
        DEFAULT_TRINKET = new Trinket(){};
    }
}

