/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.api.event;

import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3803;
import net.minecraft.class_3914;

public class GrindstoneEvents {
    private static final Map<UUID, GrindstoneMenuInstance> SERVER_INSTANCES = new WeakHashMap<UUID, GrindstoneMenuInstance>();
    private static final Map<UUID, GrindstoneMenuInstance> CLIENT_INSTANCES = new WeakHashMap<UUID, GrindstoneMenuInstance>();
    public static Event<CalculateOutputInvoker> CALCULATE_OUTPUT = EventFactory.createArrayBacked(CalculateOutputInvoker.class, callbacks -> instance -> {
        for (CalculateOutputInvoker callback : callbacks) {
            boolean result = callback.invoke(instance);
            if (!result) continue;
            return true;
        }
        return false;
    });
    public static Event<CanPlaceInvoker> CAN_PLACE = EventFactory.createArrayBacked(CanPlaceInvoker.class, callbacks -> (container, stack) -> {
        for (CanPlaceInvoker callback : callbacks) {
            boolean result = callback.invoke(container, stack);
            if (!result) continue;
            return true;
        }
        return false;
    });
    public static Event<CanTakeInvoker> CAN_TAKE = EventFactory.createArrayBacked(CanTakeInvoker.class, callbacks -> (invoker, player) -> {
        for (CanTakeInvoker callback : callbacks) {
            class_1269 result = callback.invoke(invoker, player);
            if (result == class_1269.field_5811) continue;
            return result;
        }
        return class_1269.field_5811;
    });
    public static Event<OnTakeInvoker> ON_TAKE = EventFactory.createArrayBacked(OnTakeInvoker.class, callbacks -> (invoker, player, stack) -> {
        for (OnTakeInvoker callback : callbacks) {
            boolean result = callback.invoke(invoker, player, stack);
            if (!result) continue;
            return true;
        }
        return false;
    });

    public static GrindstoneMenuInstance create(class_3803 menu, class_1657 player, class_1661 inventory, class_1263 input, class_1263 output, class_3914 access) {
        GrindstoneMenuInstance instance = new GrindstoneMenuInstance(menu, player, inventory, input, output, access);
        GrindstoneEvents.putSidedInstance(player, instance);
        return instance;
    }

    public static void remove(class_1657 player) {
        GrindstoneEvents.removeSidedInstance(player);
    }

    @Nullable
    public static GrindstoneMenuInstance instance(@Nullable class_1657 player) {
        if (player == null) {
            return null;
        }
        return GrindstoneEvents.getSidedInstance(player);
    }

    @Nullable
    private static GrindstoneMenuInstance getSidedInstance(class_1657 player) {
        UUID uuid = player.method_5667();
        if (player.field_6002.field_9236 && CLIENT_INSTANCES.containsKey(uuid)) {
            return CLIENT_INSTANCES.get(uuid);
        }
        if (SERVER_INSTANCES.containsKey(uuid)) {
            return SERVER_INSTANCES.get(uuid);
        }
        return null;
    }

    private static void putSidedInstance(class_1657 player, GrindstoneMenuInstance instance) {
        UUID uuid = player.method_5667();
        if (player.field_6002.field_9236) {
            CLIENT_INSTANCES.put(uuid, instance);
        } else {
            SERVER_INSTANCES.put(uuid, instance);
        }
    }

    private static void removeSidedInstance(class_1657 player) {
        UUID uuid = player.method_5667();
        if (player.field_6002.field_9236) {
            CLIENT_INSTANCES.remove(uuid);
        } else {
            SERVER_INSTANCES.remove(uuid);
        }
    }

    public static class GrindstoneMenuInstance {
        public class_3803 menu;
        public class_1657 player;
        public class_1661 inventory;
        public class_1263 input;
        public class_1263 output;
        public class_3914 access;

        public GrindstoneMenuInstance(class_3803 menu, class_1657 player, class_1661 inventory, class_1263 input, class_1263 output, class_3914 access) {
            this.menu = menu;
            this.player = player;
            this.inventory = inventory;
            this.input = input;
            this.output = output;
            this.access = access;
        }
    }

    @FunctionalInterface
    public static interface OnTakeInvoker {
        public boolean invoke(GrindstoneMenuInstance var1, class_1657 var2, class_1799 var3);
    }

    @FunctionalInterface
    public static interface CanTakeInvoker {
        public class_1269 invoke(GrindstoneMenuInstance var1, class_1657 var2);
    }

    @FunctionalInterface
    public static interface CanPlaceInvoker {
        public boolean invoke(class_1263 var1, class_1799 var2);
    }

    @FunctionalInterface
    public static interface CalculateOutputInvoker {
        public boolean invoke(GrindstoneMenuInstance var1);
    }
}

