/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.helper;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5483;
import net.minecraft.class_6880;

public class BiomeHelper {
    public static Map<class_1959.class_1961, List<class_5321<class_1959>>> BIOME_CATEGORY_MAP = new HashMap<class_1959.class_1961, List<class_5321<class_1959>>>();

    public static class_1959 getBiome(class_3218 level, class_2338 pos) {
        return (class_1959)BiomeHelper.getBiomeHolder(level, pos).comp_349();
    }

    public static class_6880<class_1959> getBiomeHolder(class_3218 level, class_2338 pos) {
        return level.method_22385().method_22393(pos);
    }

    @Nullable
    public static class_1959 getBiomeFromBiomeKey(class_5321<class_1959> biomeKey) {
        return class_5458.field_25933.method_31189(biomeKey).orElse(null);
    }

    public static class_6880<class_1959> getBiomeHolderFromBiomeKey(class_5321<class_1959> biomeKey) {
        return class_5458.field_25933.method_40268(biomeKey);
    }

    @Nullable
    public static class_5321<class_1959> getBiomeKeyFromBiome(class_1959 biome) {
        return class_5458.field_25933.method_29113((Object)biome).orElse(null);
    }

    @Nullable
    public static class_1959.class_1961 getBiomeCategoryByName(String name) {
        List<String> validCategories = Arrays.stream(class_1959.class_1961.values()).map(class_1959.class_1961::method_15434).toList();
        if (validCategories.contains(name)) {
            return class_1959.class_1961.method_28424((String)name);
        }
        return null;
    }

    @Nullable
    public static class_2338 locateBiome(class_5321<class_1959> biome, class_3218 level, class_2338 pos) {
        class_6880<class_1959> holder = BiomeHelper.getBiomeHolderFromBiomeKey(biome);
        Predicate<class_6880> biomePredicate = r -> ((class_1959)r.comp_349()).equals(holder.comp_349());
        Pair nearestBiome = level.method_24500(biomePredicate, pos, 6400, 8);
        return nearestBiome != null ? (class_2338)nearestBiome.getFirst() : null;
    }

    public static void addSpawnEntry(class_5321<class_1959> biomeKey, class_1311 group, class_1299<?> entity, int weight, int minGroupSize, int maxGroupSize) {
        Predicate<BiomeSelectionContext> context = c -> c.getBiomeKey() == biomeKey;
        BiomeModifications.addSpawn(context, (class_1311)group, entity, (int)weight, (int)minGroupSize, (int)maxGroupSize);
    }

    private static void makeSpawnSettingsMutable(class_5483 settings) {
        Map spawnCosts;
        Map spawners = settings.field_26405;
        if (spawners instanceof ImmutableMap) {
            settings.field_26405 = new HashMap(spawners);
        }
        if ((spawnCosts = settings.field_26406) instanceof ImmutableMap) {
            settings.field_26406 = new HashMap(spawnCosts);
        }
    }
}

