/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.helper;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import svenhjol.charm.helper.LogHelper;
import svenhjol.charm.helper.StringHelper;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.loader.CommonLoader;
import svenhjol.charm.loader.ModuleLoader;

public class RecipeHelper {
    private static final List<class_2960> RECIPES_TO_REMOVE = new ArrayList<class_2960>();

    public static void removeRecipe(class_2960 id) {
        LogHelper.debug(RecipeHelper.class, "Adding `" + id + "` to list of recipes to remove", new Object[0]);
        RECIPES_TO_REMOVE.add(id);
    }

    public static Map<class_3956<?>, Map<class_2960, class_1860<?>>> sortAndFilterRecipes(Map<class_3956<?>, Map<class_2960, class_1860<?>>> recipesByType, boolean doFilter) {
        LogHelper.debug(RecipeHelper.class, "Preparing to sort and filter recipes", new Object[0]);
        List<String> modIds = ModuleLoader.getModIds();
        Map<class_2960, CharmModule> charmModules = CommonLoader.getAllModules();
        LinkedHashMap out = new LinkedHashMap();
        recipesByType.keySet().forEach(type -> {
            Map recipes = (Map)recipesByType.get(type);
            LogHelper.debug(RecipeHelper.class, "Recipe type `" + type.toString() + "` contains " + recipes.size() + " recipes", new Object[0]);
            Stream<Map.Entry> moddedStream = recipes.entrySet().stream().filter(r -> !((class_2960)r.getKey()).method_12836().equals("minecraft"));
            Stream<Map.Entry> minecraftStream = recipes.entrySet().stream().filter(r -> ((class_2960)r.getKey()).method_12836().equals("minecraft"));
            if (doFilter) {
                moddedStream = moddedStream.filter(r -> {
                    boolean enabled;
                    class_2960 res = (class_2960)r.getKey();
                    String namespace = res.method_12836();
                    String path = res.method_12832();
                    if (!modIds.contains(namespace)) {
                        return true;
                    }
                    String moduleId = StringHelper.upperCamelToSnake(path.split("/")[0]);
                    class_2960 check = new class_2960(namespace, moduleId);
                    boolean bl = enabled = charmModules.containsKey(check) && ((CharmModule)charmModules.get(check)).isEnabled() && !RECIPES_TO_REMOVE.contains(res);
                    if (!enabled) {
                        LogHelper.debug(RecipeHelper.class, "> Filtering out recipe `" + res + "`", new Object[0]);
                    }
                    return enabled;
                });
            }
            LinkedHashMap<class_2960, class_1860> merged = new LinkedHashMap<class_2960, class_1860>();
            Map<class_2960, class_1860> moddedRecipes = moddedStream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<class_2960, class_1860> minecraftRecipes = minecraftStream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            merged.putAll(moddedRecipes);
            merged.putAll(minecraftRecipes);
            out.put((class_3956<?>)type, (Map<class_2960, class_1860<?>>)merged);
            LogHelper.debug(RecipeHelper.class, "Recipe type `" + type + "` reassembled with " + merged.size() + " recipes", new Object[0]);
        });
        return out;
    }
}

