/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.helper;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.fabric.mixin.object.builder.PointOfInterestTypeAccessor;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3614;
import net.minecraft.class_4158;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import svenhjol.charm.helper.DimensionHelper;
import svenhjol.charm.helper.LogHelper;
import svenhjol.charm.registry.CommonRegistry;

public class WorldHelper {
    private static final Map<class_2960, Boolean> CACHE_STRUCTURES = new HashMap<class_2960, Boolean>();
    private static final Map<class_2960, Boolean> CACHE_BIOMES = new HashMap<class_2960, Boolean>();

    public static boolean addForcedChunk(class_3218 level, class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        boolean result = false;
        for (int i = 0; i <= 2 && !(result = level.method_17988(chunkPos.method_8326(), chunkPos.method_8328(), true)); ++i) {
        }
        if (result) {
            LogHelper.debug(WorldHelper.class, "Force loaded chunk " + chunkPos, new Object[0]);
        }
        return result;
    }

    public static boolean removeForcedChunk(class_3218 level, class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        boolean result = level.method_17988(chunkPos.method_8326(), chunkPos.method_8328(), false);
        if (!result) {
            LogHelper.error(WorldHelper.class, "Could not unload forced chunk - this is probably really bad.", new Object[0]);
        } else {
            LogHelper.debug(WorldHelper.class, "Unloaded forced chunk " + chunkPos, new Object[0]);
        }
        return result;
    }

    public static void clearWeather(class_3218 level) {
        WorldHelper.clearWeather(level, level.field_9229.nextInt(12000) + 3600);
    }

    public static void clearWeather(class_3218 level, int duration) {
        level.method_27910(duration, 0, false, false);
    }

    public static void stormyWeather(class_3218 level) {
        WorldHelper.stormyWeather(level, level.field_9229.nextInt(12000) + 3600);
    }

    public static void stormyWeather(class_3218 level, int duration) {
        level.method_27910(0, duration, true, true);
    }

    public static class_4158 addPointOfInterestType(class_2960 id, class_2248 block, int ticketCount) {
        class_4158 poit = PointOfInterestTypeAccessor.callCreate((String)id.toString(), (Set)ImmutableSet.copyOf((Collection)block.method_9595().method_11662()), (int)ticketCount, (int)1);
        CommonRegistry.pointOfInterestType(id, poit);
        return PointOfInterestTypeAccessor.callSetup((class_4158)poit);
    }

    public static void addBlockStatesToPointOfInterest(class_4158 poit, List<class_2680> states) {
        Set existingStates = poit.field_18850;
        if (existingStates instanceof ImmutableSet) {
            ArrayList<class_2680> mutable = new ArrayList<class_2680>(existingStates);
            mutable.addAll(states);
            poit.field_18850 = ImmutableSet.copyOf(mutable);
        } else {
            existingStates.addAll(states);
            poit.field_18850 = existingStates;
        }
        class_4158.field_25162.addAll(states);
        states.forEach(state -> class_4158.field_18849.put(state, poit));
    }

    public static class_2338 addRandomOffset(class_2338 pos, Random rand, int min, int max) {
        int n = rand.nextInt(max - min) + min;
        int e = rand.nextInt(max - min) + min;
        int s = rand.nextInt(max - min) + min;
        int w = rand.nextInt(max - min) + min;
        pos = pos.method_10076(rand.nextBoolean() ? n : -n);
        pos = pos.method_10089(rand.nextBoolean() ? e : -e);
        pos = pos.method_10077(rand.nextBoolean() ? s : -s);
        pos = pos.method_10088(rand.nextBoolean() ? w : -w);
        return pos;
    }

    public static double getDistanceSquared(class_2338 pos1, class_2338 pos2) {
        double d0 = pos1.method_10263();
        double d1 = pos1.method_10260();
        double d2 = d0 - (double)pos2.method_10263();
        double d3 = d1 - (double)pos2.method_10260();
        return d2 * d2 + d3 * d3;
    }

    public static boolean isInsideStructure(class_3218 level, class_2338 pos, class_5312<?, ?> structure) {
        return level.method_27056().method_28388(pos, structure).method_16657();
    }

    public static boolean isLikeSolid(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return WorldHelper.isSolid(level, pos) || state.method_26207() == class_3614.field_15923 || state.method_26207() == class_3614.field_15948 || state.method_26207() == class_3614.field_15936 || state.method_26207() == class_3614.field_15935;
    }

    public static boolean isLikeAir(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return !state.method_26225() || state.method_26207() == class_3614.field_15920 || state.method_26207() == class_3614.field_15948 || state.method_26207() == class_3614.field_15935 || state.method_26207() == class_3614.field_15923 || state.method_26207() == class_3614.field_15936;
    }

    public static boolean isSolid(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return state.method_26225() && !level.method_22347(pos) && !state.method_26207().method_15797();
    }

    public static boolean isStructure(class_2960 structureId) {
        return CACHE_STRUCTURES.computeIfAbsent(structureId, b -> class_2378.field_16644.method_10223(structureId) != null);
    }

    public static boolean isBiome(class_2960 biomeId) {
        return CACHE_BIOMES.computeIfAbsent(biomeId, b -> class_5458.field_25933.method_10223(biomeId) != null);
    }

    @Nullable
    public static class_2338 getSurfacePos(class_1937 level, class_2338 pos) {
        return WorldHelper.getSurfacePos(level, pos, level.method_31600());
    }

    @Nullable
    public static class_2338 getSurfacePos(class_1937 level, class_2338 pos, int startAtHeight) {
        int surface = 0;
        for (int y = startAtHeight; y >= 0; --y) {
            class_2338 n = new class_2338(pos.method_10263(), y, pos.method_10260());
            if (!level.method_22347(n) || level.method_22347(n.method_10074())) continue;
            surface = y;
            break;
        }
        if (surface <= 0) {
            LogHelper.warn(WorldHelper.class, "Failed to find a surface value to spawn the player", new Object[0]);
            return null;
        }
        return new class_2338(pos.method_10263(), surface, pos.method_10260());
    }

    public static void explode(class_3218 level, class_2338 pos, float size, class_1927.class_4179 interaction) {
        level.method_8437(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, size, interaction);
    }

    public static void syncBlockEntityToClient(class_3218 level, class_2338 pos) {
        level.method_14178().method_14128(pos);
    }

    public static class_2680 getSurfaceBlockForDimension(class_3218 level) {
        class_2680 block = DimensionHelper.isEnd((class_1937)level) ? class_2246.field_10471.method_9564() : (DimensionHelper.isNether((class_1937)level) ? class_2246.field_10515.method_9564() : class_2246.field_10340.method_9564());
        return block;
    }

    @Nullable
    public static class_2338 findNearestMapFeature(String id, class_3218 level, class_2338 origin, int distance, boolean skipExploredChunks) {
        if (id.startsWith("#")) {
            class_6862 tagKey = class_6862.method_40092((class_5321)class_2378.field_25915, (class_2960)new class_2960(id.substring(1)));
            return WorldHelper.findNearestMapFeature(tagKey, level, origin, distance, skipExploredChunks);
        }
        class_2960 res = new class_2960(id);
        return WorldHelper.findNearestMapFeature(res, level, origin, distance, skipExploredChunks);
    }

    @Nullable
    public static class_2338 findNearestMapFeature(class_2960 id, class_3218 level, class_2338 origin, int distance, boolean skipExploredChunks) {
        class_5321 configuredStructures = class_2378.field_25915;
        class_2378 registry = level.method_30349().method_30530(configuredStructures);
        class_5321 resourceKey = class_5321.method_29179((class_5321)class_2378.field_25915, (class_2960)id);
        try {
            class_6885.class_6886 holderSet = registry.method_40264(resourceKey).map(xva$0 -> class_6885.method_40246((class_6880[])new class_6880[]{xva$0})).orElseThrow();
            Pair destination = level.method_14178().method_12129().method_12103(level, (class_6885)holderSet, origin, distance, skipExploredChunks);
            return destination != null ? (class_2338)destination.getFirst() : null;
        }
        catch (Exception e) {
            LogHelper.debug("charm", WorldHelper.class, "Failed to locate structure: " + id, new Object[0]);
            return null;
        }
    }

    @Nullable
    public static class_2338 findNearestMapFeature(class_6862<class_5312<?, ?>> id, class_3218 level, class_2338 origin, int distance, boolean skipExploredChunks) {
        return level.method_8487(id, origin, distance, skipExploredChunks);
    }
}

