/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.mixin;

import com.google.common.reflect.ClassPath;
import com.moandjiezana.toml.Toml;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import svenhjol.charm.helper.ClassHelper;
import svenhjol.charm.helper.ConfigHelper;
import svenhjol.charm.helper.ModHelper;
import svenhjol.charm.helper.StringHelper;

public abstract class BaseMixinConfigPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN = "Mixin";
    private static final String CHARM_MIXIN = "CharmMixin";
    private static final String ENABLE_IF_MODS_PRESENT = "enableIfModsPresent";
    private static final String DISABLE_IF_MODS_PRESENT = "disableIfModsPresent";
    private static final String REQUIRED = "required";
    private String mixinPackage;
    public static final Map<String, Boolean> disabledMixins = new HashMap<String, Boolean>();
    public static final Map<String, Boolean> requiredMixins = new HashMap<String, Boolean>();

    public abstract String getModId();

    public void onLoad(String mixinPackage) {
        Iterable<ClassPath.ClassInfo> classes;
        Logger logger = LogManager.getLogger();
        Toml toml = ConfigHelper.readConfig(this.getModId());
        boolean debug = ConfigHelper.isDebugMode(toml) || FabricLoader.getInstance().isDevelopmentEnvironment();
        this.mixinPackage = mixinPackage;
        String blacklistPath = FabricLoader.getInstance().getConfigDir() + "/" + this.getModId() + "-mixin-blacklist.txt";
        try {
            FileInputStream stream = new FileInputStream(blacklistPath);
            Scanner scanner = new Scanner(stream);
            while (scanner.hasNextLine()) {
                disabledMixins.put(scanner.nextLine(), true);
            }
            scanner.close();
            stream.close();
        }
        catch (FileNotFoundException stream) {
        }
        catch (IOException e) {
            LogManager.getLogger().warn("[MixinConfig] IO error when handling mixin blacklist: " + e.getMessage());
        }
        try {
            ClassLoader classLoader = BaseMixinConfigPlugin.class.getClassLoader();
            classes = ClassHelper.getClassesInPackage(classLoader, mixinPackage);
        }
        catch (Exception e) {
            throw new IllegalStateException("[MixinConfig] Could not fetch mixin classes, giving up: " + e.getMessage());
        }
        int countProcessed = 0;
        for (ClassPath.ClassInfo c : classes) {
            String className = c.getName();
            String truncatedName = className.substring(mixinPackage.length() + 1);
            if (this.getClass().getName().equals(className) || className.contains("BaseMixinConfigPlugin")) continue;
            try {
                ClassReader classReader = new ClassReader(c.asByteSource().read());
                ClassNode node = new ClassNode();
                classReader.accept((ClassVisitor)node, 7);
                boolean disabled = false;
                boolean required = false;
                String moduleName = StringHelper.snakeToUpperCamel(truncatedName.substring(0, truncatedName.indexOf(".")));
                if (!moduleName.isEmpty() && ConfigHelper.isModuleDisabled(toml, moduleName)) {
                    disabledMixins.put(truncatedName, true);
                }
                if (node.visibleAnnotations != null && !node.visibleAnnotations.isEmpty()) {
                    for (AnnotationNode annotation : node.visibleAnnotations) {
                        if (!annotation.desc.contains(MIXIN) || annotation.values.isEmpty()) continue;
                        ArrayList<String> keys = new ArrayList<String>();
                        ArrayList values = new ArrayList();
                        for (int i = 0; i < annotation.values.size(); ++i) {
                            if (i % 2 == 0) {
                                keys.add((String)annotation.values.get(i));
                                continue;
                            }
                            values.add(annotation.values.get(i));
                        }
                        HashMap annotations = new HashMap();
                        for (int i = 0; i < keys.size(); ++i) {
                            annotations.put((String)keys.get(i), values.get(i));
                        }
                        required = annotations.containsKey(REQUIRED) && (Boolean)annotations.get(REQUIRED) != false;
                        if (required) continue;
                        ArrayList modsToCheck = new ArrayList();
                        if (annotations.containsKey(DISABLE_IF_MODS_PRESENT)) {
                            ((ArrayList)annotations.get(DISABLE_IF_MODS_PRESENT)).forEach(m -> modsToCheck.add((String)m));
                            if (modsToCheck.stream().anyMatch(ModHelper::isLoaded)) {
                                disabledMixins.put(truncatedName, true);
                                disabled = true;
                            }
                        }
                        if (!annotations.containsKey(ENABLE_IF_MODS_PRESENT)) continue;
                        ((ArrayList)annotations.get(ENABLE_IF_MODS_PRESENT)).forEach(m -> modsToCheck.add((String)m));
                        if (!modsToCheck.stream().anyMatch(mod -> !ModHelper.isLoaded(mod))) continue;
                        disabledMixins.put(truncatedName, true);
                        disabled = true;
                    }
                }
                if (className.contains("accessor")) {
                    required = true;
                }
                if (className.contains("devenv") && !FabricLoader.getInstance().isDevelopmentEnvironment()) {
                    disabled = true;
                }
                if (required) {
                    disabledMixins.remove(truncatedName);
                    requiredMixins.put(truncatedName, true);
                }
                if (!disabled && !required && BaseMixinConfigPlugin.isMixinDisabled(truncatedName)) {
                    disabled = true;
                    if (truncatedName.contains(".") && !disabledMixins.containsKey(truncatedName)) {
                        disabledMixins.put(truncatedName, true);
                    }
                }
                if (required) {
                    if (debug) {
                        logger.info("[MixinConfig] Requiring " + truncatedName);
                    }
                } else if (disabled) {
                    String message = "[MixinConfig] Not adding " + truncatedName;
                    if (debug) {
                        logger.warn(message);
                    } else {
                        logger.info(message);
                    }
                } else if (debug) {
                    logger.info("[MixinConfig] Adding " + truncatedName);
                }
                ++countProcessed;
            }
            catch (Exception e) {
                logger.error("[MixinConfig] Error occurred while processing mixin " + truncatedName + ": " + e.getMessage());
            }
        }
        if (countProcessed == 0) {
            logger.warn("[MixinConfig] Seems no mixin classes were processed... this might be bad.");
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String truncatedName = mixinClassName.substring(this.mixinPackage.length() + 1);
        return requiredMixins.containsKey(truncatedName) || !BaseMixinConfigPlugin.isMixinDisabled(truncatedName);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public static boolean isMixinDisabled(String truncatedName) {
        return disabledMixins.keySet().stream().anyMatch(s -> s.equalsIgnoreCase("ALL") || Pattern.matches(s, truncatedName) || Pattern.matches(truncatedName, s) || s.contains(truncatedName) || truncatedName.contains((CharSequence)s));
    }
}

