/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.atlases;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_5321;
import svenhjol.charm.helper.NbtHelper;
import svenhjol.charm.module.atlases.AtlasContainer;
import svenhjol.charm.module.atlases.Atlases;

public class AtlasInventory
implements class_3908,
class_1263 {
    public static final String EMPTY_MAPS = "empty_maps";
    public static final String FILLED_MAPS = "filled_maps";
    public static final String ACTIVE_MAP = "active_map";
    public static final String SCALE = "scale";
    public static final String ID = "id";
    private static final int EMPTY_MAP_SLOTS = 3;
    private final Table<class_5321<class_1937>, Index, MapInfo> mapInfos;
    private final class_2371<class_1799> emptyMaps;
    private int diameter;
    private class_1799 atlas;
    private int scale;
    private boolean isOpen = false;

    public AtlasInventory(class_1799 atlas) {
        this.atlas = atlas;
        this.scale = Atlases.defaultScale;
        this.diameter = 128;
        this.emptyMaps = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
        this.mapInfos = HashBasedTable.create();
        this.load();
    }

    public void reload(class_1799 atlas) {
        this.atlas = atlas;
        this.emptyMaps.clear();
        this.mapInfos.clear();
        this.load();
    }

    private void load() {
        this.scale = NbtHelper.getInt(this.atlas, SCALE, Atlases.defaultScale);
        this.diameter = 128 * (1 << this.scale);
        class_1262.method_5429((class_2487)NbtHelper.getCompound(this.atlas, EMPTY_MAPS), this.emptyMaps);
        class_2499 listNBT = NbtHelper.getList(this.atlas, FILLED_MAPS);
        for (int i = 0; i < listNBT.size(); ++i) {
            this.putMapInfo(MapInfo.readFrom(listNBT.method_10602(i)));
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    private void putMapInfo(MapInfo mapInfo) {
        this.mapInfos.put(mapInfo.dimension, (Object)this.convertCoordsToIndex(mapInfo.x, mapInfo.z), (Object)mapInfo);
    }

    public Index getIndexOf(class_1657 player) {
        return this.convertCoordsToIndex((int)player.method_23317() + 64, (int)player.method_23321() + 64);
    }

    public Index convertCoordsToIndex(int x, int y) {
        return Index.of(this.convertCoordToIndex(x), this.convertCoordToIndex(y));
    }

    public int convertCoordToIndex(int coordinate) {
        return Math.floorDiv(coordinate, this.diameter);
    }

    @Nullable
    private static MapInfo createMapInfo(class_1937 level, class_1799 map) {
        Integer mapId = class_1806.method_8003((class_1799)map);
        if (mapId == null) {
            return null;
        }
        class_22 mapData = class_1806.method_7997((Integer)mapId, (class_1937)level);
        return mapData != null ? new MapInfo(mapData.field_116, mapData.field_115, class_1806.method_8003((class_1799)map), map, (class_5321<class_1937>)mapData.field_118) : null;
    }

    public boolean updateActiveMap(class_3222 player) {
        MapInfo activeMap = (MapInfo)this.mapInfos.get((Object)player.field_6002.method_27983(), (Object)this.getIndexOf((class_1657)player));
        boolean madeNewMap = false;
        if (activeMap == null && !this.isOpen) {
            activeMap = this.makeNewMap(player, (int)player.method_23317(), (int)player.method_23321());
            boolean bl = madeNewMap = activeMap != null;
        }
        if (activeMap != null) {
            Atlases.sendMapToClient(player, activeMap.map, false);
            NbtHelper.setInt(this.atlas, ACTIVE_MAP, activeMap.id);
        } else {
            NbtHelper.setInt(this.atlas, ACTIVE_MAP, -1);
        }
        return madeNewMap;
    }

    private MapInfo makeNewMap(class_3222 player, int x, int z) {
        for (int i = 0; i < 3; ++i) {
            class_1799 stack = (class_1799)this.emptyMaps.get(i);
            if (stack.method_7909() != class_1802.field_8895) continue;
            if (!player.method_7337()) {
                this.method_5434(i, 1);
            }
            class_1799 map = class_1806.method_8005((class_1937)player.field_6002, (int)x, (int)z, (byte)((byte)this.scale), (boolean)true, (boolean)true);
            MapInfo mapInfo = AtlasInventory.createMapInfo(player.field_6002, map);
            this.putMapInfo(mapInfo);
            this.method_5431();
            player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_17484, class_3419.field_15245, 0.5f, player.field_6002.field_9229.nextFloat() * 0.1f + 0.9f);
            return mapInfo;
        }
        return null;
    }

    @Nullable
    public int getActiveMapId(class_1937 level) {
        return NbtHelper.getInt(this.atlas, ACTIVE_MAP, -1);
    }

    @Nullable
    public class_22 getActiveMap(class_1937 level) {
        int mapId = this.getActiveMapId(level);
        if (mapId == -1) {
            return null;
        }
        return level.method_17891(class_1806.method_17440((int)mapId));
    }

    @Nullable
    public class_1799 getLastActiveMapItem() {
        int activeId = NbtHelper.getInt(this.atlas, ACTIVE_MAP, -1);
        if (activeId == -1) {
            return null;
        }
        return this.mapInfos.values().stream().filter(it -> it.id == activeId).findAny().map(it -> it.map).orElse(null);
    }

    @Nonnull
    public class_2561 method_5476() {
        return this.atlas.method_7964();
    }

    @Nullable
    public class_1703 createMenu(int syncId, @Nonnull class_1661 playerInventory, @Nonnull class_1657 player) {
        return new AtlasContainer(syncId, playerInventory, this);
    }

    public int method_5439() {
        return 3;
    }

    public boolean method_5442() {
        for (class_1799 stack : this.emptyMaps) {
            if (stack.method_7960()) continue;
            return false;
        }
        return this.mapInfos.isEmpty();
    }

    @Nonnull
    public class_1799 method_5438(int index) {
        return (class_1799)this.emptyMaps.get(index);
    }

    @Nonnull
    public class_1799 method_5434(int index, int count) {
        class_1799 itemstack = class_1262.method_5430(this.emptyMaps, (int)index, (int)count);
        this.method_5431();
        return itemstack;
    }

    @Nonnull
    public class_1799 method_5441(int index) {
        class_1799 itemStack = class_1262.method_5428(this.emptyMaps, (int)index);
        this.method_5431();
        return itemStack;
    }

    public MapInfo removeMapByCoords(class_1937 level, int x, int z) {
        MapInfo info = (MapInfo)this.mapInfos.remove((Object)level.method_27983(), (Object)this.convertCoordsToIndex(x, z));
        this.method_5431();
        return info;
    }

    public void addToInventory(class_1937 level, class_1799 itemStack) {
        if (itemStack.method_7909() == class_1802.field_8204) {
            this.putMapInfo(AtlasInventory.createMapInfo(level, itemStack));
            this.method_5431();
        }
    }

    public void method_5447(int index, @Nonnull class_1799 stack) {
        if (!((class_1799)this.emptyMaps.get(index)).equals(stack)) {
            this.emptyMaps.set(index, (Object)stack);
            if (stack.method_7947() > this.method_5444()) {
                stack.method_7939(this.method_5444());
            }
            this.method_5431();
        }
    }

    public void method_5431() {
        NbtHelper.setInt(this.atlas, SCALE, this.scale);
        class_2487 emptyMapNBT = new class_2487();
        class_1262.method_5427((class_2487)emptyMapNBT, this.emptyMaps, (boolean)false);
        NbtHelper.setCompound(this.atlas, EMPTY_MAPS, emptyMapNBT);
        class_2499 listNBT = new class_2499();
        for (MapInfo mapInfo : this.mapInfos.values()) {
            class_2487 nbt = new class_2487();
            mapInfo.writeTo(nbt);
            listNBT.add((Object)nbt);
        }
        NbtHelper.setList(this.atlas, FILLED_MAPS, listNBT);
    }

    public boolean method_5443(@Nonnull class_1657 player) {
        for (class_1268 hand : class_1268.values()) {
            class_1799 heldItem = player.method_5998(hand);
            if (heldItem.method_7909() != Atlases.ATLAS_ITEM || !Objects.equals(NbtHelper.getUuid(this.atlas, ID), NbtHelper.getUuid(heldItem, ID))) continue;
            return true;
        }
        return false;
    }

    public void method_5448() {
        this.emptyMaps.clear();
        this.mapInfos.clear();
    }

    public void method_5435(class_1657 player) {
        this.isOpen = true;
        if (!player.field_6002.field_9236) {
            player.method_17356(Atlases.ATLAS_OPEN_SOUND, class_3419.field_15245, 0.4f, player.field_6002.field_9229.nextFloat() * 0.1f + 0.9f);
        }
    }

    public void method_5432(class_1657 player) {
        this.isOpen = false;
        if (!player.field_6002.field_9236) {
            player.method_17356(Atlases.ATLAS_CLOSE_SOUND, class_3419.field_15245, 0.4f, player.field_6002.field_9229.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean hasItemStack(class_1799 stack) {
        return Stream.concat(this.emptyMaps.stream(), this.mapInfos.values().stream().map(it -> it.map)).anyMatch(it -> !it.method_7960() && it.method_7929(stack));
    }

    public class_1799 getAtlasItem() {
        return this.atlas;
    }

    public Table<class_5321<class_1937>, Index, MapInfo> getMapInfos() {
        return this.mapInfos;
    }

    public Map<Index, MapInfo> getCurrentDimensionMapInfos(class_1937 level) {
        return this.mapInfos.row((Object)level.method_27983());
    }

    public int getScale() {
        return this.scale;
    }

    public static class MapInfo {
        private static final String X = "x";
        private static final String Z = "z";
        private static final String ID = "id";
        private static final String MAP = "map";
        private static final String DIMENSION = "dimension";
        public final int x;
        public final int z;
        public final int id;
        public final class_1799 map;
        public final class_5321<class_1937> dimension;

        private MapInfo(int x, int z, int id, class_1799 map, class_5321<class_1937> dimension) {
            this.x = x;
            this.z = z;
            this.id = id;
            this.map = map;
            this.dimension = dimension;
        }

        public static MapInfo readFrom(class_2487 tag) {
            return new MapInfo(tag.method_10550(X), tag.method_10550(Z), tag.method_10550("id"), class_1799.method_7915((class_2487)tag.method_10562(MAP)), (class_5321<class_1937>)class_2874.method_28521((Dynamic)new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10580(DIMENSION))).result().orElse(class_1937.field_25179));
        }

        public void writeTo(class_2487 tag) {
            tag.method_10569(X, this.x);
            tag.method_10569(Z, this.z);
            tag.method_10569("id", this.id);
            class_2487 mapNBT = new class_2487();
            this.map.method_7953(mapNBT);
            tag.method_10566(MAP, (class_2520)mapNBT);
            class_2960.field_25139.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.dimension.method_29177()).result().ifPresent(it -> tag.method_10566(DIMENSION, it));
        }
    }

    public static class Index {
        private static final Int2ObjectMap<Int2ObjectMap<Index>> cache = new Int2ObjectOpenHashMap();
        public final int x;
        public final int y;

        private Index(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Index plus(Index value) {
            return this.transform(it -> (Integer)it.apply(this) + (Integer)it.apply(value));
        }

        public Index plus(int value) {
            return this.transform(it -> (Integer)it.apply(this) + value);
        }

        public Index minus(Index value) {
            return this.transform(it -> (Integer)it.apply(this) - (Integer)it.apply(value));
        }

        public Index minus(int value) {
            return this.transform(it -> (Integer)it.apply(this) - value);
        }

        public Index multiply(int value) {
            return this.transform(it -> (Integer)it.apply(this) * value);
        }

        public Index divide(int value) {
            return this.transform(it -> (Integer)it.apply(this) / value);
        }

        public Index clamp(Index min, Index max) {
            return this.transform(it -> class_3532.method_15340((int)((Integer)it.apply(this)), (int)((Integer)it.apply(min)), (int)((Integer)it.apply(max))));
        }

        private Index transform(Function<Function<Index, Integer>, Integer> transformer) {
            return Index.of(transformer.apply(it -> it.x), transformer.apply(it -> it.y));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Index index = (Index)o;
            return this.x == index.x && this.y == index.y;
        }

        public int hashCode() {
            return 7079 * this.x + this.y;
        }

        public static Index of(int x, int y) {
            Index index;
            Int2ObjectMap columnCache = (Int2ObjectMap)cache.get(x);
            if (columnCache == null) {
                columnCache = new Int2ObjectOpenHashMap();
                cache.put(x, (Object)columnCache);
            }
            if ((index = (Index)columnCache.get(y)) == null) {
                index = new Index(x, y);
                columnCache.put(y, (Object)index);
            }
            return index;
        }
    }
}

