/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.atlases;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1762;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3414;
import net.minecraft.class_3910;
import net.minecraft.class_3917;
import net.minecraft.server.MinecraftServer;
import svenhjol.charm.Charm;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.api.event.PlayerTickCallback;
import svenhjol.charm.helper.NbtHelper;
import svenhjol.charm.init.CharmAdvancements;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.atlases.AtlasContainer;
import svenhjol.charm.module.atlases.AtlasInventory;
import svenhjol.charm.module.atlases.AtlasItem;
import svenhjol.charm.module.atlases.network.ServerReceiveSwapAtlas;
import svenhjol.charm.module.atlases.network.ServerReceiveTransferAtlas;
import svenhjol.charm.module.atlases.network.ServerSendSwappedSlot;
import svenhjol.charm.module.atlases.network.ServerSendUpdateInventory;
import svenhjol.charm.registry.CommonRegistry;

@CommonModule(mod="charm", description="Storage for maps that automatically updates the displayed map as you explore.")
public class Atlases
extends CharmModule {
    public static final class_2960 ID = new class_2960("charm", "atlas");
    public static final class_2960 TRIGGER_MADE_ATLAS_MAPS = new class_2960("charm", "made_atlas_maps");
    public static ServerSendSwappedSlot SERVER_SEND_SWAPPED_SLOT;
    public static ServerSendUpdateInventory SERVER_SEND_UPDATE_INVENTORY;
    public static ServerReceiveSwapAtlas SERVER_RECEIVE_SWAP_ATLAS;
    public static ServerReceiveTransferAtlas SERVER_RECEIVE_TRANSFER_ATLAS;
    public static class_3414 ATLAS_OPEN_SOUND;
    public static class_3414 ATLAS_CLOSE_SOUND;
    public static final int NUMBER_OF_MAPS_FOR_ACHIEVEMENT = 10;
    public static final List<class_1792> VALID_ATLAS_ITEMS;
    private static final Map<UUID, AtlasInventory> serverCache;
    private static final Map<UUID, AtlasInventory> clientCache;
    @Config(name="Open in off hand", description="Allow opening the atlas while it is in the off hand.")
    public static boolean offHandOpen;
    @Config(name="Map scale", description="Map scale used in atlases by default.")
    public static int defaultScale;
    @Config(name="Enable keybind", description="If true, sets a keybind for swapping the item in your main hand with the first available atlas in your inventory (defaults to 'r').")
    public static boolean enableKeybind;
    public static AtlasItem ATLAS_ITEM;
    public static class_3917<AtlasContainer> MENU;

    @Override
    public void register() {
        ATLAS_ITEM = new AtlasItem(this);
        VALID_ATLAS_ITEMS.add(class_1802.field_8895);
        VALID_ATLAS_ITEMS.add(class_1802.field_8204);
        ATLAS_OPEN_SOUND = CommonRegistry.sound(new class_2960("charm", "atlas_open"));
        ATLAS_CLOSE_SOUND = CommonRegistry.sound(new class_2960("charm", "atlas_close"));
        MENU = CommonRegistry.menu(ID, (syncId, playerInventory) -> new AtlasContainer(syncId, playerInventory, Atlases.findAtlas(playerInventory)));
    }

    @Override
    public void runWhenEnabled() {
        PlayerTickCallback.EVENT.register(this::handlePlayerTick);
        ServerPlayConnectionEvents.JOIN.register(this::handlePlayerJoin);
        SERVER_SEND_SWAPPED_SLOT = new ServerSendSwappedSlot();
        SERVER_SEND_UPDATE_INVENTORY = new ServerSendUpdateInventory();
        SERVER_RECEIVE_SWAP_ATLAS = new ServerReceiveSwapAtlas();
        SERVER_RECEIVE_TRANSFER_ATLAS = new ServerReceiveTransferAtlas();
    }

    public static boolean inventoryContainsMap(class_1661 inventory, class_1799 stack) {
        if (inventory.method_7379(stack)) {
            return true;
        }
        if (Charm.LOADER.isEnabled(Atlases.class)) {
            for (class_1268 hand : class_1268.values()) {
                AtlasInventory inv;
                class_1799 atlasStack = inventory.field_7546.method_5998(hand);
                if (atlasStack.method_7909() != ATLAS_ITEM || !(inv = Atlases.getInventory(inventory.field_7546.field_6002, atlasStack)).hasItemStack(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static AtlasInventory getInventory(class_1937 level, class_1799 stack) {
        Map<UUID, AtlasInventory> cache;
        AtlasInventory inventory;
        UUID id = NbtHelper.getUuid(stack, "id");
        if (id == null) {
            id = UUID.randomUUID();
            NbtHelper.setUuid(stack, "id", id);
        }
        if ((inventory = (cache = level.field_9236 ? clientCache : serverCache).get(id)) == null) {
            inventory = new AtlasInventory(stack);
            cache.put(id, inventory);
        }
        if (inventory.getAtlasItem() != stack) {
            inventory.reload(stack);
        }
        return inventory;
    }

    public static void sendMapToClient(class_3222 player, class_1799 map, boolean markDirty) {
        if (map.method_7909().method_16698()) {
            if (markDirty) {
                Integer mapId = class_1806.method_8003((class_1799)map);
                class_22 mapState = class_1806.method_7997((Integer)mapId, (class_1937)player.field_6002);
                if (mapState == null) {
                    return;
                }
                mapState.method_103(0, 0);
            }
            map.method_7909().method_7888(map, player.field_6002, (class_1297)player, -1, true);
            class_2596 packet = ((class_1762)map.method_7909()).method_7757(map, player.field_6002, (class_1657)player);
            if (packet != null) {
                player.field_13987.method_14364(packet);
            }
        }
    }

    public static void updateClient(class_3222 player, int atlasSlot) {
        SERVER_SEND_UPDATE_INVENTORY.send(player, atlasSlot);
    }

    private static AtlasInventory findAtlas(class_1661 inventory) {
        for (class_1268 hand : class_1268.values()) {
            class_1799 stack = inventory.field_7546.method_5998(hand);
            if (stack.method_7909() != ATLAS_ITEM) continue;
            return Atlases.getInventory(inventory.field_7546.field_6002, stack);
        }
        throw new IllegalStateException("No atlas in any hand, can't open!");
    }

    public static void setupAtlasUpscale(final class_1661 playerInventory, class_3910 container) {
        if (Charm.LOADER.isEnabled(Atlases.class)) {
            final class_1735 oldSlot = (class_1735)container.field_7761.get(0);
            container.field_7761.set(0, (Object)new class_1735(oldSlot.field_7871, oldSlot.field_7874, oldSlot.field_7873, oldSlot.field_7872){

                public boolean method_7680(class_1799 stack) {
                    return oldSlot.method_7680(stack) || stack.method_7909() == ATLAS_ITEM && Atlases.getInventory(playerInventory.field_7546.field_6002, stack).getMapInfos().isEmpty();
                }
            });
        }
    }

    public static boolean makeAtlasUpscaleOutput(class_1799 topStack, class_1799 bottomStack, class_1799 outputStack, class_1937 level, class_1731 craftResultInventory, class_3910 cartographyContainer) {
        if (Charm.LOADER.isEnabled(Atlases.class) && topStack.method_7909() == ATLAS_ITEM) {
            class_1799 output;
            AtlasInventory inventory = Atlases.getInventory(level, topStack);
            if (inventory.getMapInfos().isEmpty() && bottomStack.method_7909() == class_1802.field_8895 && inventory.getScale() < 4) {
                output = topStack.method_7972();
                NbtHelper.setUuid(output, "id", UUID.randomUUID());
                NbtHelper.setInt(output, "scale", inventory.getScale() + 1);
            } else {
                output = class_1799.field_8037;
            }
            if (!class_1799.method_7973((class_1799)output, (class_1799)outputStack)) {
                craftResultInventory.method_5447(2, output);
                cartographyContainer.method_7623();
            }
            return true;
        }
        return false;
    }

    public static void triggerMadeMaps(class_3222 player) {
        CharmAdvancements.ACTION_PERFORMED.trigger(player, TRIGGER_MADE_ATLAS_MAPS);
    }

    private void handlePlayerTick(class_1657 player) {
        if (!player.field_6002.field_9236) {
            class_3222 serverPlayer = (class_3222)player;
            for (class_1268 hand : class_1268.values()) {
                AtlasInventory inventory;
                class_1799 atlas = serverPlayer.method_5998(hand);
                if (atlas.method_7909() != ATLAS_ITEM || !(inventory = Atlases.getInventory(serverPlayer.field_6002, atlas)).updateActiveMap(serverPlayer)) continue;
                Atlases.updateClient(serverPlayer, Atlases.getSlotFromHand((class_1657)serverPlayer, hand));
                if (inventory.getMapInfos().size() < 10) continue;
                Atlases.triggerMadeMaps((class_3222)player);
            }
        }
    }

    private void handlePlayerJoin(class_3244 listener, PacketSender sender, MinecraftServer server) {
        SERVER_SEND_SWAPPED_SLOT.send(listener.method_32311(), -1);
    }

    private static int getSlotFromHand(class_1657 player, class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return player.method_31548().field_7545;
        }
        return player.method_31548().method_5439() - 1;
    }

    static {
        VALID_ATLAS_ITEMS = new ArrayList<class_1792>();
        serverCache = new HashMap<UUID, AtlasInventory>();
        clientCache = new HashMap<UUID, AtlasInventory>();
        offHandOpen = false;
        defaultScale = 0;
        enableKeybind = true;
    }

    public static enum MoveMode {
        TO_HAND,
        TO_INVENTORY,
        FROM_HAND,
        FROM_INVENTORY;

    }
}

