/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.auto_restock;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2499;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import svenhjol.charm.Charm;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.api.event.PlayerTickCallback;
import svenhjol.charm.loader.CharmModule;

@CommonModule(mod="charm", description="Refills your hotbar from your inventory.")
public class AutoRestock
extends CharmModule {
    private final Map<class_1657, EnumMap<class_1268, StackData>> handCache = new WeakHashMap<class_1657, EnumMap<class_1268, StackData>>();

    @Override
    public void runWhenEnabled() {
        PlayerTickCallback.EVENT.register(this::handlePlayerTick);
    }

    public static void addItemUsedStat(class_1657 player, class_1799 stack) {
        if (Charm.LOADER.isEnabled(AutoRestock.class)) {
            player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
        }
    }

    private void handlePlayerTick(class_1657 player) {
        if (!player.field_6002.field_9236) {
            class_3222 serverPlayer = (class_3222)player;
            EnumMap cached = this.handCache.computeIfAbsent((class_1657)serverPlayer, it -> new EnumMap(class_1268.class));
            for (class_1268 hand : class_1268.values()) {
                StackData stackData = (StackData)cached.get(hand);
                if (stackData != null && serverPlayer.method_5998(hand).method_7960() && this.getItemUsed(serverPlayer, stackData.item) > stackData.used) {
                    this.findReplacement(serverPlayer, hand, stackData);
                }
                this.updateCache(serverPlayer, hand, cached);
            }
        }
    }

    private void updateCache(class_3222 player, class_1268 hand, EnumMap<class_1268, StackData> cached) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7960()) {
            cached.put(hand, null);
        } else {
            class_1792 item = stack.method_7909();
            int used = this.getItemUsed(player, item);
            class_2499 enchantments = stack.method_7921();
            StackData stackData = cached.get(hand);
            if (stackData == null) {
                stackData = new StackData();
                cached.put(hand, stackData);
            }
            stackData.item = item;
            stackData.enchantments = enchantments;
            stackData.used = used;
        }
    }

    private int getItemUsed(class_3222 player, class_1792 item) {
        return player.method_14248().method_15025(class_3468.field_15372.method_14956((Object)item));
    }

    private void findReplacement(class_3222 player, class_1268 hand, StackData stackData) {
        class_1661 inventory = player.method_31548();
        if (inventory != null) {
            for (int i = 9; i < Math.min(36, inventory.method_5439()); ++i) {
                class_1799 possibleReplacement = inventory.method_5438(i);
                if (stackData.item != possibleReplacement.method_7909() || !Objects.equals(stackData.enchantments, possibleReplacement.method_7921())) continue;
                player.method_6122(hand, possibleReplacement.method_7972());
                inventory.method_5434(i, inventory.method_5444());
                break;
            }
        }
    }

    private static class StackData {
        private class_1792 item;
        private class_2499 enchantments;
        private int used;

        private StackData() {
        }
    }
}

