/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.colored_nether_portals;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2423;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4158;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.helper.PlayerHelper;
import svenhjol.charm.helper.WorldHelper;
import svenhjol.charm.init.CharmAdvancements;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.colored_nether_portals.ColoredNetherPortalBlock;
import svenhjol.charm.registry.CommonRegistry;

@CommonModule(mod="charm", description="Throw dye into a nether portal to change its color.")
public class ColoredNetherPortals
extends CharmModule {
    public static Map<class_1767, ColoredNetherPortalBlock> BLOCKS = new HashMap<class_1767, ColoredNetherPortalBlock>();
    public static class_3414 PORTAL_CHANGE_COLOR_SOUND;
    public static final class_2960 TRIGGER_COLORED_PORTAL;

    @Override
    public void register() {
        for (class_1767 color : class_1767.values()) {
            BLOCKS.put(color, new ColoredNetherPortalBlock(this, color));
        }
        PORTAL_CHANGE_COLOR_SOUND = CommonRegistry.sound(new class_2960("charm", "portal_change_color"));
    }

    @Override
    public void runWhenEnabled() {
        ArrayList<class_2680> states = new ArrayList<class_2680>();
        BLOCKS.values().forEach(b -> states.addAll((Collection<class_2680>)b.method_9595().method_11662()));
        WorldHelper.addBlockStatesToPointOfInterest(class_4158.field_20632, states);
    }

    public static void replacePortal(class_1937 level, class_2338 pos, class_2680 state, class_1767 color) {
        class_2338 newPos;
        class_2350 dir1;
        HashSet set = Sets.newHashSet();
        ArrayDeque queue = Queues.newArrayDeque();
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)class_2423.field_11310);
        class_2680 newState = (class_2680)BLOCKS.get(color).method_9564().method_11657((class_2769)class_2423.field_11310, (Comparable)axis);
        class_2350 dir2 = switch (axis) {
            case class_2350.class_2351.field_11048 -> {
                dir1 = class_2350.field_11036;
                yield class_2350.field_11034;
            }
            case class_2350.class_2351.field_11052 -> {
                dir1 = class_2350.field_11035;
                yield class_2350.field_11034;
            }
            default -> {
                dir1 = class_2350.field_11036;
                yield class_2350.field_11035;
            }
        };
        class_2350 opp1 = dir1.method_10153();
        class_2350 opp2 = dir2.method_10153();
        queue.add(pos);
        while ((newPos = (class_2338)queue.poll()) != null) {
            set.add(newPos);
            class_2680 state2 = level.method_8320(newPos);
            if (state2 != state) continue;
            level.method_8652(newPos, newState, 18);
            class_2338 pos2 = newPos.method_10093(dir1);
            if (!set.contains(pos2)) {
                queue.add(pos2);
            }
            if (!set.contains(pos2 = newPos.method_10093(opp1))) {
                queue.add(pos2);
            }
            if (!set.contains(pos2 = newPos.method_10093(dir2))) {
                queue.add(pos2);
            }
            if (set.contains(pos2 = newPos.method_10093(opp2))) continue;
            queue.add(pos2);
        }
        if (!level.field_9236) {
            level.method_8396(null, pos, PORTAL_CHANGE_COLOR_SOUND, class_3419.field_15245, 0.44f, new Random().nextFloat() * 0.4f + 0.8f);
            PlayerHelper.getPlayersInRange(level, pos, 4.0).forEach(player -> ColoredNetherPortals.triggerColoredPortal((class_3222)player));
        }
    }

    public static void triggerColoredPortal(class_3222 player) {
        CharmAdvancements.ACTION_PERFORMED.trigger(player, TRIGGER_COLORED_PORTAL);
    }

    static {
        TRIGGER_COLORED_PORTAL = new class_2960("charm", "colored_portal");
    }
}

