/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.coral_squids;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1480;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2230;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import svenhjol.charm.helper.LogHelper;
import svenhjol.charm.helper.NbtHelper;
import svenhjol.charm.helper.PlayerHelper;
import svenhjol.charm.module.coral_squids.CoralSquids;

public class CoralSquidEntity
extends class_1480 {
    public static final String CORAL_SQUID_TYPE_NBT = "CoralSquidType";
    public static final String CORAL_SQUID_FROM_BUCKET_NBT = "FromBucket";
    private static final class_2940<Boolean> FROM_BUCKET;
    private static final class_2940<Integer> CORAL_SQUID_TYPE;
    public static final Map<Integer, class_2960> TEXTURES;
    public static final Map<Integer, class_1792> DROPS;
    public float xBodyRot;
    public float xBodyRot0;
    public float zBodyRot;
    public float zBodyRot0;
    public float tentacleMovement;
    public float oldTentacleMovement;
    public float tentacleAngle;
    public float oldTentacleAndle;
    private float speed;
    private float tentacleSpeed;
    private float rotateSpeed;
    private float swimX;
    private float swimY;
    private float swimZ;

    public CoralSquidEntity(class_1299<? extends CoralSquidEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.field_5974.setSeed(this.method_5628());
        this.tentacleSpeed = 1.0f / (this.field_5974.nextFloat() + 1.0f) * 0.2f;
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        entityData = super.method_5943(level, difficulty, spawnReason, entityData, entityTag);
        this.setCoralSquidType(this.field_5974.nextInt(5));
        return entityData;
    }

    public static boolean canSpawn(class_1299<CoralSquidEntity> type, class_1936 level, class_3730 spawnReason, class_2338 pos, Random random) {
        boolean canSpawn;
        class_2338 downPos;
        class_2680 downState;
        boolean coralBelow = false;
        for (int y = 0; y > -16 && !(coralBelow = (downState = level.method_8320(downPos = pos.method_10069(0, y, 0))).method_26204() instanceof class_2230); --y) {
        }
        boolean bl = canSpawn = pos.method_10264() > 20 && pos.method_10264() < level.method_8615() && coralBelow;
        if (canSpawn) {
            LogHelper.debug(CoralSquidEntity.class, "Can spawn coral squid at pos: " + pos, new Object[0]);
        }
        return canSpawn;
    }

    public int method_5945() {
        return 4;
    }

    public class_2960 getTexture() {
        return TEXTURES.getOrDefault(this.getCoralSquidType(), TEXTURES.get(0));
    }

    public int getCoralSquidType() {
        return (Integer)this.field_6011.method_12789(CORAL_SQUID_TYPE);
    }

    public void setCoralSquidType(int type) {
        if (type < 0 || type > 4) {
            type = this.field_5974.nextInt(5);
        }
        this.field_6011.method_12778(CORAL_SQUID_TYPE, (Object)type);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CORAL_SQUID_TYPE, (Object)1);
        this.field_6011.method_12784(FROM_BUCKET, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569(CORAL_SQUID_TYPE_NBT, this.getCoralSquidType());
        nbt.method_10556(CORAL_SQUID_FROM_BUCKET_NBT, this.isFromBucket());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setCoralSquidType(nbt.method_10550(CORAL_SQUID_TYPE_NBT));
        this.setFromBucket(nbt.method_10577(CORAL_SQUID_FROM_BUCKET_NBT));
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SquidRandomMovementGoal(this));
        this.field_6201.method_6277(1, (class_1352)new SquidFleeGoal());
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        super.method_6099(source, lootingMultiplier, allowDrops);
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1657 && (double)this.field_5974.nextFloat() < CoralSquids.dropChance) {
            this.method_5706((class_1935)DROPS.get(this.getCoralSquidType()));
        }
    }

    public static class_5132.class_5133 createSquidAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 5.0);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.8f;
    }

    protected class_3414 method_5994() {
        return class_3417.field_15034;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15212;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15124;
    }

    protected float method_6107() {
        return 0.4f;
    }

    public float method_6017() {
        return 1.25f;
    }

    public void method_6007() {
        super.method_6007();
        this.xBodyRot0 = this.xBodyRot;
        this.zBodyRot0 = this.zBodyRot;
        this.oldTentacleMovement = this.tentacleMovement;
        this.oldTentacleAndle = this.tentacleAngle;
        this.tentacleMovement += this.tentacleSpeed;
        if ((double)this.tentacleMovement > Math.PI * 2) {
            if (this.field_6002.field_9236) {
                this.tentacleMovement = (float)Math.PI * 2;
            } else {
                this.tentacleMovement = (float)((double)this.tentacleMovement - Math.PI * 2);
                if (this.field_5974.nextInt(10) == 0) {
                    this.tentacleSpeed = 1.0f / (this.field_5974.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_6002.method_8421((class_1297)this, (byte)19);
            }
        }
        if (this.method_5816()) {
            if (this.tentacleMovement < (float)Math.PI) {
                float f = this.tentacleMovement / (float)Math.PI;
                this.tentacleAngle = class_3532.method_15374((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.speed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.speed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.field_6002.field_9236) {
                this.method_18800(this.swimX * this.speed, this.swimY * this.speed, this.swimZ * this.speed);
            }
            class_243 vec3d = this.method_18798();
            double d = vec3d.method_37267();
            this.field_6283 += (-((float)class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350)) * 57.295776f - this.field_6283) * 0.1f;
            this.method_36456(this.field_6283);
            this.zBodyRot = (float)((double)this.zBodyRot + Math.PI * (double)this.rotateSpeed * 1.5);
            this.xBodyRot += (-((float)class_3532.method_15349((double)d, (double)vec3d.field_1351)) * 57.295776f - this.xBodyRot) * 0.1f;
        } else {
            this.tentacleAngle = class_3532.method_15379((float)class_3532.method_15374((float)this.tentacleMovement)) * (float)Math.PI * 0.25f;
            if (!this.field_6002.field_9236) {
                double d = this.method_18798().field_1351;
                if (this.method_6059(class_1294.field_5902)) {
                    d = 0.05 * (double)(this.method_6112(class_1294.field_5902).method_5578() + 1);
                } else if (!this.method_5740()) {
                    d -= 0.08;
                }
                this.method_18800(0.0, d * 0.981, 0.0);
            }
            this.xBodyRot = (float)((double)this.xBodyRot + (double)(-90.0f - this.xBodyRot) * 0.02);
        }
    }

    public void method_6091(class_243 movementInput) {
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte status) {
        if (status == 19) {
            this.tentacleMovement = 0.0f;
        } else {
            super.method_5711(status);
        }
    }

    public void setMovementVector(float x, float y, float z) {
        this.swimX = x;
        this.swimY = y;
        this.swimZ = z;
    }

    public boolean hasMovementVector() {
        return this.swimX != 0.0f || this.swimY != 0.0f || this.swimZ != 0.0f;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 held = player.method_5998(hand);
        if (held.method_7909() == class_1802.field_8705 && this.method_5805()) {
            this.method_5783(class_3417.field_14568, 1.0f, 1.0f);
            held.method_7934(1);
            class_1799 coralSquidBucket = new class_1799((class_1935)CoralSquids.CORAL_SQUID_BUCKET);
            class_2487 nbt = new class_2487();
            NbtHelper.setCompound(coralSquidBucket, "stored_coral_squid", this.method_5647(nbt));
            if (this.method_16914()) {
                coralSquidBucket.method_7977(this.method_5797());
            }
            if (!this.field_6002.field_9236) {
                class_174.field_1208.method_8932((class_3222)player, coralSquidBucket);
            }
            PlayerHelper.addOrDropStack(player, coralSquidBucket);
            this.method_31472();
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        return super.method_5992(player, hand);
    }

    private boolean isFromBucket() {
        return (Boolean)this.field_6011.method_12789(FROM_BUCKET);
    }

    public void setFromBucket(boolean fromBucket) {
        this.field_6011.method_12778(FROM_BUCKET, (Object)fromBucket);
    }

    public boolean method_17326() {
        return super.method_17326() || this.isFromBucket();
    }

    public boolean method_5974(double distanceSquared) {
        return !this.isFromBucket() && !this.method_16914();
    }

    static {
        CORAL_SQUID_TYPE = class_2945.method_12791(CoralSquidEntity.class, (class_2941)class_2943.field_13327);
        FROM_BUCKET = class_2945.method_12791(CoralSquidEntity.class, (class_2941)class_2943.field_13323);
        TEXTURES = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
            map.put(0, new class_2960("charm", "textures/entity/coral_squid/tube.png"));
            map.put(1, new class_2960("charm", "textures/entity/coral_squid/brain.png"));
            map.put(2, new class_2960("charm", "textures/entity/coral_squid/bubble.png"));
            map.put(3, new class_2960("charm", "textures/entity/coral_squid/fire.png"));
            map.put(4, new class_2960("charm", "textures/entity/coral_squid/horn.png"));
        });
        DROPS = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
            map.put(0, class_1802.field_8847);
            map.put(1, class_1802.field_8616);
            map.put(2, class_1802.field_8538);
            map.put(3, class_1802.field_8546);
            map.put(4, class_1802.field_8723);
        });
    }

    private static class SquidRandomMovementGoal
    extends class_1352 {
        private final CoralSquidEntity squid;

        public SquidRandomMovementGoal(CoralSquidEntity squid) {
            this.squid = squid;
        }

        public boolean method_6264() {
            return true;
        }

        public void method_6268() {
            int i = this.squid.method_6131();
            if (i > 100) {
                this.squid.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.squid.method_6051().nextInt(30) == 0 || !this.squid.field_5957 || !this.squid.hasMovementVector()) {
                float f = this.squid.method_6051().nextFloat() * ((float)Math.PI * 2);
                float g = class_3532.method_15362((float)f) * 0.2f;
                float h = -0.1f + this.squid.method_6051().nextFloat() * 0.05f;
                float j = class_3532.method_15374((float)f) * 0.2f;
                this.squid.setMovementVector(g, h, j);
            }
        }
    }

    class SquidFleeGoal
    extends class_1352 {
        private int timer;

        private SquidFleeGoal() {
        }

        public boolean method_6264() {
            class_1309 livingEntity = CoralSquidEntity.this.method_6065();
            if (CoralSquidEntity.this.method_5799() && livingEntity != null) {
                return CoralSquidEntity.this.method_5858((class_1297)livingEntity) < 100.0;
            }
            return false;
        }

        public void method_6269() {
            this.timer = 0;
        }

        public void method_6268() {
            ++this.timer;
            class_1309 livingEntity = CoralSquidEntity.this.method_6065();
            if (livingEntity != null) {
                class_243 vec3d = new class_243(CoralSquidEntity.this.method_23317() - livingEntity.method_23317(), CoralSquidEntity.this.method_23318() - livingEntity.method_23318(), CoralSquidEntity.this.method_23321() - livingEntity.method_23321());
                class_2680 blockState = CoralSquidEntity.this.field_6002.method_8320(new class_2338(CoralSquidEntity.this.method_23317() + vec3d.field_1352, CoralSquidEntity.this.method_23318() + vec3d.field_1351, CoralSquidEntity.this.method_23321() + vec3d.field_1350));
                class_3610 fluidState = CoralSquidEntity.this.field_6002.method_8316(new class_2338(CoralSquidEntity.this.method_23317() + vec3d.field_1352, CoralSquidEntity.this.method_23318() + vec3d.field_1351, CoralSquidEntity.this.method_23321() + vec3d.field_1350));
                if (fluidState.method_15767(class_3486.field_15517) || blockState.method_26215()) {
                    double d = vec3d.method_1033();
                    if (d > 0.0) {
                        vec3d.method_1029();
                        float f = 3.0f;
                        if (d > 5.0) {
                            f = (float)((double)f - (d - 5.0) / 5.0);
                        }
                        if (f > 0.0f) {
                            vec3d = vec3d.method_1021((double)f);
                        }
                    }
                    if (blockState.method_26215()) {
                        vec3d = vec3d.method_1023(0.0, vec3d.field_1351, 0.0);
                    }
                    CoralSquidEntity.this.setMovementVector((float)vec3d.field_1352 / 20.0f, (float)vec3d.field_1351 / 20.0f, (float)vec3d.field_1350 / 20.0f);
                }
                if (this.timer % 10 == 5) {
                    CoralSquidEntity.this.field_6002.method_8406((class_2394)class_2398.field_11247, CoralSquidEntity.this.method_23317(), CoralSquidEntity.this.method_23318(), CoralSquidEntity.this.method_23321(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

