/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.coral_squids;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.mixin.object.builder.SpawnRestrictionAccessor;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_4048;
import net.minecraft.class_5321;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.helper.BiomeHelper;
import svenhjol.charm.helper.MobHelper;
import svenhjol.charm.item.CharmSpawnEggItem;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.coral_squids.CoralSquidBucketItem;
import svenhjol.charm.module.coral_squids.CoralSquidEntity;
import svenhjol.charm.registry.CommonRegistry;

@CommonModule(mod="charm", description="Coral Squids spawn near coral in warm oceans.")
public class CoralSquids
extends CharmModule {
    public static class_2960 ID = new class_2960("charm", "coral_squid");
    public static CoralSquidBucketItem CORAL_SQUID_BUCKET;
    public static class_1299<CoralSquidEntity> CORAL_SQUID;
    public static class_1792 SPAWN_EGG;
    @Config(name="Drop chance", description="Chance (out of 1.0) of a coral squid dropping coral when killed by the player.")
    public static double dropChance;
    @Config(name="Spawn weight", description="Chance of coral squids spawning in warm ocean biomes.")
    public static int spawnWeight;

    @Override
    public void register() {
        CORAL_SQUID = CommonRegistry.entity(ID, FabricEntityTypeBuilder.create((class_1311)class_1311.field_24460, CoralSquidEntity::new).dimensions(class_4048.method_18385((float)0.54f, (float)0.54f)));
        SpawnRestrictionAccessor.callRegister(CORAL_SQUID, (class_1317.class_1319)class_1317.class_1319.field_6318, (class_2902.class_2903)class_2902.class_2903.field_13203, CoralSquidEntity::canSpawn);
        SPAWN_EGG = new CharmSpawnEggItem(this, "coral_squid_spawn_egg", CORAL_SQUID, 255, 0xFF00FF);
        MobHelper.setEntityAttributes(CORAL_SQUID, CoralSquidEntity.createSquidAttributes());
        CORAL_SQUID_BUCKET = new CoralSquidBucketItem(this);
    }

    @Override
    public void runWhenEnabled() {
        ArrayList<class_5321> biomes = new ArrayList<class_5321>(List.of(class_1972.field_9408));
        biomes.forEach(biomeKey -> BiomeHelper.addSpawnEntry((class_5321<class_1959>)biomeKey, class_1311.field_24460, CORAL_SQUID, spawnWeight, 2, 4));
    }

    static {
        dropChance = 0.2;
        spawnWeight = 50;
    }
}

