/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.extract_enchantments;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import svenhjol.charm.Charm;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.api.event.GrindstoneEvents;
import svenhjol.charm.helper.ModHelper;
import svenhjol.charm.init.CharmAdvancements;
import svenhjol.charm.loader.CharmModule;

@CommonModule(mod="charm", description="Extract enchantments from any enchanted item into an empty book using the grindstone.\nThe player must pay a cost (in xp levels) to extract enchantments from the item.")
public class ExtractEnchantments
extends CharmModule {
    public static final class_2960 TRIGGER_EXTRACTED_ENCHANTMENT = new class_2960("charm", "extracted_enchantment");
    @Config(name="Initial cost", description="Initial cost (in xp levels) of extraction before adding on the cost of the enchantment(s).")
    public static int initialCost = 5;
    @Config(name="Treasure cost", description="Adds extra cost (in xp levels) if the enchantment is a 'treasure' enchantment such as Mending.")
    public static int treasureCost = 5;
    @Config(name="Add item repair cost", description="If true, the item's repair cost will be added to the cost of extraction.")
    public static boolean addRepairCost = true;

    @Override
    public void register() {
        this.addDependencyCheck(module -> !ModHelper.isLoaded("grindenchantments"));
    }

    @Override
    public void runWhenEnabled() {
        GrindstoneEvents.ON_TAKE.register(this::handleOnTake);
        GrindstoneEvents.CALCULATE_OUTPUT.register(this::handleCalculateOutput);
        GrindstoneEvents.CAN_TAKE.register(this::handleCanTake);
        GrindstoneEvents.CAN_PLACE.register(this::handleCanPlace);
    }

    private boolean handleCanPlace(class_1263 container, class_1799 stack) {
        return Charm.LOADER.isEnabled(ExtractEnchantments.class) && stack.method_7909() == class_1802.field_8529;
    }

    private class_1269 handleCanTake(GrindstoneEvents.GrindstoneMenuInstance instance, class_1657 player) {
        if (!Charm.LOADER.isEnabled(ExtractEnchantments.class)) {
            return class_1269.field_5811;
        }
        List<class_1799> stacks = ExtractEnchantments.getStacksFromInventory(instance.output);
        if (ExtractEnchantments.shouldExtract(stacks)) {
            int cost = ExtractEnchantments.getEnchantedItemFromStacks(stacks).map(ExtractEnchantments::getCost).orElse(0);
            if (ExtractEnchantments.hasEnoughXp(player, cost)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private boolean handleCalculateOutput(GrindstoneEvents.GrindstoneMenuInstance instance) {
        if (!Charm.LOADER.isEnabled(ExtractEnchantments.class)) {
            return false;
        }
        class_1799 out = ExtractEnchantments.tryGetEnchantedBook(instance.input, instance.player);
        if (out == null) {
            return false;
        }
        instance.output.method_5447(0, out);
        return true;
    }

    private boolean handleOnTake(GrindstoneEvents.GrindstoneMenuInstance instance, class_1657 player, class_1799 stack) {
        if (!Charm.LOADER.isEnabled(ExtractEnchantments.class)) {
            return false;
        }
        class_1799 out = ExtractEnchantments.tryGetEnchantedBook(instance.input, player);
        if (out == null) {
            return false;
        }
        instance.access.method_17393((level, pos) -> {
            if (out.method_7909() instanceof class_1772) {
                if (!player.method_31549().field_7477) {
                    int cost = ExtractEnchantments.getCost(stack);
                    player.method_7316(-cost);
                }
                if (!level.field_9236) {
                    ExtractEnchantments.triggerExtractedEnchantment((class_3222)player);
                }
            }
            level.method_20290(1042, pos, 0);
        });
        class_1799 slot0 = instance.input.method_5438(0);
        class_1799 slot1 = instance.input.method_5438(1);
        if (slot0.method_7947() > 1) {
            slot0.method_7934(1);
        } else if (slot1.method_7947() > 1) {
            slot1.method_7934(1);
        }
        if (slot0.method_7947() <= 1) {
            instance.input.method_5447(0, class_1799.field_8037);
        }
        if (slot1.method_7947() <= 1) {
            instance.input.method_5447(1, class_1799.field_8037);
        }
        instance.menu.method_7623();
        return true;
    }

    @Nullable
    private static class_1799 tryGetEnchantedBook(class_1263 inputs, @Nullable class_1657 player) {
        List<class_1799> stacks = ExtractEnchantments.getStacksFromInventory(inputs);
        if (!ExtractEnchantments.shouldExtract(stacks)) {
            return null;
        }
        Optional<class_1799> enchanted = ExtractEnchantments.getEnchantedItemFromStacks(stacks);
        if (enchanted.isEmpty()) {
            return null;
        }
        class_1799 in = enchanted.get();
        if (player != null && !ExtractEnchantments.hasEnoughXp(player, ExtractEnchantments.getCost(in))) {
            return null;
        }
        class_1799 out = new class_1799((class_1935)class_1802.field_8598);
        Map enchantments = class_1890.method_8222((class_1799)in);
        enchantments.forEach((e, level) -> class_1772.method_7807((class_1799)out, (class_1889)new class_1889(e, level.intValue())));
        return out;
    }

    public static List<class_1799> getStacksFromInventory(class_1263 inventory) {
        return Arrays.asList(inventory.method_5438(0), inventory.method_5438(1));
    }

    public static Optional<class_1799> getEnchantedItemFromStacks(List<class_1799> stacks) {
        return stacks.stream().filter(class_1799::method_7942).findFirst();
    }

    public static boolean shouldExtract(List<class_1799> stacks) {
        return ExtractEnchantments.getEnchantedItemFromStacks(stacks).isPresent() && stacks.stream().anyMatch(i -> i.method_7909() == class_1802.field_8529);
    }

    public static boolean hasEnoughXp(class_1657 player, int cost) {
        return player.method_31549().field_7477 || player.field_7520 >= cost;
    }

    public static int getCost(class_1799 stack) {
        int cost = initialCost;
        Map enchantments = class_1890.method_8222((class_1799)stack);
        for (Map.Entry entry : enchantments.entrySet()) {
            class_1887 ench = (class_1887)entry.getKey();
            if (ench == null) {
                return 0;
            }
            int level = (Integer)entry.getValue();
            if (level > 0 && ench.method_25949()) {
                cost += level;
            }
            if (!ench.method_8193()) continue;
            cost += treasureCost;
        }
        if (addRepairCost && stack.method_7969() != null && !stack.method_7969().method_33133()) {
            cost += stack.method_7969().method_10550("RepairCost");
        }
        return cost;
    }

    public static void triggerExtractedEnchantment(class_3222 player) {
        CharmAdvancements.ACTION_PERFORMED.trigger(player, TRIGGER_EXTRACTED_ENCHANTMENT);
    }
}

