/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.improved_mineshafts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1694;
import net.minecraft.class_1695;
import net.minecraft.class_1696;
import net.minecraft.class_1701;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2443;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3098;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3353;
import net.minecraft.class_3443;
import net.minecraft.class_3749;
import net.minecraft.class_39;
import net.minecraft.class_47;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.server.MinecraftServer;
import svenhjol.charm.Charm;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.helper.ItemHelper;
import svenhjol.charm.loader.CharmModule;

@CommonModule(mod="charm", description="Adds decoration and more ores to mineshafts.")
public class ImprovedMineshafts
extends CharmModule {
    public static List<class_2960> MINECART_LOOT_TABLES = new ArrayList<class_2960>();
    public static List<class_2680> FLOOR_BLOCKS = new ArrayList<class_2680>();
    public static List<class_2680> CEILING_BLOCKS = new ArrayList<class_2680>();
    public static List<class_2680> PILE_BLOCKS = new ArrayList<class_2680>();
    public static List<class_2680> ROOM_BLOCKS = new ArrayList<class_2680>();
    public static List<class_2680> ROOM_DECORATIONS = new ArrayList<class_2680>();
    public static class_2960 FLOOR_BLOCK_LOOT;
    public static class_2960 PILE_BLOCK_LOOT;
    public static class_2960 CEILING_BLOCK_LOOT;
    public static class_2960 ROOM_BLOCK_LOOT;
    public static class_2960 ROOM_DECORATION_LOOT;
    @Config(name="Corridor floor blocks", description="Chance (out of 1.0) of blocks such as candles and ores spawning on the floor of corridors.")
    public static double floorBlockChance;
    @Config(name="Corridor ceiling blocks", description="Chance (out of 1.0) of blocks such as lanterns spawning on the ceiling of corridors.")
    public static double ceilingBlockChance;
    @Config(name="Corridor block piles", description="Chance (out of 1.0) of stone, gravel and ore spawning at the entrance of corridors.")
    public static double blockPileChance;
    @Config(name="Room blocks", description="Chance (out of 1.0) for a moss or precious ore block to spawn on a single block of the central mineshaft room.")
    public static double roomBlockChance;
    @Config(name="Extra minecarts", description="Chance (out of 1.0) for a minecart to spawn in a corridor. Minecart loot is chosen from the 'Minecart loot tables'.")
    public static double minecartChance;
    @Config(name="Minecart loot tables", description="If 'Add minecarts' is enabled, minecarts have a chance to be filled with loot from these loot tables.")
    public static List<String> configMinecartLootTables;

    @Override
    public void runWhenEnabled() {
        ServerWorldEvents.LOAD.register(this::handleWorldLoad);
        configMinecartLootTables.forEach(tableId -> MINECART_LOOT_TABLES.add(new class_2960(tableId)));
    }

    private void handleWorldLoad(MinecraftServer server, class_3218 level) {
        if (level.method_27983() == class_1937.field_25179) {
            class_47.class_48 builder = new class_47.class_48(level);
            FLOOR_BLOCKS.addAll(this.parseLootTable(server, builder, FLOOR_BLOCK_LOOT));
            PILE_BLOCKS.addAll(this.parseLootTable(server, builder, PILE_BLOCK_LOOT));
            CEILING_BLOCKS.addAll(this.parseLootTable(server, builder, CEILING_BLOCK_LOOT));
            ROOM_BLOCKS.addAll(this.parseLootTable(server, builder, ROOM_BLOCK_LOOT));
            ROOM_DECORATIONS.addAll(this.parseLootTable(server, builder, ROOM_DECORATION_LOOT));
        }
    }

    private List<class_2680> parseLootTable(MinecraftServer server, class_47.class_48 builder, class_2960 lootTable) {
        List items = server.method_3857().method_367(lootTable).method_319(builder.method_309(class_173.field_1175));
        ArrayList<class_2680> states = new ArrayList<class_2680>();
        for (class_1799 stack : items) {
            class_2680 state = ItemHelper.getBlockStateFromItemStack(stack);
            states.add(state);
        }
        return states;
    }

    public static void generatePiece(class_3443 piece, class_5281 level, class_5138 accessor, class_2794 chunkGenerator, Random rand, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        if (!Charm.LOADER.isEnabled(ImprovedMineshafts.class) && ((class_3353.class_3356)piece).field_14421 == class_3098.class_3100.field_13691) {
            return;
        }
        if (piece instanceof class_3353.class_3354) {
            ImprovedMineshafts.corridor((class_3353.class_3354)piece, level, accessor, chunkGenerator, rand, box, chunkPos, blockPos);
        } else if (piece instanceof class_3353.class_3357) {
            ImprovedMineshafts.room((class_3353.class_3357)piece, level, accessor, chunkGenerator, rand, box, chunkPos, blockPos);
        }
    }

    private static void corridor(class_3353.class_3354 piece, class_5281 level, class_5138 accessor, class_2794 chunkGenerator, Random rand, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        int z;
        if (floorBlockChance > 0.0 || ceilingBlockChance > 0.0) {
            for (int x = 0; x < 3; ++x) {
                if (x == 1 && rand.nextFloat() < 0.08f) continue;
                for (int z2 = 0; z2 < 7; ++z2) {
                    class_2680 state;
                    boolean validCeiling = piece.method_14719((class_1922)level, box, x, x, 2, z2);
                    boolean validFloor = ImprovedMineshafts.validFloorBlock((class_3443)piece, level, x, 0, z2, box);
                    if (!validCeiling) continue;
                    if (validFloor && !FLOOR_BLOCKS.isEmpty() && (double)rand.nextFloat() < floorBlockChance && piece.method_36422(level, box, x, 0, z2, 2)) {
                        state = ImprovedMineshafts.getRandom(FLOOR_BLOCKS, rand);
                        piece.method_14917(level, state, x, 0, z2, box);
                        continue;
                    }
                    if (CEILING_BLOCKS.isEmpty() || !((double)rand.nextFloat() < ceilingBlockChance) || !piece.method_36422(level, box, x, 2, z2, 2)) continue;
                    state = ImprovedMineshafts.getRandom(CEILING_BLOCKS, rand);
                    if (state.method_26204() == class_2246.field_23985) {
                        piece.method_14917(level, (class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.valueOf(true)), x, 1, z2, box);
                    }
                    piece.method_14917(level, state, x, 2, z2, box);
                }
            }
        }
        if (PILE_BLOCKS.size() > 0 && (double)rand.nextFloat() < blockPileChance && ImprovedMineshafts.validFloorBlock((class_3443)piece, level, 1, 0, z = rand.nextInt(7), box)) {
            class_2680 state1 = ImprovedMineshafts.getRandom(PILE_BLOCKS, rand);
            class_2680 state2 = ImprovedMineshafts.getRandom(PILE_BLOCKS, rand);
            for (int iy = 0; iy < 3; ++iy) {
                for (int ix = 0; ix <= 2; ++ix) {
                    for (int iz = -1; iz <= 1; ++iz) {
                        boolean valid = ImprovedMineshafts.validFloorBlock((class_3443)piece, level, ix, iy, iz, box);
                        if (!valid || !(rand.nextFloat() < 0.7f)) continue;
                        class_2680 useState = rand.nextBoolean() ? state1 : state2;
                        piece.method_14917(level, useState, ix, iy, iz, box);
                    }
                }
            }
        }
        if (!MINECART_LOOT_TABLES.isEmpty() && (double)rand.nextFloat() < minecartChance) {
            int y = piece.method_14924(0);
            int x = piece.method_14928(1, 0);
            int z3 = piece.method_14941(1, 0);
            class_2338 cartPos = new class_2338(x, y, z3);
            class_2960 loot = MINECART_LOOT_TABLES.get(rand.nextInt(MINECART_LOOT_TABLES.size()));
            if (box.method_14662((class_2382)cartPos) && level.method_8320(cartPos).method_26215() && !level.method_8320(cartPos.method_10074()).method_26215()) {
                Object minecart;
                class_2680 blockState = (class_2680)class_2246.field_10167.method_9564().method_11657((class_2769)class_2443.field_11369, (Comparable)(rand.nextBoolean() ? class_2768.field_12665 : class_2768.field_12674));
                piece.method_14917(level, blockState, x, y, z3, box);
                class_3218 serverWorld = level.method_8410();
                double cartX = (double)cartPos.method_10263() + 0.5;
                double cartY = (double)cartPos.method_10264() + 0.5;
                double cartZ = (double)cartPos.method_10260() + 0.5;
                if (rand.nextFloat() < 0.4f) {
                    minecart = new class_1694((class_1937)serverWorld, cartX, cartY, cartZ);
                    minecart.method_7562(loot, rand.nextLong());
                } else {
                    minecart = rand.nextFloat() < 0.4f ? new class_1701((class_1937)serverWorld, cartX, cartY, cartZ) : (rand.nextFloat() < 0.4f ? new class_1696((class_1937)serverWorld, cartX, cartY, cartZ) : new class_1695((class_1937)serverWorld, cartX, cartY, cartZ));
                }
                level.method_8649((class_1297)minecart);
            }
        }
    }

    private static void room(class_3353.class_3357 piece, class_5281 level, class_5138 accessor, class_2794 chunkGenerator, Random rand, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        if (!ROOM_BLOCKS.isEmpty() && !ROOM_DECORATIONS.isEmpty()) {
            int bx = box.method_35418() - box.method_35415();
            int bz = box.method_35420() - box.method_35417();
            if (bx <= 0) {
                bx = 15;
            }
            if (bz <= 0) {
                bz = 15;
            }
            for (int y = 1; y <= 2; ++y) {
                for (int x = 0; x <= bx; ++x) {
                    for (int z = 0; z <= bz; ++z) {
                        class_2680 state;
                        if (!((double)rand.nextFloat() < roomBlockChance)) continue;
                        if (y == 1) {
                            state = rand.nextFloat() < 0.5f ? ImprovedMineshafts.getRandom(ROOM_BLOCKS, rand) : ImprovedMineshafts.getRandom(ROOM_DECORATIONS, rand);
                        } else {
                            if (rand.nextFloat() < 0.5f) continue;
                            state = ImprovedMineshafts.getRandom(ROOM_BLOCKS, rand);
                        }
                        class_2338 pos = new class_2338(piece.method_14935().method_35415() + x, piece.method_14935().method_35416() + y, piece.method_14935().method_35417() + z);
                        if (!level.method_22347(pos) || !level.method_8320(pos.method_10074()).method_26234((class_1922)level, pos.method_10074()) || level.method_22348(pos)) continue;
                        level.method_8652(pos, state, 11);
                    }
                }
            }
        }
    }

    private static boolean validFloorBlock(class_3443 piece, class_5281 level, int x, int y, int z, class_3341 box) {
        class_2338 blockpos = new class_2338(piece.method_14928(x, z), piece.method_14924(y), piece.method_14941(x, z));
        boolean vecInside = box.method_14662((class_2382)blockpos);
        boolean solidBelow = level.method_8320(blockpos.method_10074()).method_26225();
        boolean notSlabBelow = !(level.method_8320(blockpos.method_10074()).method_26204() instanceof class_2482);
        boolean airAbove = level.method_22347(blockpos.method_10084());
        return vecInside && solidBelow && notSlabBelow && airAbove;
    }

    private static class_2680 getRandom(List<class_2680> blocks, Random rand) {
        if (blocks.isEmpty()) {
            return class_2246.field_10124.method_9564();
        }
        return blocks.get(rand.nextInt(blocks.size()));
    }

    static {
        floorBlockChance = 0.03;
        ceilingBlockChance = 0.02;
        blockPileChance = 0.2;
        roomBlockChance = 0.25;
        minecartChance = 0.2;
        configMinecartLootTables = Arrays.asList(class_39.field_356.method_12832(), class_39.field_472.method_12832(), class_39.field_17109.method_12832(), class_39.field_16751.method_12832(), class_39.field_17010.method_12832(), class_39.field_17107.method_12832(), class_39.field_434.method_12832());
        FLOOR_BLOCK_LOOT = new class_2960("charm", "improved_mineshafts/floor_blocks");
        PILE_BLOCK_LOOT = new class_2960("charm", "improved_mineshafts/pile_blocks");
        CEILING_BLOCK_LOOT = new class_2960("charm", "improved_mineshafts/ceiling_blocks");
        ROOM_BLOCK_LOOT = new class_2960("charm", "improved_mineshafts/room_blocks");
        ROOM_DECORATION_LOOT = new class_2960("charm", "improved_mineshafts/room_decorations");
    }
}

