/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.mooblooms;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1430;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1830;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5147;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import org.apache.commons.lang3.tuple.Pair;
import svenhjol.charm.module.mooblooms.MoobloomPlantFlowerGoal;
import svenhjol.charm.module.mooblooms.Mooblooms;

public class MoobloomEntity
extends class_1430
implements class_5147 {
    private static final String TYPE_NBT = "Type";
    private static final String POLLINATED_NBT = "Pollinated";
    private static final class_2940<String> TYPE;
    private static final class_2940<Boolean> POLLINATED;
    public static Map<Type, class_2960> TEXTURES;

    public MoobloomEntity(class_1299<? extends class_1430> entityType, class_1937 level) {
        super(entityType, level);
        TEXTURES = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
            for (Type type : Type.values()) {
                map.put(type, new class_2960("charm", "textures/entity/moobloom/" + type.name + ".png"));
            }
        });
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        entityData = super.method_5943(level, difficulty, spawnReason, entityData, entityTag);
        List<Type> types = Arrays.asList(Type.values());
        Type type = types.get(this.field_5974.nextInt(types.size()));
        this.setMoobloomType(type);
        return entityData;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TYPE, (Object)Type.ALLIUM.name());
        this.field_6011.method_12784(POLLINATED, (Object)false);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(3, (class_1352)new MoobloomPlantFlowerGoal(this));
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 held = player.method_5998(hand);
        if (held.method_7909() == class_1802.field_8428 && !this.method_6109()) {
            if (!this.field_6002.field_9236 && this.isPollinated()) {
                class_1799 stew;
                Optional<Pair<class_1291, Integer>> optionalFlower = this.getEffectFromFlower(this.getMoobloomType().flower);
                if (optionalFlower.isPresent()) {
                    Pair<class_1291, Integer> effectFromFlower = optionalFlower.get();
                    class_1291 effect = (class_1291)effectFromFlower.getLeft();
                    int duration = (Integer)effectFromFlower.getRight() * 2;
                    stew = new class_1799((class_1935)class_1802.field_8766);
                    this.method_5783(class_3417.field_18269, 1.0f, 1.0f);
                    class_1830.method_8021((class_1799)stew, (class_1291)effect, (int)duration);
                } else {
                    stew = new class_1799((class_1935)class_1802.field_8208);
                    this.method_5783(class_3417.field_18268, 1.0f, 1.0f);
                }
                class_1799 out = class_5328.method_30270((class_1799)held, (class_1657)player, (class_1799)stew, (boolean)false);
                player.method_6122(hand, out);
                this.field_6011.method_12778(POLLINATED, (Object)false);
                Mooblooms.triggerMilkedMoobloom((class_3222)player);
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (held.method_7909() == class_1802.field_8868 && this.method_27072()) {
            this.method_6636(class_3419.field_15248);
            if (!this.field_6002.field_9236) {
                held.method_7956(1, (class_1309)player, playerEntity -> playerEntity.method_20236(hand));
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        return super.method_5992(player, hand);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10582(TYPE_NBT, this.getMoobloomType().name);
        tag.method_10556(POLLINATED_NBT, ((Boolean)this.field_6011.method_12789(POLLINATED)).booleanValue());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setMoobloomType(Type.fromName(tag.method_10558(TYPE_NBT)));
        if (tag.method_10545(POLLINATED_NBT)) {
            this.field_6011.method_12778(POLLINATED, (Object)tag.method_10577(POLLINATED_NBT));
        }
    }

    public MoobloomEntity getBreedOffspring(class_3218 level, class_1296 mob) {
        MoobloomEntity entity = (MoobloomEntity)Mooblooms.MOOBLOOM.method_5883((class_1937)level);
        Type childType = level.field_9229.nextFloat() < 0.5f ? this.getMoobloomType() : ((MoobloomEntity)mob).getMoobloomType();
        entity.setMoobloomType(childType);
        return entity;
    }

    public void pollinate() {
        this.field_6002.method_8396(null, this.method_24515(), class_3417.field_20607, class_3419.field_15254, 1.0f, 1.0f);
        this.field_6011.method_12778(POLLINATED, (Object)true);
    }

    public boolean isPollinated() {
        return (Boolean)this.field_6011.method_12789(POLLINATED);
    }

    public Type getMoobloomType() {
        return Type.fromName((String)this.field_6011.method_12789(TYPE));
    }

    public void setMoobloomType(Type type) {
        this.field_6011.method_12778(TYPE, (Object)type.name);
    }

    public class_2960 getMoobloomTexture() {
        return TEXTURES.getOrDefault((Object)this.getMoobloomType(), TEXTURES.get((Object)Type.ALLIUM));
    }

    public Optional<Pair<class_1291, Integer>> getEffectFromFlower(class_2680 flower) {
        class_2248 block = flower.method_26204();
        if (block instanceof class_2356) {
            class_2356 flowerBlock = (class_2356)block;
            return Optional.of(Pair.of((Object)flowerBlock.method_10188(), (Object)flowerBlock.method_10187()));
        }
        return Optional.empty();
    }

    public static boolean canSpawn(class_1299<MoobloomEntity> type, class_1936 level, class_3730 spawnReason, class_2338 pos, Random random) {
        return level.method_22335(pos, 0) > 8;
    }

    public void method_6636(class_3419 shearedSoundCategory) {
        this.field_6002.method_8449(null, (class_1297)this, class_3417.field_14705, shearedSoundCategory, 1.0f, 1.0f);
        if (!this.field_6002.field_9236) {
            ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_11236, this.method_23317(), this.method_23323(0.5), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
            this.method_31472();
            class_1430 cowEntity = (class_1430)class_1299.field_6085.method_5883(this.field_6002);
            cowEntity.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
            cowEntity.method_6033(this.method_6032());
            cowEntity.field_6283 = this.field_6283;
            if (this.method_16914()) {
                cowEntity.method_5665(this.method_5797());
                cowEntity.method_5880(this.method_5807());
            }
            if (this.method_5947()) {
                cowEntity.method_5971();
            }
            cowEntity.method_5684(this.method_5655());
            this.field_6002.method_8649((class_1297)cowEntity);
            for (int i = 0; i < 5; ++i) {
                this.field_6002.method_8649((class_1297)new class_1542(this.field_6002, this.method_23317(), this.method_23323(1.0), this.method_23321(), new class_1799((class_1935)this.getMoobloomType().flower.method_26204())));
            }
        }
    }

    public boolean method_27072() {
        return this.method_5805() && !this.method_6109();
    }

    static {
        TEXTURES = new HashMap<Type, class_2960>();
        TYPE = class_2945.method_12791(MoobloomEntity.class, (class_2941)class_2943.field_13326);
        POLLINATED = class_2945.method_12791(MoobloomEntity.class, (class_2941)class_2943.field_13323);
    }

    public static enum Type {
        ALLIUM("allium", class_2246.field_10226.method_9564()),
        AZURE_BLUET("azure_bluet", class_2246.field_10573.method_9564()),
        BLUE_ORCHID("blue_orchid", class_2246.field_10086.method_9564()),
        CORNFLOWER("cornflower", class_2246.field_9995.method_9564()),
        DANDELION("dandelion", class_2246.field_10182.method_9564()),
        LILY_OF_THE_VALLEY("lily_of_the_valley", class_2246.field_10548.method_9564()),
        ORANGE_TULIP("orange_tulip", class_2246.field_10048.method_9564()),
        PINK_TULIP("pink_tulip", class_2246.field_10315.method_9564()),
        RED_TULIP("red_tulip", class_2246.field_10270.method_9564()),
        WHITE_TULIP("white_tulip", class_2246.field_10156.method_9564()),
        OXEYE_DAISY("oxeye_daisy", class_2246.field_10554.method_9564()),
        POPPY("poppy", class_2246.field_10449.method_9564());

        private final String name;
        private final class_2680 flower;

        private Type(String name, class_2680 flower) {
            this.name = name;
            this.flower = flower;
        }

        public class_2680 getFlower() {
            return this.flower;
        }

        private static Type fromName(String name) {
            Type[] values;
            for (Type value : values = Type.values()) {
                if (!value.name.equals(name)) continue;
                return value;
            }
            return ALLIUM;
        }
    }
}

