/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.mooblooms;

import java.util.ArrayList;
import java.util.Collections;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.mixin.object.builder.SpawnRestrictionAccessor;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1352;
import net.minecraft.class_1430;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4048;
import net.minecraft.class_4466;
import net.minecraft.class_5321;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.api.event.AddEntityCallback;
import svenhjol.charm.helper.BiomeHelper;
import svenhjol.charm.helper.MobHelper;
import svenhjol.charm.init.CharmAdvancements;
import svenhjol.charm.item.CharmSpawnEggItem;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.mooblooms.BeeMoveToMoobloomGoal;
import svenhjol.charm.module.mooblooms.MoobloomEntity;
import svenhjol.charm.registry.CommonRegistry;

@CommonModule(mod="charm", description="Mooblooms are cow-like mobs that come in a variety of flower types.\nThey spawn flowers where they walk and can be milked for suspicious stew.")
public class Mooblooms
extends CharmModule {
    public static final class_2960 ID = new class_2960("charm", "moobloom");
    public static final class_2960 TRIGGER_MILKED_MOOBLOOM = new class_2960("charm", "milked_moobloom");
    public static class_1299<MoobloomEntity> MOOBLOOM;
    public static class_1792 SPAWN_EGG;

    @Override
    public void register() {
        MOOBLOOM = CommonRegistry.entity(ID, FabricEntityTypeBuilder.create((class_1311)class_1311.field_6294, MoobloomEntity::new).dimensions(class_4048.method_18385((float)0.9f, (float)1.4f)).trackRangeBlocks(10));
        SpawnRestrictionAccessor.callRegister(MOOBLOOM, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, MoobloomEntity::canSpawn);
        SPAWN_EGG = new CharmSpawnEggItem(this, "moobloom_spawn_egg", MOOBLOOM, 0xFFFF00, 0xFFFFFF);
        MobHelper.setEntityAttributes(MOOBLOOM, class_1430.method_26883());
    }

    @Override
    public void runWhenEnabled() {
        AddEntityCallback.EVENT.register(this::tryAddGoalsToBee);
        ArrayList<class_5321> biomes = new ArrayList<class_5321>(Collections.singletonList(class_1972.field_9414));
        biomes.forEach(biomeKey -> BiomeHelper.addSpawnEntry((class_5321<class_1959>)biomeKey, class_1311.field_6294, MOOBLOOM, 30, 2, 4));
    }

    private class_1269 tryAddGoalsToBee(class_1297 entity) {
        class_4466 bee;
        if (entity instanceof class_4466 && (bee = (class_4466)entity).method_35163().method_35115().stream().noneMatch(g -> g.method_19058() instanceof BeeMoveToMoobloomGoal)) {
            bee.method_35163().method_6277(4, (class_1352)new BeeMoveToMoobloomGoal(bee));
        }
        return class_1269.field_5811;
    }

    public static void triggerMilkedMoobloom(class_3222 player) {
        CharmAdvancements.ACTION_PERFORMED.trigger(player, TRIGGER_MILKED_MOOBLOOM);
    }
}

