/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.quick_replant;

import com.mojang.brigadier.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.init.CharmAdvancements;
import svenhjol.charm.loader.CharmModule;

@CommonModule(mod="charm", description="Right-click with a hoe to quickly harvest and replant a fully-grown crop.")
public class QuickReplant
extends CharmModule {
    public static final class_2960 TRIGGER_REPLANTED_CROPS = new class_2960("charm", "replanted_crops");
    private static final List<class_2680> REPLANTABLE = new ArrayList<class_2680>();
    @Config(name="Replantable blockstates", description="List of blockstate definitions for replantable crops.")
    public static List<String> configBlockStateDefinitions = Arrays.asList("minecraft:beetroots[age=3]", "minecraft:carrots[age=7]", "minecraft:nether_wart[age=3]", "minecraft:potatoes[age=7]", "minecraft:wheat[age=7]");

    @Override
    public void runWhenEnabled() {
        for (String definition : configBlockStateDefinitions) {
            QuickReplant.tryAddReplantable(definition);
        }
        UseBlockCallback.EVENT.register(this::tryHarvest);
    }

    public class_1269 tryHarvest(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        class_1799 mainhand = player.method_6047();
        class_1799 offhand = player.method_6079();
        Object held = mainhand.method_7909() instanceof class_1794 ? mainhand : (offhand.method_7909() instanceof class_1794 ? offhand : null);
        if (held != null) {
            class_2338 pos = hitResult.method_17777();
            class_2680 state = level.method_8320(pos);
            class_2248 block = state.method_26204();
            if (!REPLANTABLE.contains(state)) {
                return class_1269.field_5811;
            }
            class_1792 blockItem = block.method_8389();
            class_2680 newState = block.method_9564();
            if (!level.field_9236) {
                class_3222 serverPlayer = (class_3222)player;
                class_3218 serverLevel = (class_3218)serverPlayer.field_6002;
                List drops = class_2248.method_9609((class_2680)state, (class_3218)serverLevel, (class_2338)pos, null, (class_1297)player, (class_1799)class_1799.field_8037);
                for (class_1799 drop : drops) {
                    if (drop.method_7909() == blockItem) {
                        drop.method_7934(1);
                    }
                    if (drop.method_7960()) continue;
                    class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)drop);
                }
                level.method_8474(2001, pos, class_2248.method_9507((class_2680)newState));
                level.method_8501(pos, newState);
                level.method_8396(null, pos, class_3417.field_17610, class_3419.field_15245, 1.0f, 1.0f);
                QuickReplant.triggerReplantedCrops(serverPlayer);
                held.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
                return class_1269.field_21466;
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static void tryAddReplantable(String blockState) {
        class_2680 state;
        try {
            class_2259 parser = new class_2259(new StringReader(blockState), false).method_9678(false);
            state = parser.method_9669();
        }
        catch (Exception e) {
            state = null;
        }
        if (state != null) {
            REPLANTABLE.add(state);
        }
    }

    public static void triggerReplantedCrops(class_3222 player) {
        CharmAdvancements.ACTION_PERFORMED.trigger(player, TRIGGER_REPLANTED_CROPS);
    }
}

