/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.snow_accumulation;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2488;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import svenhjol.charm.Charm;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.loader.CharmModule;

@CommonModule(mod="charm", description="Increases snow layers when snowing in cold biomes")
public class SnowAccumulation
extends CharmModule {
    public static final List<class_2248> BLOCK_BLACKLIST;
    @Config(name="Allow block replace", description="If true, placing a block on a non-full snow block will replace the snow block.\nIf false, use vanilla behavior (only a snow block with a single layer will allow block replacement).")
    public static boolean allowBlockReplace;
    @Config(name="Powder snow chance", description="Chance (out of 1.0) of a fully accumulated snow block being converted to powder snow.")
    public static double convertToPowderSnow;

    public static boolean shouldAccumulateSnow(class_3218 level) {
        return Charm.LOADER.isEnabled(SnowAccumulation.class) && level.method_8419();
    }

    public static void tryPlaceSnow(class_3218 level, int chunkX, int chunkZ) {
        if (!SnowAccumulation.shouldAccumulateSnow(level)) {
            return;
        }
        if (level.field_9229.nextInt(750) == 0) {
            class_2338 pos = level.method_8598(class_2902.class_2903.field_13197, level.method_8536(chunkX, 0, chunkZ, 15));
            class_2338 belowPos = pos.method_10074();
            class_2680 belowState = level.method_8320(belowPos);
            class_1959 biome = (class_1959)level.method_23753(pos).comp_349();
            if (biome.method_8707(pos) < 0.15f && pos.method_10264() >= level.method_31607() && pos.method_10264() < level.method_31600()) {
                class_2680 state = level.method_8320(pos);
                class_2248 block = state.method_26204();
                class_2248 belowBlock = belowState.method_26204();
                if (state.method_26215() && !BLOCK_BLACKLIST.contains(belowBlock) && class_2248.method_9501((class_265)belowState.method_26220((class_1922)level, belowPos), (class_2350)class_2350.field_11036)) {
                    level.method_8501(pos, class_2246.field_10477.method_9564());
                    return;
                }
                if (block == class_2246.field_10477) {
                    if (belowState.method_26204() == class_2246.field_10491 || belowState.method_26204() == class_2246.field_27879) {
                        return;
                    }
                    int layers = (Integer)state.method_11654((class_2769)class_2488.field_11518);
                    state = layers < 8 ? (class_2680)state.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(++layers)) : (level.field_9229.nextDouble() < convertToPowderSnow ? class_2246.field_27879.method_9564() : class_2246.field_10491.method_9564());
                    level.method_8501(pos, state);
                }
            }
        }
    }

    static {
        allowBlockReplace = true;
        convertToPowderSnow = 0.01;
        BLOCK_BLACKLIST = Arrays.asList(class_2246.field_10295, class_2246.field_10225, class_2246.field_10499, class_2246.field_21211, class_2246.field_10114, class_2246.field_10477, class_2246.field_10491, class_2246.field_27879);
    }
}

