/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.totem_of_preserving;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.fabric.api.loot.v1.FabricLootPoolBuilder;
import net.fabricmc.fabric.api.loot.v1.FabricLootSupplierBuilder;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_44;
import net.minecraft.class_5335;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_60;
import net.minecraft.class_77;
import net.minecraft.class_79;
import svenhjol.charm.Charm;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.api.event.EntityDropXpCallback;
import svenhjol.charm.api.event.PlayerDropInventoryCallback;
import svenhjol.charm.api.event.TotemOfPreservingEvents;
import svenhjol.charm.helper.ItemHelper;
import svenhjol.charm.helper.LogHelper;
import svenhjol.charm.init.CharmAdvancements;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.totem_of_preserving.TotemOfPreservingChestLootFunction;
import svenhjol.charm.module.totem_of_preserving.TotemOfPreservingItem;
import svenhjol.charm.module.totem_of_preserving.TotemOfPreservingMobLootFunction;
import svenhjol.charm.module.totem_works_from_inventory.TotemWorksFromInventory;
import svenhjol.charm.registry.CommonRegistry;

@CommonModule(mod="charm", description="The player's inventory items will be held in the Totem of Preserving upon death.\nBy default, a new totem will always be spawned to hold items upon dying in Easy or Peaceful mode ('Grave mode').\nIn Normal and Hard mode, the player must be holding an empty Totem of Preserving in order for it to hold items upon death.")
public class TotemOfPreserving
extends CharmModule {
    public static TotemOfPreservingItem TOTEM_OF_PRESERVING;
    public static class_5339 CHEST_LOOT_FUNCTION;
    public static class_5339 MOB_LOOT_FUNCTION;
    public static final class_2960 CHEST_LOOT_ID;
    public static final class_2960 MOB_LOOT_ID;
    public static final class_2960 TRIGGER_USED_TOTEM_OF_PRESERVING;
    public static final List<class_1267> GRAVE_MODE_DIFFICULTIES;
    public static final List<class_2960> VALID_MOB_LOOT;
    public static final List<class_2960> VALID_CHEST_LOOT;
    @Config(name="Grave mode game difficulties", description="A list of game difficulties in which totems will behave in 'Grave mode'.\nIn Grave mode, a totem will be dropped on death even if the player doesn't have an empty totem in their inventory.")
    public static List<String> configGraveModeDifficulties;
    @Config(name="Mobs drop totems", description="Mobs that have a chance to drop a totem of preserving.\nThis does not apply if Grave mode is active for the current game difficulty. See 'Grave mode game difficulties' to configure this.")
    public static List<String> configMobDrops;
    @Config(name="Chests contain totems", description="Chest loot tables that will always contain a totem of preserving.\nThis does not apply if Grave mode is active for the current game difficulty. See 'Grave mode game difficulties' to configure this.")
    public static List<String> configChestLoot;
    @Config(name="Preserve XP", description="If true, the totem will preserve the player's experience and restore when broken.")
    public static boolean preserveXp;
    @Config(name="Show death position", description="If true, the coordinates where you died will be added to the player's chat screen.")
    public static boolean showDeathPosition;

    @Override
    public void register() {
        TOTEM_OF_PRESERVING = new TotemOfPreservingItem(this);
        configGraveModeDifficulties.stream().map(String::toLowerCase).map(class_1267::method_16691).filter(Objects::nonNull).forEach(GRAVE_MODE_DIFFICULTIES::add);
        configMobDrops.stream().map(class_2960::new).forEach(VALID_MOB_LOOT::add);
        configChestLoot.stream().map(class_2960::new).forEach(VALID_CHEST_LOOT::add);
    }

    @Override
    public void runWhenEnabled() {
        ItemHelper.ITEM_LIFETIME.put(TOTEM_OF_PRESERVING, Integer.MAX_VALUE);
        CHEST_LOOT_FUNCTION = CommonRegistry.lootFunctionType(CHEST_LOOT_ID, new class_5339((class_5335)new TotemOfPreservingChestLootFunction.Serializer()));
        MOB_LOOT_FUNCTION = CommonRegistry.lootFunctionType(MOB_LOOT_ID, new class_5339((class_5335)new TotemOfPreservingMobLootFunction.Serializer()));
        PlayerDropInventoryCallback.EVENT.register(this::handleDropInventory);
        EntityDropXpCallback.BEFORE.register(this::handleDropXp);
        LootTableLoadingCallback.EVENT.register(this::handleLootTables);
    }

    private void handleLootTables(class_3300 manager, class_60 lootTables, class_2960 id, FabricLootSupplierBuilder supplier, LootTableLoadingCallback.LootTableSetter setter) {
        if (VALID_MOB_LOOT.contains(id) || VALID_CHEST_LOOT.contains(id)) {
            FabricLootPoolBuilder builder = FabricLootPoolBuilder.builder().rolls((class_5658)class_44.method_32448((float)1.0f)).with((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8162).method_437(1).method_438(() -> {
                if (VALID_CHEST_LOOT.contains(id)) {
                    return new TotemOfPreservingChestLootFunction(new class_5341[0]);
                }
                return new TotemOfPreservingMobLootFunction(new class_5341[0]);
            }));
            supplier.method_336((class_55.class_56)builder);
        }
    }

    public class_1269 handleDropXp(class_1309 entity) {
        if (!preserveXp || !(entity instanceof class_1657) || entity.field_6002.field_9236) {
            return class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    public class_1269 handleDropInventory(class_1657 player, class_1661 inventory) {
        double z;
        double y;
        double x;
        if (player.field_6002.field_9236) {
            return class_1269.field_5811;
        }
        class_3218 serverLevel = (class_3218)player.field_6002;
        class_3222 serverPlayer = (class_3222)player;
        Random random = serverLevel.method_8409();
        class_1799 totem = new class_1799((class_1935)TOTEM_OF_PRESERVING);
        class_2487 serialized = new class_2487();
        ArrayList holdable = new ArrayList();
        ArrayList<class_1799> totemsToSpawn = new ArrayList<class_1799>();
        ImmutableList combinedInventory = ImmutableList.of((Object)inventory.field_7547, (Object)inventory.field_7548, (Object)inventory.field_7544);
        combinedInventory.forEach(list -> list.stream().filter(Objects::nonNull).filter(stack -> !stack.method_7960()).forEach(holdable::add));
        boolean totemWorksFromInventory = Charm.LOADER.isEnabled(TotemWorksFromInventory.class);
        boolean graveMode = TotemOfPreserving.isGraveMode(player.field_6002.method_8407());
        boolean foundEmptyTotem = false;
        if (!graveMode && !totemWorksFromInventory) {
            boolean holding = false;
            for (class_1268 hand : class_1268.values()) {
                class_1799 held = player.method_5998(hand);
                if (held.method_7909() != TOTEM_OF_PRESERVING || TotemOfPreservingItem.hasItems(totem)) continue;
                holding = true;
                break;
            }
            if (!holding) {
                LogHelper.debug(this.getClass(), "No empty totem in hands and (graveMode = false && totemWorksFromInventory = false), skipping", new Object[0]);
                return class_1269.field_5811;
            }
        }
        for (int i = 0; i < holdable.size(); ++i) {
            class_1269 result;
            class_1799 stack = (class_1799)holdable.get(i);
            if (stack.method_7909() == TOTEM_OF_PRESERVING) {
                if (!TotemOfPreservingItem.getItems(stack).method_33133()) {
                    LogHelper.debug(this.getClass(), "A filled totem was found, spawning this separately", new Object[0]);
                    totemsToSpawn.add(stack);
                    continue;
                }
                if (!graveMode && !foundEmptyTotem) {
                    LogHelper.debug(this.getClass(), "An empty totem was found and (graveMode = false), going to try and add items to this totem", new Object[0]);
                    foundEmptyTotem = true;
                    continue;
                }
            }
            if ((result = ((TotemOfPreservingEvents.BeforeAddStackInvoker)TotemOfPreservingEvents.BEFORE_ADD_STACK.invoker()).invoke(serverPlayer, stack)) == class_1269.field_5814) continue;
            serialized.method_10566(Integer.toString(i), (class_2520)((class_1799)holdable.get(i)).method_7953(new class_2487()));
        }
        if (graveMode || foundEmptyTotem) {
            if (preserveXp) {
                int xp = serverPlayer.field_7495;
                LogHelper.debug(this.getClass(), "Preserving player XP in totem: " + xp, new Object[0]);
                TotemOfPreservingItem.setXp(totem, xp);
            }
            TotemOfPreservingItem.setItems(totem, serialized);
            TotemOfPreservingItem.setMessage(totem, serverPlayer.method_5820());
            if (!TotemOfPreservingItem.getItems(totem).method_33133()) {
                LogHelper.debug(this.getClass(), "Inventory has items so they will be saved in the totem", new Object[0]);
                totemsToSpawn.add(totem);
            }
        }
        if (totemsToSpawn.isEmpty()) {
            LogHelper.debug(this.getClass(), "No totems to spawn, skipping", new Object[0]);
            return class_1269.field_5811;
        }
        class_2338 playerPos = serverPlayer.method_24515();
        class_1297 vehicle = serverPlayer.method_5854();
        if (vehicle != null) {
            x = vehicle.method_23317() + 0.25;
            y = vehicle.method_23318() + 0.75;
            z = vehicle.method_23321() + 0.25;
        } else {
            x = (double)playerPos.method_10263() + 0.25;
            y = (double)playerPos.method_10264() + 0.75;
            z = (double)playerPos.method_10260() + 0.25;
        }
        if (y < (double)serverLevel.method_31607()) {
            y = serverLevel.method_8615();
        }
        for (class_1799 stack : totemsToSpawn) {
            double tx = x + (double)random.nextFloat() * 0.25;
            double ty = y + 0.25;
            double tz = z + (double)random.nextFloat() * 0.25;
            class_1269 result = ((TotemOfPreservingEvents.BeforeCreateInvoker)TotemOfPreservingEvents.BEFORE_CREATE.invoker()).invoke(serverPlayer, new class_2338(tx, ty, tz), stack);
            if (result == class_1269.field_5814) continue;
            class_1542 totemEntity = new class_1542((class_1937)serverLevel, x, y, z, stack);
            totemEntity.method_5875(true);
            totemEntity.method_18800(0.0, 0.0, 0.0);
            totemEntity.method_23327(tx, ty, tz);
            totemEntity.method_6976();
            totemEntity.method_5834(true);
            totemEntity.method_5684(true);
            serverLevel.method_8649((class_1297)totemEntity);
            ((TotemOfPreservingEvents.AfterCreateInvoker)TotemOfPreservingEvents.AFTER_CREATE.invoker()).invoke(serverPlayer, totemEntity.method_24515(), stack);
        }
        class_2338 deathPos = new class_2338(x, y, z);
        TotemOfPreserving.triggerUsedTotemOfPreserving((class_3222)player);
        LogHelper.info(this.getClass(), "Spawned a totem at pos: " + deathPos, new Object[0]);
        for (class_2371 inv : combinedInventory) {
            for (int i = 0; i < inv.size(); ++i) {
                inv.set(i, (Object)class_1799.field_8037);
            }
        }
        if (showDeathPosition) {
            player.method_7353((class_2561)new class_2588("gui.charm.totem_of_preserving.deathpos", new Object[]{x, y, z}), false);
        }
        return class_1269.field_5812;
    }

    public static boolean isGraveMode(class_1267 difficulty) {
        return GRAVE_MODE_DIFFICULTIES.contains(difficulty);
    }

    public static void triggerUsedTotemOfPreserving(class_3222 player) {
        CharmAdvancements.ACTION_PERFORMED.trigger(player, TRIGGER_USED_TOTEM_OF_PRESERVING);
    }

    static {
        CHEST_LOOT_ID = new class_2960("charm", "totem_of_preserving_chest_loot");
        MOB_LOOT_ID = new class_2960("charm", "totem_of_preserving_mob_loot");
        TRIGGER_USED_TOTEM_OF_PRESERVING = new class_2960("charm", "used_totem_of_preserving");
        GRAVE_MODE_DIFFICULTIES = new ArrayList<class_1267>();
        VALID_MOB_LOOT = new ArrayList<class_2960>();
        VALID_CHEST_LOOT = new ArrayList<class_2960>();
        configGraveModeDifficulties = Arrays.asList("peaceful", "easy", "normal", "hard");
        configMobDrops = Arrays.asList("entities/witch", "entities/pillager");
        configChestLoot = Arrays.asList("chests/pillager_outpost", "chests/woodland_mansion");
        preserveXp = false;
        showDeathPosition = false;
    }
}

