/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.totem_of_preserving;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import svenhjol.charm.helper.LogHelper;
import svenhjol.charm.helper.NbtHelper;
import svenhjol.charm.helper.TotemHelper;
import svenhjol.charm.item.CharmItem;
import svenhjol.charm.loader.CharmModule;

public class TotemOfPreservingItem
extends CharmItem {
    public static final String MESSAGE_TAG = "message";
    public static final String ITEMS_TAG = "items";
    public static final String XP_TAG = "xp";

    public TotemOfPreservingItem(CharmModule module) {
        super(module, "totem_of_preserving", new class_1792.class_1793().method_7892(class_1761.field_7932).method_7894(class_1814.field_8907).method_24359().method_7889(1));
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public boolean method_7886(class_1799 stack) {
        return TotemOfPreservingItem.hasItems(stack);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 user, class_1268 hand) {
        class_1799 totem = user.method_5998(hand);
        if (!TotemOfPreservingItem.hasItems(totem)) {
            return class_1271.method_22430((Object)totem);
        }
        class_2487 items = TotemOfPreservingItem.getItems(totem);
        int xp = TotemOfPreservingItem.getXp(totem);
        if (xp > 0) {
            level.method_8396(null, user.method_24515(), class_3417.field_14709, class_3419.field_15248, 0.8f, 1.0f);
            user.method_7255(xp);
        }
        TotemHelper.destroy(user, totem);
        if (!level.field_9236) {
            Set keys = items.method_10541();
            keys.forEach(k -> {
                class_2520 tag = items.method_10580(k);
                if (tag == null) {
                    LogHelper.warn(this.getClass(), "Item tag missing from totem", new Object[0]);
                } else {
                    class_1799 stack = class_1799.method_7915((class_2487)((class_2487)tag));
                    class_2338 pos = user.method_24515();
                    class_1542 itemEntity = new class_1542(level, (double)pos.method_10263(), (double)pos.method_10264() + 0.5, (double)pos.method_10260(), stack);
                    level.method_8649((class_1297)itemEntity);
                }
            });
        }
        return super.method_7836(level, user, hand);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 context) {
        String message = TotemOfPreservingItem.getMessage(stack);
        class_2487 items = TotemOfPreservingItem.getItems(stack);
        if (!message.isEmpty()) {
            tooltip.add((class_2561)new class_2585(message));
        }
        if (!items.method_33133()) {
            int size = items.method_10546();
            String str = size == 1 ? "totem.charm.preserving.item" : "totem.charm.preserving.items";
            tooltip.add((class_2561)new class_2585(class_1074.method_4662((String)str, (Object[])new Object[]{size})));
        }
        super.method_7851(stack, level, tooltip, context);
    }

    public static void setMessage(class_1799 totem, String message) {
        NbtHelper.setString(totem, MESSAGE_TAG, message);
    }

    public static void setItems(class_1799 totem, class_2487 items) {
        NbtHelper.setCompound(totem, ITEMS_TAG, items);
    }

    public static void setXp(class_1799 totem, int xp) {
        NbtHelper.setInt(totem, XP_TAG, xp);
    }

    public static String getMessage(class_1799 totem) {
        return NbtHelper.getString(totem, MESSAGE_TAG, "");
    }

    public static class_2487 getItems(class_1799 totem) {
        return NbtHelper.getCompound(totem, ITEMS_TAG);
    }

    public static boolean hasItems(class_1799 totem) {
        return !TotemOfPreservingItem.getItems(totem).method_33133();
    }

    public static int getXp(class_1799 totem) {
        return NbtHelper.getInt(totem, XP_TAG, 0);
    }
}

