/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.variant_bars;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.block.CharmBarsBlock;
import svenhjol.charm.enums.IMetalMaterial;
import svenhjol.charm.enums.VanillaMetalMaterial;
import svenhjol.charm.loader.CharmModule;

@CommonModule(mod="charm", description="Variant bars crafted from vanilla metal ingots.")
public class VariantBars
extends CharmModule {
    public static Map<IMetalMaterial, List<CharmBarsBlock>> BARS = new HashMap<IMetalMaterial, List<CharmBarsBlock>>();

    @Override
    public void register() {
        for (IMetalMaterial material : VanillaMetalMaterial.getTypesWithout(VanillaMetalMaterial.IRON)) {
            VariantBars.registerBars(this, material, material.method_15434() + "_bars");
        }
    }

    public static CharmBarsBlock registerBars(CharmModule module, IMetalMaterial material, String name) {
        CharmBarsBlock bars = new CharmBarsBlock(module, name, material);
        BARS.computeIfAbsent(material, a -> new ArrayList());
        BARS.get(material).add(bars);
        return bars;
    }
}

