/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.variant_chests;

import java.util.Set;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.minecraft.class_1059;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2745;
import net.minecraft.class_2960;
import svenhjol.charm.annotation.ClientModule;
import svenhjol.charm.api.event.RenderBlockItemCallback;
import svenhjol.charm.api.event.StitchTextureCallback;
import svenhjol.charm.enums.IWoodMaterial;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.variant_chests.VariantChestBlock;
import svenhjol.charm.module.variant_chests.VariantChestBlockEntity;
import svenhjol.charm.module.variant_chests.VariantChestBlockEntityRenderer;
import svenhjol.charm.module.variant_chests.VariantChests;
import svenhjol.charm.module.variant_chests.VariantTrappedChestBlock;
import svenhjol.charm.module.variant_chests.VariantTrappedChestBlockEntity;

@ClientModule(module=VariantChests.class)
public class VariantChestsClient
extends CharmModule {
    private final VariantChestBlockEntity CACHED_NORMAL_CHEST = new VariantChestBlockEntity(class_2338.field_10980, class_2246.field_10034.method_9564());
    private final VariantTrappedChestBlockEntity CACHED_TRAPPED_CHEST = new VariantTrappedChestBlockEntity(class_2338.field_10980, class_2246.field_10380.method_9564());

    @Override
    public void register() {
        BlockEntityRendererRegistry.register(VariantChests.NORMAL_BLOCK_ENTITY, VariantChestBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register(VariantChests.TRAPPED_BLOCK_ENTITY, VariantChestBlockEntityRenderer::new);
        StitchTextureCallback.EVENT.register(this::handleTextureStitch);
        RenderBlockItemCallback.EVENT.register(this::handleBlockItemRender);
    }

    private void handleTextureStitch(class_1059 atlas, Set<class_2960> textures) {
        if (atlas.method_24106().toString().equals("minecraft:textures/atlas/chest.png")) {
            VariantChests.NORMAL_CHEST_BLOCKS.keySet().forEach(type -> {
                this.addChestTexture(textures, (IWoodMaterial)type, class_2745.field_12574);
                this.addChestTexture(textures, (IWoodMaterial)type, class_2745.field_12571);
                this.addChestTexture(textures, (IWoodMaterial)type, class_2745.field_12569);
            });
        }
    }

    private class_2586 handleBlockItemRender(class_1799 stack, class_2248 block) {
        if (block instanceof VariantChestBlock) {
            VariantChestBlock chest = (VariantChestBlock)block;
            this.CACHED_NORMAL_CHEST.setMaterialType(chest.getMaterialType());
            return this.CACHED_NORMAL_CHEST;
        }
        if (block instanceof VariantTrappedChestBlock) {
            VariantTrappedChestBlock chest = (VariantTrappedChestBlock)block;
            this.CACHED_TRAPPED_CHEST.setMaterialType(chest.getMaterialType());
            return this.CACHED_TRAPPED_CHEST;
        }
        return null;
    }

    private void addChestTexture(Set<class_2960> textures, IWoodMaterial variant, class_2745 chestType) {
        String[] bases;
        String chestTypeName = chestType != class_2745.field_12569 ? "_" + chestType.method_15434().toLowerCase() : "";
        for (String base : bases = new String[]{"trapped", "normal"}) {
            class_2960 id = new class_2960(this.getModId(), "entity/chest/" + variant.method_15434() + "_" + base + chestTypeName);
            VariantChestBlockEntityRenderer.addTexture(variant, chestType, id, base.equals("trapped"));
            textures.add(id);
        }
    }
}

