/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.wandering_trader_maps;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_20;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.class_3853;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.helper.MapHelper;
import svenhjol.charm.helper.StringHelper;
import svenhjol.charm.helper.VillagerHelper;
import svenhjol.charm.helper.WorldHelper;
import svenhjol.charm.loader.CharmModule;

@CommonModule(mod="charm", description="Wandering traders have a chance to sell maps to distant structures.")
public class WanderingTraderMaps
extends CharmModule {
    @Config(name="Structures", description="List of structure IDs and structure tags.")
    public static List<String> structures = Arrays.asList("#minecraft:village", "#minecraft:mineshaft", "minecraft:swamp_hut", "minecraft:igloo");
    @Config(name="Rare structures", description="List of rarer structure IDs and structure tags.\nThese are more expensive and less likely to be sold.")
    public static List<String> rareStructures = Arrays.asList("minecraft:desert_pyramid", "minecraft:jungle_temple", "#minecraft:ocean_ruin");

    @Override
    public void runWhenEnabled() {
        int i;
        for (i = 0; i < 3; ++i) {
            VillagerHelper.addWanderingTrade(new MapForEmeralds(), false);
        }
        for (i = 0; i < 3; ++i) {
            VillagerHelper.addWanderingTrade(new RareMapForEmeralds(), true);
        }
    }

    public static class_1799 makeTraderMap(String id, class_3218 level, class_2338 pos, int distance, int color) {
        class_2338 nearest = WorldHelper.findNearestMapFeature(id, level, pos, distance, true);
        if (nearest == null) {
            return new class_1799((class_1935)class_1802.field_8895);
        }
        String name = StringHelper.snakeToPretty(id.substring(id.indexOf(":") + 1), true);
        class_2588 mapName = new class_2588("filled_map.charm.trader_map", new Object[]{new class_2585(name)});
        return MapHelper.create(level, nearest, (class_2561)mapName, class_20.class_21.field_84, color);
    }

    static class MapForEmeralds
    implements class_3853.class_1652 {
        MapForEmeralds() {
        }

        public class_1914 method_7246(class_1297 trader, Random random) {
            Map map;
            class_1799 stack;
            if (!trader.field_6002.field_9236 && (stack = (map = new Map()).getMap((class_3218)trader.field_6002, trader.method_24515(), random)) != null) {
                class_1799 in1 = new class_1799((class_1935)class_1802.field_8687, map.getCost(random));
                class_1799 in2 = new class_1799((class_1935)class_1802.field_8251);
                return new class_1914(in1, in2, stack, 1, 5, 0.2f);
            }
            return null;
        }
    }

    static class RareMapForEmeralds
    implements class_3853.class_1652 {
        RareMapForEmeralds() {
        }

        public class_1914 method_7246(class_1297 trader, Random random) {
            RareMap map;
            class_1799 stack;
            if (!trader.field_6002.field_9236 && (stack = (map = new RareMap()).getMap((class_3218)trader.field_6002, trader.method_24515(), random)) != null) {
                class_1799 in1 = new class_1799((class_1935)class_1802.field_8687, map.getCost(random));
                class_1799 in2 = new class_1799((class_1935)class_1802.field_8251);
                return new class_1914(in1, in2, stack, 1, 5, 0.2f);
            }
            return null;
        }
    }

    static interface TraderMap {
        public class_1799 getMap(class_3218 var1, class_2338 var2, Random var3);

        public int getCost(Random var1);
    }

    static class RareMap
    implements TraderMap {
        RareMap() {
        }

        @Override
        public class_1799 getMap(class_3218 level, class_2338 pos, Random random) {
            int color = 0x99AA00;
            String id = rareStructures.get(random.nextInt(rareStructures.size()));
            return WanderingTraderMaps.makeTraderMap(id, level, pos, 500, color);
        }

        @Override
        public int getCost(Random random) {
            return random.nextInt(5) + 10;
        }
    }

    static class Map
    implements TraderMap {
        Map() {
        }

        @Override
        public class_1799 getMap(class_3218 level, class_2338 pos, Random random) {
            int color = 17510;
            String id = structures.get(random.nextInt(structures.size()));
            return WanderingTraderMaps.makeTraderMap(id, level, pos, 200, color);
        }

        @Override
        public int getCost(Random random) {
            return random.nextInt(2) + 2;
        }
    }
}

