/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.weathering_iron;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5953;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.helper.LogHelper;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.weathering_iron.IWaxableIron;
import svenhjol.charm.module.weathering_iron.IWeatherableIron;
import svenhjol.charm.module.weathering_iron.WaxedIronBlock;
import svenhjol.charm.module.weathering_iron.WaxedIronSlabBlock;
import svenhjol.charm.module.weathering_iron.WaxedIronStairBlock;
import svenhjol.charm.module.weathering_iron.WeatheringIronBlock;
import svenhjol.charm.module.weathering_iron.WeatheringIronSlabBlock;
import svenhjol.charm.module.weathering_iron.WeatheringIronStairBlock;

@CommonModule(mod="charm", description="Iron rusts when in contact with water.")
public class WeatheringIron
extends CharmModule {
    public static WeatheringIronBlock EXPOSED_IRON;
    public static WeatheringIronBlock WEATHERED_IRON;
    public static WeatheringIronBlock OXIDIZED_IRON;
    public static WeatheringIronBlock CUT_IRON;
    public static WeatheringIronBlock EXPOSED_CUT_IRON;
    public static WeatheringIronBlock WEATHERED_CUT_IRON;
    public static WeatheringIronBlock OXIDIZED_CUT_IRON;
    public static WeatheringIronSlabBlock CUT_IRON_SLAB;
    public static WeatheringIronSlabBlock EXPOSED_CUT_IRON_SLAB;
    public static WeatheringIronSlabBlock WEATHERED_CUT_IRON_SLAB;
    public static WeatheringIronSlabBlock OXIDIZED_CUT_IRON_SLAB;
    public static WeatheringIronStairBlock CUT_IRON_STAIRS;
    public static WeatheringIronStairBlock EXPOSED_CUT_IRON_STAIRS;
    public static WeatheringIronStairBlock WEATHERED_CUT_IRON_STAIRS;
    public static WeatheringIronStairBlock OXIDIZED_CUT_IRON_STAIRS;
    public static WaxedIronBlock WAXED_IRON_BLOCK;
    public static WaxedIronBlock WAXED_EXPOSED_IRON;
    public static WaxedIronBlock WAXED_WEATHERED_IRON;
    public static WaxedIronBlock WAXED_OXIDIZED_IRON;
    public static WaxedIronBlock WAXED_CUT_IRON;
    public static WaxedIronBlock WAXED_EXPOSED_CUT_IRON;
    public static WaxedIronBlock WAXED_WEATHERED_CUT_IRON;
    public static WaxedIronBlock WAXED_OXIDIZED_CUT_IRON;
    public static WaxedIronSlabBlock WAXED_CUT_IRON_SLAB;
    public static WaxedIronSlabBlock WAXED_EXPOSED_CUT_IRON_SLAB;
    public static WaxedIronSlabBlock WAXED_WEATHERED_CUT_IRON_SLAB;
    public static WaxedIronSlabBlock WAXED_OXIDIZED_CUT_IRON_SLAB;
    public static WaxedIronStairBlock WAXED_CUT_IRON_STAIRS;
    public static WaxedIronStairBlock WAXED_EXPOSED_CUT_IRON_STAIRS;
    public static WaxedIronStairBlock WAXED_WEATHERED_CUT_IRON_STAIRS;
    public static WaxedIronStairBlock WAXED_OXIDIZED_CUT_IRON_STAIRS;
    public static List<class_2248> WEATHERING_ORDER;
    public static BiMap<class_2248, class_2248> WAXABLES;
    @Config(name="Faces increase weathering", description="The chance of weathering increases according to the number of block faces touching water.")
    public static boolean facesIncreaseWeathering;
    @Config(name="Face multiplier", description="When more than one block face is touching water, weathering chance increases by this amount per face.")
    public static double faceMultiplier;
    @Config(name="Weathering chance", description="Chance (out of 1.0) of a block being considered for weathering.")
    public static double chance;
    @Config(name="Bubble column chance multiplier", description="When a block is above a bubble column, weathering chance is multiplied by this value.")
    public static double bubbleColumnMultiplier;

    @Override
    public void register() {
        EXPOSED_IRON = new WeatheringIronBlock(this, "exposed_iron");
        WEATHERED_IRON = new WeatheringIronBlock(this, "weathered_iron");
        OXIDIZED_IRON = new WeatheringIronBlock(this, "oxidized_iron").fullyOxidised();
        CUT_IRON = new WeatheringIronBlock(this, "cut_iron").noOxidisation();
        EXPOSED_CUT_IRON = new WeatheringIronBlock(this, "exposed_cut_iron");
        WEATHERED_CUT_IRON = new WeatheringIronBlock(this, "weathered_cut_iron");
        OXIDIZED_CUT_IRON = new WeatheringIronBlock(this, "oxidized_cut_iron").fullyOxidised();
        CUT_IRON_SLAB = new WeatheringIronSlabBlock((CharmModule)this, "cut_iron_slab", CUT_IRON).noOxidisation();
        EXPOSED_CUT_IRON_SLAB = new WeatheringIronSlabBlock((CharmModule)this, "exposed_cut_iron_slab", EXPOSED_CUT_IRON);
        WEATHERED_CUT_IRON_SLAB = new WeatheringIronSlabBlock((CharmModule)this, "weathered_cut_iron_slab", WEATHERED_CUT_IRON);
        OXIDIZED_CUT_IRON_SLAB = new WeatheringIronSlabBlock((CharmModule)this, "oxidized_cut_iron_slab", OXIDIZED_CUT_IRON).fullyOxidised();
        CUT_IRON_STAIRS = new WeatheringIronStairBlock(this, "cut_iron_stairs", CUT_IRON).noOxidisation();
        EXPOSED_CUT_IRON_STAIRS = new WeatheringIronStairBlock(this, "exposed_cut_iron_stairs", EXPOSED_IRON);
        WEATHERED_CUT_IRON_STAIRS = new WeatheringIronStairBlock(this, "weathered_cut_iron_stairs", WEATHERED_CUT_IRON);
        OXIDIZED_CUT_IRON_STAIRS = new WeatheringIronStairBlock(this, "oxidized_cut_iron_stairs", OXIDIZED_CUT_IRON).fullyOxidised();
        WAXED_IRON_BLOCK = new WaxedIronBlock((CharmModule)this, "waxed_iron_block", class_2246.field_10085);
        WAXED_EXPOSED_IRON = new WaxedIronBlock((CharmModule)this, "waxed_exposed_iron", EXPOSED_IRON);
        WAXED_WEATHERED_IRON = new WaxedIronBlock((CharmModule)this, "waxed_weathered_iron", WEATHERED_IRON);
        WAXED_OXIDIZED_IRON = new WaxedIronBlock((CharmModule)this, "waxed_oxidized_iron", OXIDIZED_IRON);
        WAXED_CUT_IRON = new WaxedIronBlock((CharmModule)this, "waxed_cut_iron", class_2246.field_10085);
        WAXED_EXPOSED_CUT_IRON = new WaxedIronBlock((CharmModule)this, "waxed_exposed_cut_iron", EXPOSED_IRON);
        WAXED_WEATHERED_CUT_IRON = new WaxedIronBlock((CharmModule)this, "waxed_weathered_cut_iron", WEATHERED_IRON);
        WAXED_OXIDIZED_CUT_IRON = new WaxedIronBlock((CharmModule)this, "waxed_oxidized_cut_iron", OXIDIZED_IRON);
        WAXED_CUT_IRON_SLAB = new WaxedIronSlabBlock((CharmModule)this, "waxed_cut_iron_slab", class_2246.field_10085);
        WAXED_EXPOSED_CUT_IRON_SLAB = new WaxedIronSlabBlock((CharmModule)this, "waxed_exposed_cut_iron_slab", EXPOSED_IRON);
        WAXED_WEATHERED_CUT_IRON_SLAB = new WaxedIronSlabBlock((CharmModule)this, "waxed_weathered_cut_iron_slab", WEATHERED_IRON);
        WAXED_OXIDIZED_CUT_IRON_SLAB = new WaxedIronSlabBlock((CharmModule)this, "waxed_oxidized_cut_iron_slab", OXIDIZED_IRON);
        WAXED_CUT_IRON_STAIRS = new WaxedIronStairBlock(this, "waxed_cut_iron_stairs", class_2246.field_10085);
        WAXED_EXPOSED_CUT_IRON_STAIRS = new WaxedIronStairBlock(this, "waxed_exposed_cut_iron_stairs", EXPOSED_IRON);
        WAXED_WEATHERED_CUT_IRON_STAIRS = new WaxedIronStairBlock(this, "waxed_weathered_cut_iron_stairs", WEATHERED_IRON);
        WAXED_OXIDIZED_CUT_IRON_STAIRS = new WaxedIronStairBlock(this, "waxed_oxidized_cut_iron_stairs", OXIDIZED_IRON);
        WEATHERING_ORDER.add(class_2246.field_10085);
        WEATHERING_ORDER.add(EXPOSED_IRON);
        WEATHERING_ORDER.add(WEATHERED_IRON);
        WEATHERING_ORDER.add(OXIDIZED_IRON);
        WEATHERING_ORDER.add(CUT_IRON);
        WEATHERING_ORDER.add(EXPOSED_CUT_IRON);
        WEATHERING_ORDER.add(WEATHERED_CUT_IRON);
        WEATHERING_ORDER.add(OXIDIZED_CUT_IRON);
        WEATHERING_ORDER.add((class_2248)CUT_IRON_SLAB);
        WEATHERING_ORDER.add((class_2248)EXPOSED_CUT_IRON_SLAB);
        WEATHERING_ORDER.add((class_2248)WEATHERED_CUT_IRON_SLAB);
        WEATHERING_ORDER.add((class_2248)OXIDIZED_CUT_IRON_SLAB);
        WEATHERING_ORDER.add((class_2248)CUT_IRON_STAIRS);
        WEATHERING_ORDER.add((class_2248)EXPOSED_CUT_IRON_STAIRS);
        WEATHERING_ORDER.add((class_2248)WEATHERED_CUT_IRON_STAIRS);
        WEATHERING_ORDER.add((class_2248)OXIDIZED_CUT_IRON_STAIRS);
        WAXABLES.put((Object)class_2246.field_10085, (Object)WAXED_IRON_BLOCK);
        WAXABLES.put((Object)EXPOSED_IRON, (Object)WAXED_EXPOSED_IRON);
        WAXABLES.put((Object)WEATHERED_IRON, (Object)WAXED_WEATHERED_IRON);
        WAXABLES.put((Object)OXIDIZED_IRON, (Object)WAXED_OXIDIZED_IRON);
        WAXABLES.put((Object)CUT_IRON, (Object)WAXED_CUT_IRON);
        WAXABLES.put((Object)EXPOSED_CUT_IRON, (Object)WAXED_EXPOSED_CUT_IRON);
        WAXABLES.put((Object)WEATHERED_CUT_IRON, (Object)WAXED_WEATHERED_CUT_IRON);
        WAXABLES.put((Object)OXIDIZED_CUT_IRON, (Object)WAXED_OXIDIZED_CUT_IRON);
        WAXABLES.put((Object)CUT_IRON_SLAB, (Object)WAXED_CUT_IRON_SLAB);
        WAXABLES.put((Object)EXPOSED_CUT_IRON_SLAB, (Object)WAXED_EXPOSED_CUT_IRON_SLAB);
        WAXABLES.put((Object)WEATHERED_CUT_IRON_SLAB, (Object)WAXED_WEATHERED_CUT_IRON_SLAB);
        WAXABLES.put((Object)OXIDIZED_CUT_IRON_SLAB, (Object)WAXED_OXIDIZED_CUT_IRON_SLAB);
        WAXABLES.put((Object)CUT_IRON_STAIRS, (Object)WAXED_CUT_IRON_STAIRS);
        WAXABLES.put((Object)EXPOSED_CUT_IRON_STAIRS, (Object)WAXED_EXPOSED_CUT_IRON_STAIRS);
        WAXABLES.put((Object)WEATHERED_CUT_IRON_STAIRS, (Object)WAXED_WEATHERED_CUT_IRON_STAIRS);
        WAXABLES.put((Object)OXIDIZED_CUT_IRON_STAIRS, (Object)WAXED_OXIDIZED_CUT_IRON_STAIRS);
    }

    @Override
    public void runWhenEnabled() {
        UseBlockCallback.EVENT.register(this::handleUseBlock);
    }

    private class_1269 handleUseBlock(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        class_1799 held = player.method_5998(hand);
        if (held.method_7960()) {
            return class_1269.field_5811;
        }
        class_1792 item = held.method_7909();
        class_2338 pos = hitResult.method_17777();
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        Optional<Object> newState = Optional.empty();
        if (item instanceof class_1743) {
            if (block instanceof IWeatherableIron) {
                IWeatherableIron iron = (IWeatherableIron)block;
                if (WEATHERING_ORDER.contains(iron) && iron.hasAnyOxidation()) {
                    int i = WEATHERING_ORDER.indexOf(block);
                    level.method_8396(player, pos, class_3417.field_29541, class_3419.field_15245, 1.0f, 1.0f);
                    level.method_8444(player, 3005, pos, 0);
                    newState = Optional.of(WEATHERING_ORDER.get(i - 1).method_9564());
                }
            } else if (block instanceof IWaxableIron) {
                IWaxableIron iron = (IWaxableIron)block;
                BiMap inverse = WAXABLES.inverse();
                if (inverse.containsKey((Object)iron)) {
                    level.method_8396(player, pos, class_3417.field_29542, class_3419.field_15245, 1.0f, 1.0f);
                    level.method_8444(player, 3004, pos, 0);
                    newState = Optional.of(((class_2248)inverse.get((Object)iron)).method_9564());
                }
            }
        } else if (item instanceof class_5953 && WAXABLES.containsKey((Object)block)) {
            level.method_8444(player, 3003, pos, 0);
            newState = Optional.of(((class_2248)WAXABLES.get((Object)block)).method_9564());
        }
        if (newState.isPresent()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_24478.method_23889(serverPlayer, pos, held);
            }
            class_2680 getState = (class_2680)newState.get();
            Collection properties = state.method_28501();
            for (class_2769 property : properties) {
                getState = (class_2680)getState.method_11657(property, state.method_11654(property));
            }
            level.method_8652(pos, getState, 11);
            if (held.method_7963()) {
                held.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    public static void handleRandomTick(class_3218 level, class_2338 pos, class_2680 state, Random random) {
        double d = random.nextDouble();
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof IWeatherableIron)) {
            return;
        }
        IWeatherableIron iron = (IWeatherableIron)class_22482;
        if (WEATHERING_ORDER.contains(iron)) {
            double chance = WeatheringIron.multiplyByTouchingFaces(level, pos);
            if (chance == 0.0) {
                return;
            }
            if (WeatheringIron.hasBubbleColumn(level, pos)) {
                chance *= bubbleColumnMultiplier;
            }
            if (d <= chance) {
                int i = WEATHERING_ORDER.indexOf(iron);
                if (!iron.isFullyOxidised()) {
                    Collection properties = state.method_28501();
                    class_2248 nextBlock = WEATHERING_ORDER.get(i + 1);
                    class_2680 nextState = nextBlock.method_9564();
                    for (class_2769 property : properties) {
                        nextState = (class_2680)nextState.method_11657(property, state.method_11654(property));
                    }
                    LogHelper.debug(WeatheringIron.class, "Weathering block to " + nextBlock + ", d = " + d + ", chance = " + chance, ", pos = " + pos);
                    level.method_8501(pos, nextState);
                }
            }
        }
    }

    public static int facesTouchingWater(class_3218 level, class_2338 pos) {
        int faces = 0;
        for (class_2350 direction : class_2350.values()) {
            if (!level.method_22351(pos.method_10093(direction))) continue;
            ++faces;
        }
        return faces;
    }

    public static double multiplyByTouchingFaces(class_3218 level, class_2338 pos) {
        int faces = WeatheringIron.facesTouchingWater(level, pos);
        if (facesIncreaseWeathering && faces > 1) {
            double newChance = chance + faceMultiplier * (double)faces;
            LogHelper.debug(WeatheringIron.class, "Face weathering, faces = " + faces + ", chance now = " + newChance + ", pos = " + pos, new Object[0]);
            return newChance;
        }
        if (faces > 0) {
            return chance;
        }
        return 0.0;
    }

    public static boolean hasBubbleColumn(class_3218 level, class_2338 pos) {
        boolean has;
        boolean bl = has = level.method_8320(pos.method_10074()).method_26204() == class_2246.field_10422;
        if (has) {
            LogHelper.debug(WeatheringIron.class, "Bubble column weathering, pos = " + pos, new Object[0]);
        }
        return has;
    }

    @Nullable
    public static class_1799 tryDispense(class_2342 source, class_1799 stack) {
        class_2338 pos = source.method_10122().method_10093((class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918));
        class_3218 level = source.method_10207();
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (WAXABLES.containsKey((Object)block)) {
            class_2680 newState = ((class_2248)WAXABLES.get((Object)block)).method_9564();
            level.method_8501(pos, newState);
            level.method_20290(3003, pos, 0);
            stack.method_7934(1);
            return stack;
        }
        return null;
    }

    static {
        WEATHERING_ORDER = new ArrayList<class_2248>();
        WAXABLES = HashBiMap.create();
        facesIncreaseWeathering = true;
        faceMultiplier = 0.008;
        chance = 0.006;
        bubbleColumnMultiplier = 4.0;
    }
}

