/*
 * Decompiled with CFR 0.152.
 */
package io.github.coolmineman.bitsandchisels;

import io.github.coolmineman.bitsandchisels.BitMeshes;
import io.github.coolmineman.bitsandchisels.BitNbtUtil;
import io.github.coolmineman.bitsandchisels.BitsAndChisels;
import io.github.coolmineman.bitsandchisels.BitsBlock;
import io.github.coolmineman.bitsandchisels.mixin.SimpleVoxelShapeFactory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_244;
import net.minecraft.class_2487;
import net.minecraft.class_251;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class BitsBlockEntity
extends class_2586
implements RenderAttachmentBlockEntity {
    private class_2680[][][] states;
    @Environment(value=EnvType.CLIENT)
    protected Mesh mesh;
    protected class_265 shape = class_259.method_1077();
    protected class_2487 nbtCache;
    private boolean alive = false;

    public BitsBlockEntity(class_2338 class_23382, class_2680 class_26802) {
        this(class_2246.field_10124.method_9564(), class_23382, class_26802, false);
    }

    public BitsBlockEntity(class_2680 class_26802, class_2338 class_23382, class_2680 class_26803, boolean bl) {
        this(new class_2680[16][16][16], class_23382, class_26803, bl);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    this.states[i][j][k] = class_26802;
                }
            }
        }
    }

    public BitsBlockEntity(class_2680[][][] class_2680Array, class_2338 class_23382, class_2680 class_26802, boolean bl) {
        super(BitsAndChisels.BITS_BLOCK_ENTITY, class_23382, class_26802);
        this.states = class_2680Array;
        this.alive = bl;
    }

    public void method_11007(class_2487 class_24872) {
        super.method_11007(class_24872);
        if (!this.alive) {
            return;
        }
        if (this.nbtCache == null) {
            BitsAndChisels.LOGGER.error("NbtCache should not be null!");
            BitNbtUtil.write3DBitArray(class_24872, this.states);
        } else {
            class_24872.method_10543(this.nbtCache);
        }
    }

    public void method_11014(class_2487 class_24872) {
        super.method_11014(class_24872);
        BitNbtUtil.read3DBitArray(class_24872, this.states);
        this.rebuildShape();
        if (this.method_10997() != null && this.method_10997().field_9236) {
            this.postFromClientTag();
        }
        this.rebuildNbtCache();
        this.alive = true;
    }

    private void rebuildNbtCache() {
        class_2487 class_24872 = new class_2487();
        BitNbtUtil.write3DBitArray(class_24872, this.states);
        this.nbtCache = class_24872;
    }

    public void setState(int n, int n2, int n3, class_2680 class_26802) {
        this.states[n][n2][n3] = class_26802;
        this.alive = true;
    }

    public void setStates(class_2680[][][] class_2680Array) {
        this.states = class_2680Array;
    }

    public void rebuildServer() {
        this.rebuildShape();
        this.rebuildNbtCache();
    }

    public class_2680 getState(int n, int n2, int n3) {
        return this.states[n][n2][n3];
    }

    public class_2680[][][] getStates() {
        return this.states;
    }

    protected void rebuildShape() {
        int n;
        boolean bl = true;
        class_244 class_2442 = new class_244(16, 16, 16);
        class_2680 class_26802 = this.states[0][0][0];
        int n2 = 0;
        for (int i = 0; i < 16; ++i) {
            for (n = 0; n < 16; ++n) {
                for (int j = 0; j < 16; ++j) {
                    class_2680 class_26803 = this.states[i][n][j];
                    n2 += class_26803.method_26213();
                    if (!class_26803.method_26215()) {
                        class_2442.method_1049(i, n, j);
                    }
                    if (class_26802 == class_26803) continue;
                    bl = false;
                }
            }
        }
        this.shape = SimpleVoxelShapeFactory.getSimpleVoxelShape((class_251)class_2442);
        if (this.field_11863 != null) {
            class_2680 class_26804 = this.field_11863.method_8320(this.field_11867);
            if (bl) {
                this.field_11863.method_8501(this.field_11867, this.states[0][0][0]);
            }
            n = class_3532.method_15340((int)((int)(Math.sqrt(n2) * 0.0625)), (int)0, (int)16);
            if ((Integer)class_26804.method_11654((class_2769)BitsBlock.LIGHT_LEVEL) != n) {
                this.field_11863.method_8652(this.field_11867, (class_2680)class_26804.method_11657((class_2769)BitsBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(n)), 0);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected void rebuildMesh() {
        this.mesh = BitMeshes.createMesh(this.states, this.field_11863, this.field_11867);
    }

    public void postFromClientTag() {
        this.rebuildMesh();
        class_310.method_1551().field_1769.method_18146(this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260(), this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260());
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_39026((class_2586)this, class_25862 -> ((BitsBlockEntity)((Object)class_25862)).method_38244());
    }

    public void sync() {
        ((class_3218)this.field_11863).method_14178().method_14128(this.method_11016());
    }

    public class_2487 method_16887() {
        this.sync();
        return new class_2487();
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public Object getRenderAttachmentData() {
        return this.mesh;
    }
}

