/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftools.api.storage.IStorageScanner;
import mcjty.rftoolscontrol.api.parameters.BlockSide;
import mcjty.rftoolscontrol.api.parameters.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public class InventoryTools {
    public static int countItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, ItemStack itemMatcher, boolean meta, boolean nbt, boolean oredict, int maxToCount) {
        if (itemHandler != null) {
            int cnt = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (!InventoryTools.areItemsEqual(itemMatcher, stack, meta, nbt, oredict, false) || maxToCount == -1 || (cnt += stack.func_190916_E()) < maxToCount) continue;
                return maxToCount;
            }
            return cnt;
        }
        if (scanner != null) {
            int cnt = scanner.countItems(itemMatcher, true, oredict);
            if (maxToCount != -1 && cnt >= maxToCount) {
                return maxToCount;
            }
            return cnt;
        }
        return 0;
    }

    public static boolean areItemsEqual(ItemStack item1, ItemStack item2, boolean meta, boolean nbt, boolean oredict, boolean count) {
        if (count && item1.func_190916_E() != item2.func_190916_E()) {
            return false;
        }
        if (oredict ? !OreDictionary.itemMatches((ItemStack)item1, (ItemStack)item2, (boolean)false) : item1.func_77973_b() != item2.func_77973_b()) {
            return false;
        }
        if (meta && item1.func_77952_i() != item2.func_77952_i()) {
            return false;
        }
        return !nbt || ItemStack.func_77970_a((ItemStack)item1, (ItemStack)item2);
    }

    private static ItemStack extractItemFromAllSlot(IItemHandler itemHandler, ItemStack item, int amount, boolean doExtract) {
        ItemStack resItemStack = null;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i).func_77946_l();
            if (!InventoryTools.areItemsEqual(item, stack, true, true, true, false)) continue;
            if (resItemStack == null) {
                resItemStack = itemHandler.extractItem(i, amount, !doExtract);
            } else {
                ItemStack extracted = itemHandler.extractItem(i, amount - resItemStack.func_190916_E(), !doExtract);
                resItemStack.func_190920_e(resItemStack.func_190916_E() + extracted.func_190916_E());
            }
            if (amount == resItemStack.func_190916_E()) break;
        }
        return resItemStack;
    }

    public static ItemStack extractItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, @Nullable Integer amount, boolean routable, boolean oredict, boolean strictnbt, ItemStack itemMatcher, @Nullable Integer slot) {
        if (itemHandler != null) {
            if (slot != null) {
                if (!itemMatcher.func_190926_b()) {
                    if (!InventoryTools.areItemsEqual(itemMatcher, itemHandler.getStackInSlot(slot.intValue()), true, strictnbt, oredict, false)) {
                        return ItemStack.field_190927_a;
                    }
                    return itemHandler.extractItem(slot.intValue(), amount == null ? itemMatcher.func_77976_d() : amount.intValue(), false);
                }
                return itemHandler.extractItem(slot.intValue(), amount == null ? 64 : amount, false);
            }
            if (!itemMatcher.func_190926_b()) {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    int amountTodo;
                    ItemStack stack = itemHandler.getStackInSlot(i).func_77946_l();
                    int n = amountTodo = amount == null ? stack.func_77976_d() : amount.intValue();
                    if (!InventoryTools.areItemsEqual(itemMatcher, stack, true, strictnbt, oredict, false) || InventoryTools.extractItemFromAllSlot(itemHandler, stack, amountTodo, false).func_190916_E() < amountTodo) continue;
                    return InventoryTools.extractItemFromAllSlot(itemHandler, stack, amountTodo, true);
                }
            } else {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack stack = itemHandler.getStackInSlot(i);
                    if (stack.func_190926_b() || amount != null && amount > stack.func_190916_E()) continue;
                    return itemHandler.extractItem(i, amount == null ? 64 : amount, false);
                }
            }
        } else if (scanner != null) {
            return scanner.requestItem(itemMatcher, amount == null ? itemMatcher.func_77976_d() : amount.intValue(), routable, oredict);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack tryExtractItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, @Nullable Integer amount, boolean routable, boolean oredict, boolean strictnbt, ItemStack itemMatcher, @Nullable Integer slot) {
        int cnt;
        if (itemHandler != null) {
            ItemStack stack;
            int i;
            if (slot != null) {
                if (!itemMatcher.func_190926_b()) {
                    if (!InventoryTools.areItemsEqual(itemMatcher, itemHandler.getStackInSlot(slot.intValue()), true, strictnbt, oredict, false)) {
                        return ItemStack.field_190927_a;
                    }
                    return itemHandler.extractItem(slot.intValue(), amount == null ? itemMatcher.func_77976_d() : amount.intValue(), true);
                }
                return itemHandler.extractItem(slot.intValue(), amount == null ? 64 : amount, true);
            }
            if (!itemMatcher.func_190926_b()) {
                for (i = 0; i < itemHandler.getSlots(); ++i) {
                    int amountTodo;
                    stack = itemHandler.getStackInSlot(i);
                    int n = amountTodo = amount == null ? stack.func_77976_d() : amount.intValue();
                    if (!InventoryTools.areItemsEqual(itemMatcher, stack, true, strictnbt, oredict, false) || InventoryTools.extractItemFromAllSlot(itemHandler, stack, amountTodo, false).func_190916_E() < amountTodo) continue;
                    return InventoryTools.extractItemFromAllSlot(itemHandler, stack, amountTodo, false);
                }
            } else {
                for (i = 0; i < itemHandler.getSlots(); ++i) {
                    stack = itemHandler.getStackInSlot(i);
                    if (stack.func_190926_b() || amount != null && amount > stack.func_190916_E()) continue;
                    return itemHandler.extractItem(i, amount == null ? 64 : amount, true);
                }
            }
        }
        if (scanner != null && (cnt = scanner.countItems(itemMatcher, routable, oredict)) > 0) {
            ItemStack copy = itemMatcher.func_77946_l();
            int amount1 = Math.min(cnt, amount == null ? itemMatcher.func_77976_d() : amount.intValue());
            if (amount1 <= 0) {
                copy.func_190920_e(0);
            } else {
                copy.func_190920_e(amount1);
            }
            return copy;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack insertItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, @Nonnull ItemStack item, @Nullable Integer slot) {
        if (itemHandler != null) {
            if (slot == null) {
                return ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)item, (boolean)false);
            }
            return itemHandler.insertItem(slot.intValue(), item, false);
        }
        if (scanner != null) {
            int cnt = scanner.insertItem(item);
            if (cnt > 0) {
                ItemStack copy = item.func_77946_l();
                if (cnt <= 0) {
                    copy.func_190920_e(0);
                } else {
                    copy.func_190920_e(cnt);
                }
                return copy;
            }
            return ItemStack.field_190927_a;
        }
        return item;
    }

    public static String inventoryToString(Inventory inv) {
        String s = StringUtils.left((String)inv.getSide().func_176610_l().toUpperCase(), (int)1);
        if (inv.getIntSide() == null) {
            s = s + "/*";
        } else {
            String is = StringUtils.left((String)inv.getIntSide().func_176610_l().toUpperCase(), (int)1);
            s = s + "/" + is;
        }
        if (inv.getNodeName() == null) {
            return s;
        }
        return inv.getNodeName() + " " + s;
    }

    @Nullable
    public static Inventory inventoryFromString(String s) {
        if (s == null) {
            return null;
        }
        int indexOf = s.lastIndexOf(47);
        if (indexOf == -1) {
            return null;
        }
        if (s.length() <= indexOf + 1) {
            return null;
        }
        EnumFacing side = InventoryTools.getSideFromChar(s.charAt(indexOf - 1));
        if (side == null) {
            return null;
        }
        EnumFacing intSide = InventoryTools.getSideFromChar(s.charAt(indexOf + 1));
        int indexSpace = s.lastIndexOf(32);
        if (indexSpace <= 0) {
            return new Inventory(null, side, intSide);
        }
        return new Inventory(s.substring(0, indexSpace), side, intSide);
    }

    public static EnumFacing getSideFromChar(char is) {
        switch (is) {
            case '*': {
                return null;
            }
            case 'D': {
                return EnumFacing.DOWN;
            }
            case 'U': {
                return EnumFacing.UP;
            }
            case 'W': {
                return EnumFacing.WEST;
            }
            case 'E': {
                return EnumFacing.EAST;
            }
            case 'S': {
                return EnumFacing.SOUTH;
            }
            case 'N': {
                return EnumFacing.NORTH;
            }
        }
        return null;
    }

    public static String blockSideToString(BlockSide bc) {
        String s = bc.getSide() == null ? "*" : StringUtils.left((String)bc.getSide().func_176610_l().toUpperCase(), (int)1);
        if (bc.getNodeName() == null) {
            return s;
        }
        return bc.getNodeName() + " " + s;
    }

    @Nullable
    public static BlockSide blockSideFromString(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return null;
        }
        EnumFacing side = InventoryTools.getSideFromChar(s.charAt(s.length() - 1));
        int indexOf = s.lastIndexOf(32);
        if (indexOf <= 0) {
            return new BlockSide(null, side);
        }
        return new BlockSide(s.substring(0, indexOf), side);
    }
}

