/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler;

import java.util.Random;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.config.Worldgen;
import lumien.randomthings.item.ModItems;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.LootTableLoadEvent;

public class LootHandler {
    static LootCondition onlyFound = new LootCondition(){

        public boolean func_186618_a(Random rand, LootContext context) {
            return context.func_186495_b() instanceof EntityPlayer && !(context.func_186495_b() instanceof FakePlayer);
        }
    };

    public static void addLoot(LootTableLoadEvent event) {
        LootTable table = event.getTable();
        if (event.getName().equals((Object)LootTableList.field_186422_d)) {
            if (Worldgen.LAVA_CHARM) {
                LootHandler.addSingleItemWithChance(table, ModItems.lavaCharm, 5);
            }
            if (Worldgen.SUMMONING_PENDULUM) {
                LootHandler.addSingleItemWithChance(table, ModItems.summoningPendulum, 10);
            }
            if (Worldgen.MAGIC_HOOD) {
                LootHandler.addSingleItemWithChance(table, (Item)ModItems.magicHood, 5);
            }
            if (Worldgen.SLIME_CUBE) {
                LootHandler.addSingleItemWithChance(table, Item.func_150898_a((Block)ModBlocks.slimeCube), 10);
            }
            if (Worldgen.NUMBERED_COILS) {
                LootHandler.addSingleItemWithChance(table, Item.func_150898_a((Block)ModBlocks.spectreCoilNumber), 10, onlyFound);
            }
        } else if (Worldgen.LAVA_CHARM && event.getName().equals((Object)LootTableList.field_186425_g)) {
            LootHandler.addSingleItemWithChance(table, ModItems.lavaCharm, 30);
        } else if (Worldgen.NUMBERED_COILS && event.getName().equals((Object)LootTableList.field_186424_f)) {
            LootHandler.addSingleItemWithChance(table, Item.func_150898_a((Block)ModBlocks.spectreCoilNumber), 8, onlyFound);
        } else if (Worldgen.MAGIC_HOOD && event.getName().equals((Object)LootTableList.field_186423_e)) {
            LootHandler.addSingleItemWithChance(table, (Item)ModItems.magicHood, 15);
        } else if (Worldgen.SUMMONING_PENDULUM && event.getName().equals((Object)LootTableList.field_186428_j)) {
            LootHandler.addSingleItemWithChance(table, ModItems.summoningPendulum, 50);
        } else if (Worldgen.SLIME_CUBE && event.getName().equals((Object)LootTableList.field_186430_l)) {
            LootHandler.addSingleItemWithChance(table, Item.func_150898_a((Block)ModBlocks.slimeCube), 80);
        } else if (Worldgen.NUMBERED_COILS && event.getName().equals((Object)LootTableList.field_186421_c)) {
            LootHandler.addSingleItemWithChance(table, Item.func_150898_a((Block)ModBlocks.spectreCoilNumber), 30, onlyFound);
        }
        if (Worldgen.BIOME_CRYSTAL && event.getName().toString().startsWith("minecraft:chests/")) {
            LootEntryItem crystalEntry = new LootEntryItem((Item)ModItems.biomeCrystal, 1, 0, new LootFunction[]{new LootFunction(new LootCondition[0]){

                public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
                    Object[] locationArray = Biome.field_185377_q.func_148742_b().toArray();
                    ResourceLocation randomLocation = (ResourceLocation)locationArray[rand.nextInt(locationArray.length)];
                    stack.func_77982_d(new NBTTagCompound());
                    stack.func_77978_p().func_74778_a("biomeName", randomLocation.toString());
                    return stack;
                }
            }}, new LootCondition[0], "randomthings:biomeCrystal");
            LootPool crystalPool = new LootPool(new LootEntry[]{crystalEntry}, new LootCondition[]{new RandomChance(0.2f)}, new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "randomthings:biomeCrystal");
            table.addPool(crystalPool);
        }
    }

    private static void addSingleItemWithChance(LootTable table, Item item, int chance) {
        String itemName = item.getRegistryName().func_110623_a().toString();
        LootEntryItem entryItem = new LootEntryItem(item, chance, 0, new LootFunction[0], new LootCondition[0], "item");
        LootEntryEmpty entryEmpty = new LootEntryEmpty(100 - chance, 0, new LootCondition[0], "empty");
        LootPool pool = new LootPool(new LootEntry[]{entryItem, entryEmpty}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), itemName);
        table.addPool(pool);
    }

    private static void addSingleItemWithChance(LootTable table, Item item, int chance, LootFunction function) {
        String itemName = item.getRegistryName().func_110623_a().toString();
        LootEntryItem entryItem = new LootEntryItem(item, chance, 0, new LootFunction[]{function}, new LootCondition[0], "item");
        LootEntryEmpty entryEmpty = new LootEntryEmpty(100 - chance, 0, new LootCondition[0], "empty");
        LootPool pool = new LootPool(new LootEntry[]{entryItem, entryEmpty}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), itemName);
        table.addPool(pool);
    }

    private static void addSingleItemWithChance(LootTable table, Item item, int chance, LootFunction function, LootCondition condition) {
        String itemName = item.getRegistryName().func_110623_a().toString();
        LootEntryItem entryItem = new LootEntryItem(item, chance, 0, new LootFunction[]{function}, new LootCondition[0], "item");
        LootEntryEmpty entryEmpty = new LootEntryEmpty(100 - chance, 0, new LootCondition[0], "empty");
        LootPool pool = new LootPool(new LootEntry[]{entryItem, entryEmpty}, new LootCondition[]{condition}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), itemName);
        table.addPool(pool);
    }

    private static void addSingleItemWithChance(LootTable table, Item item, int chance, LootCondition condition) {
        String itemName = item.getRegistryName().func_110623_a().toString();
        LootEntryItem entryItem = new LootEntryItem(item, chance, 0, new LootFunction[0], new LootCondition[0], "item");
        LootEntryEmpty entryEmpty = new LootEntryEmpty(100 - chance, 0, new LootCondition[0], "empty");
        LootPool pool = new LootPool(new LootEntry[]{entryItem, entryEmpty}, new LootCondition[]{condition}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), itemName);
        table.addPool(pool);
    }
}

