/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityDreadQueen;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.IDreadMob;
import com.github.alexthe666.iceandfire.entity.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAITempt;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIEscort;
import com.github.alexthe666.iceandfire.entity.ai.DragonAILookIdle;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWander;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWatchClosest;
import com.github.alexthe666.iceandfire.entity.ai.DreadAIDragonFindQueen;
import com.github.alexthe666.iceandfire.entity.ai.DreadAITargetNonDread;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityBlackFrostDragon
extends EntityIceDragon
implements IDreadMob {
    protected static final DataParameter<Optional<UUID>> COMMANDER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityBlackFrostDragon.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityBlackFrostDragon(World worldIn) {
        super(worldIn);
        this.maximumArmor = 70.0;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COMMANDER_UNIQUE_ID, (Object)Optional.absent());
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        EntityDreadQueen queen = this.getRidingQueen();
        if (queen != null && queen.func_70638_az() != null) {
            this.func_70624_b(queen.func_70638_az());
        }
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DreadAIDragonFindQueen(this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new DragonAIEscort(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AquaticAITempt((EntityCreature)this, 1.0, IafItemRegistry.frost_stew, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DragonAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DragonAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DragonAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new DreadAITargetNonDread((EntityCreature)this, EntityLivingBase.class, false, (Predicate<? super EntityLivingBase>)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof EntityLivingBase && DragonUtils.canHostilesTarget(entity);
            }
        }));
        this.field_70715_bh.func_75776_a(5, new DragonAITargetItems((EntityCreature)this, false));
    }

    @Override
    @Nullable
    public Entity func_184179_bs() {
        Entity commander = this.getCommander();
        if (commander != null) {
            for (Entity passenger : this.func_184188_bt()) {
                if (!passenger.func_110124_au().equals(commander.func_110124_au())) continue;
                return passenger;
            }
        }
        return super.func_184179_bs();
    }

    @Override
    public boolean func_82171_bF() {
        return false;
    }

    @Override
    public boolean isAllowedToTriggerFlight() {
        return this.hasFlightClearance() && !this.func_70906_o() && !this.func_70631_g_() && !this.isSleeping() && this.canMove() && this.field_70122_E;
    }

    @Override
    public boolean canMove() {
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class);
        if (properties != null && properties.isStone) {
            return false;
        }
        return !this.func_70906_o() && !this.isSleeping() && !this.isModelDead() && this.sleepProgress == 0.0f && this.getAnimation() != ANIMATION_SHAKEPREY;
    }

    @Override
    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v);
        }
        if (this.func_184196_w(passenger)) {
            if (!(passenger instanceof EntityDreadQueen || this.func_184179_bs() != null && this.func_184179_bs().func_110124_au().equals(passenger.func_110124_au()))) {
                this.updatePreyInMouth(passenger);
            } else {
                if (this.isModelDead()) {
                    passenger.func_184210_p();
                }
                if (passenger instanceof EntityDreadQueen) {
                    passenger.field_70177_z = this.field_70177_z;
                    ((EntityDreadQueen)passenger).field_70761_aq = this.field_70177_z;
                } else {
                    this.field_70761_aq = this.field_70177_z;
                    this.field_70177_z = passenger.field_70177_z;
                }
                Vec3d riderPos = this.getRiderPosition();
                passenger.func_70107_b(riderPos.field_72450_a, riderPos.field_72448_b + (double)passenger.field_70131_O, riderPos.field_72449_c);
                this.field_70138_W = 1.0f;
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getCommanderId() == null) {
            compound.func_74778_a("CommanderUUID", "");
        } else {
            compound.func_74778_a("CommanderUUID", this.getCommanderId().toString());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_150297_b("CommanderUUID", 8)) {
            s = compound.func_74779_i("CommanderUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setCommanderId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        return entityIn instanceof IDreadMob || super.func_184191_r(entityIn);
    }

    @Override
    public boolean shouldRiderSit() {
        return this.func_184179_bs() != null || this.getRidingQueen() != null;
    }

    public EntityDreadQueen getRidingQueen() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof EntityDreadQueen)) continue;
            return (EntityDreadQueen)passenger;
        }
        return null;
    }

    @Nullable
    public UUID getCommanderId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(COMMANDER_UNIQUE_ID)).orNull();
    }

    public void setCommanderId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(COMMANDER_UNIQUE_ID, (Object)Optional.fromNullable((Object)uuid));
    }

    @Override
    public Entity getCommander() {
        try {
            Entity entity;
            EntityPlayer player;
            UUID uuid = this.getCommanderId();
            EntityPlayer entityPlayer = player = uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
            if (player != null) {
                return player;
            }
            if (!this.field_70170_p.field_72995_K && (entity = this.field_70170_p.func_73046_m().func_71218_a(this.field_71093_bK).func_175733_a(uuid)) instanceof EntityLivingBase) {
                return entity;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    @Override
    public String getVariantName(int variant) {
        return "blue_";
    }

    @Override
    public Item getVariantScale(int variant) {
        return IafItemRegistry.dragonscales_blue;
    }

    @Override
    public Item getVariantEgg(int variant) {
        return IafItemRegistry.dragonegg_blue;
    }

    @Override
    public boolean func_70877_b(@Nullable ItemStack stack) {
        return false;
    }

    @Override
    public int getDragonStage() {
        return 5;
    }

    @Override
    public int getAgeInDays() {
        return 125;
    }

    @Override
    public int getArmorOrdinal(ItemStack stack) {
        return 0;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    public boolean isMale() {
        return false;
    }

    @Override
    public boolean isDaytime() {
        return true;
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setGender(this.func_70681_au().nextBoolean());
        this.setSleeping(false);
        this.updateAttributes();
        this.growDragon(125);
        this.func_70691_i((float)this.maximumHealth);
        this.usingGroundAttack = true;
        this.setHunger(50);
        return livingdata;
    }

    @Override
    public boolean func_104002_bU() {
        return true;
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    protected int getFlightChancePerTick() {
        return 15;
    }
}

